/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.pool;

import io.gatling.http.client.pool.IpAndPort;
import io.gatling.http.client.ssl.Tls;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CoalescingChannelPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoalescingChannelPool.class);
    private final Map<Long, Map<IpAndPort, Map.Entry<Set<String>, Queue<Channel>>>> channels = new HashMap<Long, Map<IpAndPort, Map.Entry<Set<String>, Queue<Channel>>>>(1000);
    private final Map<Long, Map<Channel, Queue<Channel>>> cleanUpMap = new HashMap<Long, Map<Channel, Queue<Channel>>>(1000);

    CoalescingChannelPool() {
    }

    private Map<IpAndPort, Map.Entry<Set<String>, Queue<Channel>>> clientChannels(long l2) {
        return this.channels.computeIfAbsent(l2, l -> new HashMap(2));
    }

    private Map<Channel, Queue<Channel>> clientCleanUpMap(long l2) {
        return this.cleanUpMap.computeIfAbsent(l2, l -> new HashMap(2));
    }

    void addEntry(long l, IpAndPort ipAndPort, Set<String> set, Channel channel) {
        Queue<Channel> queue;
        LOGGER.debug("Adding entry {} with subjectAlternativeNames {} to coalescing pool", (Object)ipAndPort, set);
        Map<IpAndPort, Map.Entry<Set<String>, Queue<Channel>>> map = this.clientChannels(l);
        Map.Entry<Set<String>, Queue<Channel>> entry = map.get(ipAndPort);
        if (entry == null) {
            queue = new ArrayDeque<Channel>(2);
            queue.add(channel);
            map.put(ipAndPort, new AbstractMap.SimpleEntry<Set<String>, Queue<Channel>>(set, queue));
        } else {
            queue = entry.getValue();
            entry.getValue().offer(channel);
        }
        this.clientCleanUpMap(l).put(channel, queue);
    }

    Channel getCoalescedChannel(long l, String string, List<InetSocketAddress> list) {
        for (InetSocketAddress inetSocketAddress : list) {
            IpAndPort ipAndPort = new IpAndPort(inetSocketAddress.getAddress().getAddress(), inetSocketAddress.getPort());
            Map.Entry<Set<String>, Queue<Channel>> entry = this.clientChannels(l).get(ipAndPort);
            if (entry == null) continue;
            for (String string2 : entry.getKey()) {
                if (!Tls.isCertificateAuthoritative(string2, string)) continue;
                for (Channel channel : entry.getValue()) {
                    if (!channel.isActive()) continue;
                    return channel;
                }
            }
        }
        return null;
    }

    void deleteIdleEntry(long l, Channel channel) {
        Queue<Channel> queue;
        Map<Channel, Queue<Channel>> map = this.cleanUpMap.get(l);
        if (map != null && (queue = map.get(channel)) != null) {
            queue.remove(channel);
            map.remove(channel);
        }
    }

    void deleteClientEntries(long l) {
        this.channels.remove(l);
        this.cleanUpMap.remove(l);
    }
}

