/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.uri;

import io.gatling.http.client.Param;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.MiscUtils;
import io.gatling.netty.util.StringBuilderPool;
import io.gatling.netty.util.Utf8UrlEncoder;
import java.util.List;

public enum UriEncoder {
    FIXING{

        @Override
        public String encodePath(String string) {
            return Utf8UrlEncoder.encodePath((String)string);
        }

        private void encodeAndAppendQueryParam(StringBuilder stringBuilder, CharSequence charSequence, CharSequence charSequence2) {
            Utf8UrlEncoder.encodeAndAppendQueryElement((StringBuilder)stringBuilder, (CharSequence)charSequence);
            if (charSequence2 != null) {
                stringBuilder.append('=');
                Utf8UrlEncoder.encodeAndAppendQueryElement((StringBuilder)stringBuilder, (CharSequence)charSequence2);
            }
            stringBuilder.append('&');
        }

        private void encodeAndAppendQueryParams(StringBuilder stringBuilder, List<Param> list) {
            for (Param param : list) {
                this.encodeAndAppendQueryParam(stringBuilder, param.getName(), param.getValue());
            }
        }

        @Override
        protected String withQueryWithParams(String string, List<Param> list) {
            StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
            Utf8UrlEncoder.encodeAndAppendQuery((StringBuilder)stringBuilder, (String)string);
            stringBuilder.append('&');
            this.encodeAndAppendQueryParams(stringBuilder, list);
            stringBuilder.setLength(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        @Override
        protected String withQueryWithoutParams(String string) {
            StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
            Utf8UrlEncoder.encodeAndAppendQuery((StringBuilder)stringBuilder, (String)string);
            return stringBuilder.toString();
        }

        @Override
        protected String withoutQueryWithParams(List<Param> list) {
            StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
            this.encodeAndAppendQueryParams(stringBuilder, list);
            stringBuilder.setLength(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
    }
    ,
    RAW{

        @Override
        public String encodePath(String string) {
            return string;
        }

        private void appendRawQueryParam(StringBuilder stringBuilder, String string, String string2) {
            stringBuilder.append(string);
            if (string2 != null) {
                stringBuilder.append('=').append(string2);
            }
            stringBuilder.append('&');
        }

        private void appendRawQueryParams(StringBuilder stringBuilder, List<Param> list) {
            for (Param param : list) {
                this.appendRawQueryParam(stringBuilder, param.getName(), param.getValue());
            }
        }

        @Override
        protected String withQueryWithParams(String string, List<Param> list) {
            StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
            stringBuilder.append(string);
            this.appendRawQueryParams(stringBuilder, list);
            stringBuilder.setLength(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        @Override
        protected String withQueryWithoutParams(String string) {
            return string;
        }

        @Override
        protected String withoutQueryWithParams(List<Param> list) {
            StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
            this.appendRawQueryParams(stringBuilder, list);
            stringBuilder.setLength(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }
    };


    public static UriEncoder uriEncoder(boolean bl) {
        return bl ? FIXING : RAW;
    }

    protected abstract String withQueryWithParams(String var1, List<Param> var2);

    protected abstract String withQueryWithoutParams(String var1);

    protected abstract String withoutQueryWithParams(List<Param> var1);

    private String withQuery(String string, List<Param> list) {
        return MiscUtils.isNonEmpty(list) ? this.withQueryWithParams(string, list) : this.withQueryWithoutParams(string);
    }

    private String withoutQuery(List<Param> list) {
        return MiscUtils.isNonEmpty(list) ? this.withoutQueryWithParams(list) : null;
    }

    public Uri encode(Uri uri, List<Param> list) {
        String string = this.encodePath(uri.getPath());
        String string2 = this.encodeQuery(uri.getQuery(), list);
        return new Uri(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), string, string2, uri.getFragment());
    }

    protected abstract String encodePath(String var1);

    private String encodeQuery(String string, List<Param> list) {
        return MiscUtils.isNonEmpty(string) ? this.withQuery(string, list) : this.withoutQuery(list);
    }
}

