/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.CompilationException;
import io.gatling.mojo.Fork;
import io.gatling.mojo.GatlingMojoUtils;
import io.gatling.mojo.GatlingSimulationAssertionsFailedException;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.exec.ExecuteException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="execute", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class GatlingMojo
extends AbstractMojo {
    public static final String SCALA_VERSION = "2.11.4";
    public static final String COMPILER_MAIN_CLASS = "io.gatling.compiler.ZincCompiler";
    public static final List<String> ZINC_JVM_ARGS = Collections.singletonList("-Xss10M");
    public static final String[] SCALA_INCLUDES = new String[]{"**/*.scala"};
    public static final String GATLING_MAIN_CLASS = "io.gatling.app.Gatling";
    public static final List<String> GATLING_JVM_ARGS = Arrays.asList("-server", "-XX:+UseThreadPriorities", "-XX:ThreadPriorityPolicy=42", "-Xms512M", "-Xmx512M", "-Xmn100M", "-XX:+HeapDumpOnOutOfMemoryError", "-XX:+AggressiveOpts", "-XX:+OptimizeStringConcat", "-XX:+UseFastAccessorMethods", "-XX:+UseParNewGC", "-XX:+UseConcMarkSweepGC", "-XX:+CMSParallelRemarkEnabled");
    @Parameter(property="gatling.noReports", alias="nr", defaultValue="false")
    private boolean noReports;
    @Parameter(property="gatling.reportsOnly", alias="ro")
    private String reportsOnly;
    @Parameter(property="gatling.configFolder", alias="cd", defaultValue="${basedir}/src/test/resources")
    private File configFolder;
    @Parameter(property="gatling.simulationsFolder", alias="sf", defaultValue="${basedir}/src/test/scala")
    private File simulationsFolder;
    @Parameter(property="gatling.simulationClass", alias="sc")
    private String simulationClass;
    @Parameter(property="gatling.dataFolder", alias="df", defaultValue="${basedir}/src/test/resources/data")
    private File dataFolder;
    @Parameter(property="gatling.bodiesFolder", alias="bdf", defaultValue="${basedir}/src/test/resources/bodies")
    private File bodiesFolder;
    @Parameter(property="gatling.resultsFolder", alias="rf", defaultValue="${basedir}/target/gatling/results")
    private File resultsFolder;
    @Parameter(property="gatling.jvmArgs")
    private List<String> jvmArgs;
    @Parameter(property="gatling.zincJvmArgs")
    private List<String> zincJvmArgs;
    @Parameter(property="gatling.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="gatling.outputName", alias="on")
    private String outputDirectoryBaseName;
    @Parameter(property="gatling.propagateSystemProperties", defaultValue="true")
    private boolean propagateSystemProperties;
    @Parameter(property="gatling.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="gatling.disableCompiler", defaultValue="false")
    private boolean disableCompiler;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepo;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepos;

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            this.resultsFolder.mkdirs();
            try {
                String testClasspath = this.buildTestClasspath();
                Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
                if (!this.disableCompiler) {
                    this.executeCompiler(this.zincJvmArgs(), testClasspath, toolchain);
                }
                this.executeGatling(this.gatlingJvmArgs(), this.gatlingArgs(), testClasspath, toolchain);
            }
            catch (Exception e) {
                if (this.failOnError) {
                    throw new MojoExecutionException("Gatling failed.", e);
                }
                this.getLog().warn((CharSequence)"There was some errors while running your simulation, but failOnError set to false won't fail your build.");
            }
        } else {
            this.getLog().info((CharSequence)"Skipping gatling-maven-plugin");
        }
    }

    private void executeCompiler(List<String> zincJvmArgs, String testClasspath, Toolchain toolchain) throws Exception {
        String compilerClasspath = this.buildCompilerClasspath();
        List<String> compilerArguments = this.compilerArgs(testClasspath);
        Fork forkedCompiler = new Fork(COMPILER_MAIN_CLASS, compilerClasspath, zincJvmArgs, compilerArguments, toolchain, false);
        try {
            forkedCompiler.run();
        }
        catch (ExecuteException e) {
            throw new CompilationException(e);
        }
    }

    private void executeGatling(List<String> gatlingJvmArgs, List<String> gatlingArgs, String testClasspath, Toolchain toolchain) throws Exception {
        Fork forkedGatling = new Fork(GATLING_MAIN_CLASS, testClasspath, gatlingJvmArgs, gatlingArgs, toolchain, this.propagateSystemProperties);
        try {
            forkedGatling.run();
        }
        catch (ExecuteException e) {
            if (e.getExitValue() == 2) {
                throw new GatlingSimulationAssertionsFailedException(e);
            }
            throw e;
        }
    }

    private String buildCompilerClasspath() throws Exception {
        URL[] classpathUrls = ((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs();
        ArrayList<String> compilerClasspathElements = new ArrayList<String>();
        for (URL url : classpathUrls) {
            compilerClasspathElements.add(new File(url.toURI()).getAbsolutePath());
        }
        compilerClasspathElements.add(GatlingMojoUtils.locateJar(GatlingMojo.class));
        return GatlingMojoUtils.toMultiPath(compilerClasspathElements);
    }

    private String buildTestClasspath() throws Exception {
        List testClasspathElements = this.mavenProject.getTestClasspathElements();
        testClasspathElements.add(this.configFolder.getPath());
        if (!this.disableCompiler) {
            testClasspathElements.add(this.getCompilerJar().getPath());
        }
        testClasspathElements.add(GatlingMojoUtils.locateJar(GatlingMojo.class));
        return GatlingMojoUtils.toMultiPath(testClasspathElements);
    }

    private File getCompilerJar() throws Exception {
        Artifact artifact = this.artifactFactory.createArtifact("org.scala-lang", "scala-compiler", SCALA_VERSION, "runtime", "jar");
        this.artifactResolver.resolve(artifact, this.remoteRepos, this.localRepo);
        return artifact.getFile();
    }

    private List<String> gatlingJvmArgs() {
        return this.jvmArgs != null ? this.jvmArgs : GATLING_JVM_ARGS;
    }

    private List<String> zincJvmArgs() {
        return this.zincJvmArgs != null ? this.zincJvmArgs : ZINC_JVM_ARGS;
    }

    private List<String> gatlingArgs() throws Exception {
        if (this.simulationClass == null) {
            List<String> simulations = this.resolveSimulations(this.simulationsFolder);
            if (simulations.isEmpty()) {
                this.getLog().error((CharSequence)"No simulations to run");
                throw new MojoFailureException("No simulations to run");
            }
            if (simulations.size() > 1) {
                this.getLog().error((CharSequence)"More than 1 simulation to run, need to specify one");
                throw new MojoFailureException("More than 1 simulation to run, need to specify one");
            }
            this.simulationClass = simulations.get(0);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("-df", this.dataFolder.getCanonicalPath(), "-rf", this.resultsFolder.getCanonicalPath(), "-bdf", this.bodiesFolder.getCanonicalPath(), "-sf", this.simulationsFolder.getCanonicalPath(), "-s", this.simulationClass, "-m"));
        if (this.noReports) {
            args.add("-nr");
        }
        if (this.reportsOnly != null) {
            args.addAll(Arrays.asList("-ro", this.reportsOnly));
        }
        if (this.outputDirectoryBaseName != null) {
            args.addAll(Arrays.asList("-on", this.outputDirectoryBaseName));
        }
        return args;
    }

    private List<String> compilerArgs(String classpathElements) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("-ccp", classpathElements));
        args.addAll(Arrays.asList("-sf", this.simulationsFolder.getCanonicalPath()));
        return args;
    }

    private List<String> resolveSimulations(File simulationsFolder) {
        DirectoryScanner scanner = new DirectoryScanner();
        this.getLog().debug((CharSequence)("effective simulationsFolder: " + simulationsFolder.getPath()));
        scanner.setBasedir(simulationsFolder);
        scanner.setIncludes(SCALA_INCLUDES);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        ArrayList<String> includedClassNames = new ArrayList<String>();
        for (String includedFile : includedFiles) {
            includedClassNames.add(GatlingMojoUtils.fileNameToClassName(includedFile));
        }
        this.getLog().debug((CharSequence)("resolved simulation classes: " + includedClassNames));
        return includedClassNames;
    }
}

