/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.recorder.config.RecorderPropertiesBuilder;
import io.gatling.recorder.controller.RecorderController;
import java.nio.file.Paths;
import javax.swing.JFrame;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala.Option;
import scala.collection.mutable.Map;

@Mojo(name="recorder", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class RecorderMojo
extends AbstractMojo {
    @Parameter(property="gatling.recorder.localPort", alias="lp")
    private Integer localPort;
    @Parameter(property="gatling.recorder.proxyHost", alias="ph")
    private String proxyHost;
    @Parameter(property="gatling.recorder.proxyPort", alias="pp")
    private Integer proxyPort;
    @Parameter(property="gatling.recorder.proxySslPort", alias="pps")
    private Integer proxySSLPort;
    @Parameter(property="gatling.recorder.outputFolder", alias="of", defaultValue="${basedir}/src/test/scala")
    private String outputFolder;
    @Parameter(property="gatling.recorder.bodiesFolder", alias="bdf", defaultValue="${basedir}/src/test/resources/bodies")
    private String bodiesFolder;
    @Parameter(property="gatling.recorder.className", alias="cn")
    private String className;
    @Parameter(property="gatling.recorder.package", alias="pkg", defaultValue="${project.groupId}")
    private String packageName;
    @Parameter(property="gatling.recorder.encoding", alias="enc")
    private String encoding;
    @Parameter(property="gatling.recorder.followRedirect", alias="fr")
    private Boolean followRedirect;
    @Parameter(property="gatling.recorder.recorderConfigFile", defaultValue="${basedir}/src/test/resources/recorder.conf")
    private String configFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        RecorderPropertiesBuilder props = new RecorderPropertiesBuilder();
        if (this.localPort != null) {
            props.localPort(this.localPort.intValue());
        }
        if (this.proxyHost != null) {
            props.proxyHost(this.proxyHost);
        }
        if (this.proxyPort != null) {
            props.proxyPort(this.proxyPort.intValue());
        }
        if (this.proxySSLPort != null) {
            props.proxyPort(this.proxySSLPort.intValue());
        }
        props.simulationOutputFolder(this.outputFolder);
        props.bodiesFolder(this.bodiesFolder);
        if (this.className != null) {
            props.simulationClassName(this.className);
        }
        if (this.packageName != null) {
            props.simulationPackage(this.packageName);
        }
        if (this.encoding != null) {
            props.encoding(this.encoding);
        }
        if (this.followRedirect != null) {
            props.followRedirect(this.followRedirect.booleanValue());
        }
        RecorderController.apply((Map)props.build(), (Option)Option.apply((Object)Paths.get(this.configFile, new String[0])));
        while (JFrame.getFrames().length > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }
}

