/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.sike;

import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.gatling.recorder.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEKeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEKeyPairGenerator;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.sike.SIKEPublicKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.sike.BCSIKEPrivateKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.sike.BCSIKEPublicKey;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import io.gatling.recorder.internal.bouncycastle.pqc.jcajce.spec.SIKEParameterSpec;
import io.gatling.recorder.internal.bouncycastle.util.Strings;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class SIKEKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    SIKEKeyGenerationParameters param;
    SIKEKeyPairGenerator engine = new SIKEKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public SIKEKeyPairGeneratorSpi() {
        super("SIKE");
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        String string = SIKEKeyPairGeneratorSpi.getNameFromParams(algorithmParameterSpec);
        if (string == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + algorithmParameterSpec);
        }
        this.param = new SIKEKeyGenerationParameters(secureRandom, (SIKEParameters)parameters.get(string));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof SIKEParameterSpec) {
            SIKEParameterSpec sIKEParameterSpec = (SIKEParameterSpec)algorithmParameterSpec;
            return sIKEParameterSpec.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(algorithmParameterSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new SIKEKeyGenerationParameters(this.random, SIKEParameters.sikep751);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        SIKEPublicKeyParameters sIKEPublicKeyParameters = (SIKEPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        SIKEPrivateKeyParameters sIKEPrivateKeyParameters = (SIKEPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCSIKEPublicKey(sIKEPublicKeyParameters), new BCSIKEPrivateKey(sIKEPrivateKeyParameters));
    }

    static {
        parameters.put(SIKEParameterSpec.sikep434.getName(), SIKEParameters.sikep434);
        parameters.put(SIKEParameterSpec.sikep503.getName(), SIKEParameters.sikep503);
        parameters.put(SIKEParameterSpec.sikep610.getName(), SIKEParameters.sikep610);
        parameters.put(SIKEParameterSpec.sikep751.getName(), SIKEParameters.sikep751);
        parameters.put(SIKEParameterSpec.sikep434_compressed.getName(), SIKEParameters.sikep434_compressed);
        parameters.put(SIKEParameterSpec.sikep503_compressed.getName(), SIKEParameters.sikep503_compressed);
        parameters.put(SIKEParameterSpec.sikep610_compressed.getName(), SIKEParameters.sikep610_compressed);
        parameters.put(SIKEParameterSpec.sikep751_compressed.getName(), SIKEParameters.sikep751_compressed);
    }
}

