package io.gatling.recorder.internal.bouncycastle.pqc.crypto.falcon;

class FPREngine
{
    private static final FalconFPR[] inv_sigma;
    private static final FalconFPR[] sigma_min;
    private static final FalconFPR[] gm_tab;
    private static final FalconFPR[] p2_tab;

    static
    {
        inv_sigma = new FalconFPR[]{
            new FalconFPR(0.0), /* unused */
            new FalconFPR(0.0069054793295940891952143765991630516),
            new FalconFPR(0.0068102267767177975961393730687908629),
            new FalconFPR(0.0067188101910722710707826117910434131),
            new FalconFPR(0.0065883354370073665545865037227681924),
            new FalconFPR(0.0064651781207602900738053897763485516),
            new FalconFPR(0.0063486788828078995327741182928037856),
            new FalconFPR(0.0062382586529084374473367528433697537),
            new FalconFPR(0.0061334065020930261548984001431770281),
            new FalconFPR(0.0060336696681577241031668062510953022),
            new FalconFPR(0.0059386453095331159950250124336477482)
        };

        sigma_min = new FalconFPR[]{
            new FalconFPR(0.0), /* unused */
            new FalconFPR(1.1165085072329102588881898380334015),
            new FalconFPR(1.1321247692325272405718031785357108),
            new FalconFPR(1.1475285353733668684571123112513188),
            new FalconFPR(1.1702540788534828939713084716509250),
            new FalconFPR(1.1925466358390344011122170489094133),
            new FalconFPR(1.2144300507766139921088487776957699),
            new FalconFPR(1.2359260567719808790104525941706723),
            new FalconFPR(1.2570545284063214162779743112075080),
            new FalconFPR(1.2778336969128335860256340575729042),
            new FalconFPR(1.2982803343442918539708792538826807)
        };
        gm_tab = new FalconFPR[]{
            new FalconFPR(0), new FalconFPR(0), /* unused */
            new FalconFPR(-0.000000000000000000000000000), new FalconFPR(1.000000000000000000000000000),
            new FalconFPR(0.707106781186547524400844362), new FalconFPR(0.707106781186547524400844362),
            new FalconFPR(-0.707106781186547524400844362), new FalconFPR(0.707106781186547524400844362),
            new FalconFPR(0.923879532511286756128183189), new FalconFPR(0.382683432365089771728459984),
            new FalconFPR(-0.382683432365089771728459984), new FalconFPR(0.923879532511286756128183189),
            new FalconFPR(0.382683432365089771728459984), new FalconFPR(0.923879532511286756128183189),
            new FalconFPR(-0.923879532511286756128183189), new FalconFPR(0.382683432365089771728459984),
            new FalconFPR(0.980785280403230449126182236), new FalconFPR(0.195090322016128267848284868),
            new FalconFPR(-0.195090322016128267848284868), new FalconFPR(0.980785280403230449126182236),
            new FalconFPR(0.555570233019602224742830814), new FalconFPR(0.831469612302545237078788378),
            new FalconFPR(-0.831469612302545237078788378), new FalconFPR(0.555570233019602224742830814),
            new FalconFPR(0.831469612302545237078788378), new FalconFPR(0.555570233019602224742830814),
            new FalconFPR(-0.555570233019602224742830814), new FalconFPR(0.831469612302545237078788378),
            new FalconFPR(0.195090322016128267848284868), new FalconFPR(0.980785280403230449126182236),
            new FalconFPR(-0.980785280403230449126182236), new FalconFPR(0.195090322016128267848284868),
            new FalconFPR(0.995184726672196886244836953), new FalconFPR(0.098017140329560601994195564),
            new FalconFPR(-0.098017140329560601994195564), new FalconFPR(0.995184726672196886244836953),
            new FalconFPR(0.634393284163645498215171613), new FalconFPR(0.773010453362736960810906610),
            new FalconFPR(-0.773010453362736960810906610), new FalconFPR(0.634393284163645498215171613),
            new FalconFPR(0.881921264348355029712756864), new FalconFPR(0.471396736825997648556387626),
            new FalconFPR(-0.471396736825997648556387626), new FalconFPR(0.881921264348355029712756864),
            new FalconFPR(0.290284677254462367636192376), new FalconFPR(0.956940335732208864935797887),
            new FalconFPR(-0.956940335732208864935797887), new FalconFPR(0.290284677254462367636192376),
            new FalconFPR(0.956940335732208864935797887), new FalconFPR(0.290284677254462367636192376),
            new FalconFPR(-0.290284677254462367636192376), new FalconFPR(0.956940335732208864935797887),
            new FalconFPR(0.471396736825997648556387626), new FalconFPR(0.881921264348355029712756864),
            new FalconFPR(-0.881921264348355029712756864), new FalconFPR(0.471396736825997648556387626),
            new FalconFPR(0.773010453362736960810906610), new FalconFPR(0.634393284163645498215171613),
            new FalconFPR(-0.634393284163645498215171613), new FalconFPR(0.773010453362736960810906610),
            new FalconFPR(0.098017140329560601994195564), new FalconFPR(0.995184726672196886244836953),
            new FalconFPR(-0.995184726672196886244836953), new FalconFPR(0.098017140329560601994195564),
            new FalconFPR(0.998795456205172392714771605), new FalconFPR(0.049067674327418014254954977),
            new FalconFPR(-0.049067674327418014254954977), new FalconFPR(0.998795456205172392714771605),
            new FalconFPR(0.671558954847018400625376850), new FalconFPR(0.740951125354959091175616897),
            new FalconFPR(-0.740951125354959091175616897), new FalconFPR(0.671558954847018400625376850),
            new FalconFPR(0.903989293123443331586200297), new FalconFPR(0.427555093430282094320966857),
            new FalconFPR(-0.427555093430282094320966857), new FalconFPR(0.903989293123443331586200297),
            new FalconFPR(0.336889853392220050689253213), new FalconFPR(0.941544065183020778412509403),
            new FalconFPR(-0.941544065183020778412509403), new FalconFPR(0.336889853392220050689253213),
            new FalconFPR(0.970031253194543992603984207), new FalconFPR(0.242980179903263889948274162),
            new FalconFPR(-0.242980179903263889948274162), new FalconFPR(0.970031253194543992603984207),
            new FalconFPR(0.514102744193221726593693839), new FalconFPR(0.857728610000272069902269984),
            new FalconFPR(-0.857728610000272069902269984), new FalconFPR(0.514102744193221726593693839),
            new FalconFPR(0.803207531480644909806676513), new FalconFPR(0.595699304492433343467036529),
            new FalconFPR(-0.595699304492433343467036529), new FalconFPR(0.803207531480644909806676513),
            new FalconFPR(0.146730474455361751658850130), new FalconFPR(0.989176509964780973451673738),
            new FalconFPR(-0.989176509964780973451673738), new FalconFPR(0.146730474455361751658850130),
            new FalconFPR(0.989176509964780973451673738), new FalconFPR(0.146730474455361751658850130),
            new FalconFPR(-0.146730474455361751658850130), new FalconFPR(0.989176509964780973451673738),
            new FalconFPR(0.595699304492433343467036529), new FalconFPR(0.803207531480644909806676513),
            new FalconFPR(-0.803207531480644909806676513), new FalconFPR(0.595699304492433343467036529),
            new FalconFPR(0.857728610000272069902269984), new FalconFPR(0.514102744193221726593693839),
            new FalconFPR(-0.514102744193221726593693839), new FalconFPR(0.857728610000272069902269984),
            new FalconFPR(0.242980179903263889948274162), new FalconFPR(0.970031253194543992603984207),
            new FalconFPR(-0.970031253194543992603984207), new FalconFPR(0.242980179903263889948274162),
            new FalconFPR(0.941544065183020778412509403), new FalconFPR(0.336889853392220050689253213),
            new FalconFPR(-0.336889853392220050689253213), new FalconFPR(0.941544065183020778412509403),
            new FalconFPR(0.427555093430282094320966857), new FalconFPR(0.903989293123443331586200297),
            new FalconFPR(-0.903989293123443331586200297), new FalconFPR(0.427555093430282094320966857),
            new FalconFPR(0.740951125354959091175616897), new FalconFPR(0.671558954847018400625376850),
            new FalconFPR(-0.671558954847018400625376850), new FalconFPR(0.740951125354959091175616897),
            new FalconFPR(0.049067674327418014254954977), new FalconFPR(0.998795456205172392714771605),
            new FalconFPR(-0.998795456205172392714771605), new FalconFPR(0.049067674327418014254954977),
            new FalconFPR(0.999698818696204220115765650), new FalconFPR(0.024541228522912288031734529),
            new FalconFPR(-0.024541228522912288031734529), new FalconFPR(0.999698818696204220115765650),
            new FalconFPR(0.689540544737066924616730630), new FalconFPR(0.724247082951466920941069243),
            new FalconFPR(-0.724247082951466920941069243), new FalconFPR(0.689540544737066924616730630),
            new FalconFPR(0.914209755703530654635014829), new FalconFPR(0.405241314004989870908481306),
            new FalconFPR(-0.405241314004989870908481306), new FalconFPR(0.914209755703530654635014829),
            new FalconFPR(0.359895036534988148775104572), new FalconFPR(0.932992798834738887711660256),
            new FalconFPR(-0.932992798834738887711660256), new FalconFPR(0.359895036534988148775104572),
            new FalconFPR(0.975702130038528544460395766), new FalconFPR(0.219101240156869797227737547),
            new FalconFPR(-0.219101240156869797227737547), new FalconFPR(0.975702130038528544460395766),
            new FalconFPR(0.534997619887097210663076905), new FalconFPR(0.844853565249707073259571205),
            new FalconFPR(-0.844853565249707073259571205), new FalconFPR(0.534997619887097210663076905),
            new FalconFPR(0.817584813151583696504920884), new FalconFPR(0.575808191417845300745972454),
            new FalconFPR(-0.575808191417845300745972454), new FalconFPR(0.817584813151583696504920884),
            new FalconFPR(0.170961888760301226363642357), new FalconFPR(0.985277642388941244774018433),
            new FalconFPR(-0.985277642388941244774018433), new FalconFPR(0.170961888760301226363642357),
            new FalconFPR(0.992479534598709998156767252), new FalconFPR(0.122410675199216198498704474),
            new FalconFPR(-0.122410675199216198498704474), new FalconFPR(0.992479534598709998156767252),
            new FalconFPR(0.615231590580626845484913563), new FalconFPR(0.788346427626606262009164705),
            new FalconFPR(-0.788346427626606262009164705), new FalconFPR(0.615231590580626845484913563),
            new FalconFPR(0.870086991108711418652292404), new FalconFPR(0.492898192229784036873026689),
            new FalconFPR(-0.492898192229784036873026689), new FalconFPR(0.870086991108711418652292404),
            new FalconFPR(0.266712757474898386325286515), new FalconFPR(0.963776065795439866686464356),
            new FalconFPR(-0.963776065795439866686464356), new FalconFPR(0.266712757474898386325286515),
            new FalconFPR(0.949528180593036667195936074), new FalconFPR(0.313681740398891476656478846),
            new FalconFPR(-0.313681740398891476656478846), new FalconFPR(0.949528180593036667195936074),
            new FalconFPR(0.449611329654606600046294579), new FalconFPR(0.893224301195515320342416447),
            new FalconFPR(-0.893224301195515320342416447), new FalconFPR(0.449611329654606600046294579),
            new FalconFPR(0.757208846506484547575464054), new FalconFPR(0.653172842953776764084203014),
            new FalconFPR(-0.653172842953776764084203014), new FalconFPR(0.757208846506484547575464054),
            new FalconFPR(0.073564563599667423529465622), new FalconFPR(0.997290456678690216135597140),
            new FalconFPR(-0.997290456678690216135597140), new FalconFPR(0.073564563599667423529465622),
            new FalconFPR(0.997290456678690216135597140), new FalconFPR(0.073564563599667423529465622),
            new FalconFPR(-0.073564563599667423529465622), new FalconFPR(0.997290456678690216135597140),
            new FalconFPR(0.653172842953776764084203014), new FalconFPR(0.757208846506484547575464054),
            new FalconFPR(-0.757208846506484547575464054), new FalconFPR(0.653172842953776764084203014),
            new FalconFPR(0.893224301195515320342416447), new FalconFPR(0.449611329654606600046294579),
            new FalconFPR(-0.449611329654606600046294579), new FalconFPR(0.893224301195515320342416447),
            new FalconFPR(0.313681740398891476656478846), new FalconFPR(0.949528180593036667195936074),
            new FalconFPR(-0.949528180593036667195936074), new FalconFPR(0.313681740398891476656478846),
            new FalconFPR(0.963776065795439866686464356), new FalconFPR(0.266712757474898386325286515),
            new FalconFPR(-0.266712757474898386325286515), new FalconFPR(0.963776065795439866686464356),
            new FalconFPR(0.492898192229784036873026689), new FalconFPR(0.870086991108711418652292404),
            new FalconFPR(-0.870086991108711418652292404), new FalconFPR(0.492898192229784036873026689),
            new FalconFPR(0.788346427626606262009164705), new FalconFPR(0.615231590580626845484913563),
            new FalconFPR(-0.615231590580626845484913563), new FalconFPR(0.788346427626606262009164705),
            new FalconFPR(0.122410675199216198498704474), new FalconFPR(0.992479534598709998156767252),
            new FalconFPR(-0.992479534598709998156767252), new FalconFPR(0.122410675199216198498704474),
            new FalconFPR(0.985277642388941244774018433), new FalconFPR(0.170961888760301226363642357),
            new FalconFPR(-0.170961888760301226363642357), new FalconFPR(0.985277642388941244774018433),
            new FalconFPR(0.575808191417845300745972454), new FalconFPR(0.817584813151583696504920884),
            new FalconFPR(-0.817584813151583696504920884), new FalconFPR(0.575808191417845300745972454),
            new FalconFPR(0.844853565249707073259571205), new FalconFPR(0.534997619887097210663076905),
            new FalconFPR(-0.534997619887097210663076905), new FalconFPR(0.844853565249707073259571205),
            new FalconFPR(0.219101240156869797227737547), new FalconFPR(0.975702130038528544460395766),
            new FalconFPR(-0.975702130038528544460395766), new FalconFPR(0.219101240156869797227737547),
            new FalconFPR(0.932992798834738887711660256), new FalconFPR(0.359895036534988148775104572),
            new FalconFPR(-0.359895036534988148775104572), new FalconFPR(0.932992798834738887711660256),
            new FalconFPR(0.405241314004989870908481306), new FalconFPR(0.914209755703530654635014829),
            new FalconFPR(-0.914209755703530654635014829), new FalconFPR(0.405241314004989870908481306),
            new FalconFPR(0.724247082951466920941069243), new FalconFPR(0.689540544737066924616730630),
            new FalconFPR(-0.689540544737066924616730630), new FalconFPR(0.724247082951466920941069243),
            new FalconFPR(0.024541228522912288031734529), new FalconFPR(0.999698818696204220115765650),
            new FalconFPR(-0.999698818696204220115765650), new FalconFPR(0.024541228522912288031734529),
            new FalconFPR(0.999924701839144540921646491), new FalconFPR(0.012271538285719926079408262),
            new FalconFPR(-0.012271538285719926079408262), new FalconFPR(0.999924701839144540921646491),
            new FalconFPR(0.698376249408972853554813503), new FalconFPR(0.715730825283818654125532623),
            new FalconFPR(-0.715730825283818654125532623), new FalconFPR(0.698376249408972853554813503),
            new FalconFPR(0.919113851690057743908477789), new FalconFPR(0.393992040061048108596188661),
            new FalconFPR(-0.393992040061048108596188661), new FalconFPR(0.919113851690057743908477789),
            new FalconFPR(0.371317193951837543411934967), new FalconFPR(0.928506080473215565937167396),
            new FalconFPR(-0.928506080473215565937167396), new FalconFPR(0.371317193951837543411934967),
            new FalconFPR(0.978317370719627633106240097), new FalconFPR(0.207111376192218549708116020),
            new FalconFPR(-0.207111376192218549708116020), new FalconFPR(0.978317370719627633106240097),
            new FalconFPR(0.545324988422046422313987347), new FalconFPR(0.838224705554838043186996856),
            new FalconFPR(-0.838224705554838043186996856), new FalconFPR(0.545324988422046422313987347),
            new FalconFPR(0.824589302785025264474803737), new FalconFPR(0.565731810783613197389765011),
            new FalconFPR(-0.565731810783613197389765011), new FalconFPR(0.824589302785025264474803737),
            new FalconFPR(0.183039887955140958516532578), new FalconFPR(0.983105487431216327180301155),
            new FalconFPR(-0.983105487431216327180301155), new FalconFPR(0.183039887955140958516532578),
            new FalconFPR(0.993906970002356041546922813), new FalconFPR(0.110222207293883058807899140),
            new FalconFPR(-0.110222207293883058807899140), new FalconFPR(0.993906970002356041546922813),
            new FalconFPR(0.624859488142386377084072816), new FalconFPR(0.780737228572094478301588484),
            new FalconFPR(-0.780737228572094478301588484), new FalconFPR(0.624859488142386377084072816),
            new FalconFPR(0.876070094195406607095844268), new FalconFPR(0.482183772079122748517344481),
            new FalconFPR(-0.482183772079122748517344481), new FalconFPR(0.876070094195406607095844268),
            new FalconFPR(0.278519689385053105207848526), new FalconFPR(0.960430519415565811199035138),
            new FalconFPR(-0.960430519415565811199035138), new FalconFPR(0.278519689385053105207848526),
            new FalconFPR(0.953306040354193836916740383), new FalconFPR(0.302005949319228067003463232),
            new FalconFPR(-0.302005949319228067003463232), new FalconFPR(0.953306040354193836916740383),
            new FalconFPR(0.460538710958240023633181487), new FalconFPR(0.887639620402853947760181617),
            new FalconFPR(-0.887639620402853947760181617), new FalconFPR(0.460538710958240023633181487),
            new FalconFPR(0.765167265622458925888815999), new FalconFPR(0.643831542889791465068086063),
            new FalconFPR(-0.643831542889791465068086063), new FalconFPR(0.765167265622458925888815999),
            new FalconFPR(0.085797312344439890461556332), new FalconFPR(0.996312612182778012627226190),
            new FalconFPR(-0.996312612182778012627226190), new FalconFPR(0.085797312344439890461556332),
            new FalconFPR(0.998118112900149207125155861), new FalconFPR(0.061320736302208577782614593),
            new FalconFPR(-0.061320736302208577782614593), new FalconFPR(0.998118112900149207125155861),
            new FalconFPR(0.662415777590171761113069817), new FalconFPR(0.749136394523459325469203257),
            new FalconFPR(-0.749136394523459325469203257), new FalconFPR(0.662415777590171761113069817),
            new FalconFPR(0.898674465693953843041976744), new FalconFPR(0.438616238538527637647025738),
            new FalconFPR(-0.438616238538527637647025738), new FalconFPR(0.898674465693953843041976744),
            new FalconFPR(0.325310292162262934135954708), new FalconFPR(0.945607325380521325730945387),
            new FalconFPR(-0.945607325380521325730945387), new FalconFPR(0.325310292162262934135954708),
            new FalconFPR(0.966976471044852109087220226), new FalconFPR(0.254865659604514571553980779),
            new FalconFPR(-0.254865659604514571553980779), new FalconFPR(0.966976471044852109087220226),
            new FalconFPR(0.503538383725717558691867071), new FalconFPR(0.863972856121586737918147054),
            new FalconFPR(-0.863972856121586737918147054), new FalconFPR(0.503538383725717558691867071),
            new FalconFPR(0.795836904608883536262791915), new FalconFPR(0.605511041404325513920626941),
            new FalconFPR(-0.605511041404325513920626941), new FalconFPR(0.795836904608883536262791915),
            new FalconFPR(0.134580708507126186316358409), new FalconFPR(0.990902635427780025108237011),
            new FalconFPR(-0.990902635427780025108237011), new FalconFPR(0.134580708507126186316358409),
            new FalconFPR(0.987301418157858382399815802), new FalconFPR(0.158858143333861441684385360),
            new FalconFPR(-0.158858143333861441684385360), new FalconFPR(0.987301418157858382399815802),
            new FalconFPR(0.585797857456438860328080838), new FalconFPR(0.810457198252594791726703434),
            new FalconFPR(-0.810457198252594791726703434), new FalconFPR(0.585797857456438860328080838),
            new FalconFPR(0.851355193105265142261290312), new FalconFPR(0.524589682678468906215098464),
            new FalconFPR(-0.524589682678468906215098464), new FalconFPR(0.851355193105265142261290312),
            new FalconFPR(0.231058108280671119643236018), new FalconFPR(0.972939952205560145467720114),
            new FalconFPR(-0.972939952205560145467720114), new FalconFPR(0.231058108280671119643236018),
            new FalconFPR(0.937339011912574923201899593), new FalconFPR(0.348418680249434568419308588),
            new FalconFPR(-0.348418680249434568419308588), new FalconFPR(0.937339011912574923201899593),
            new FalconFPR(0.416429560097637182562598911), new FalconFPR(0.909167983090522376563884788),
            new FalconFPR(-0.909167983090522376563884788), new FalconFPR(0.416429560097637182562598911),
            new FalconFPR(0.732654271672412834615546649), new FalconFPR(0.680600997795453050594430464),
            new FalconFPR(-0.680600997795453050594430464), new FalconFPR(0.732654271672412834615546649),
            new FalconFPR(0.036807222941358832324332691), new FalconFPR(0.999322384588349500896221011),
            new FalconFPR(-0.999322384588349500896221011), new FalconFPR(0.036807222941358832324332691),
            new FalconFPR(0.999322384588349500896221011), new FalconFPR(0.036807222941358832324332691),
            new FalconFPR(-0.036807222941358832324332691), new FalconFPR(0.999322384588349500896221011),
            new FalconFPR(0.680600997795453050594430464), new FalconFPR(0.732654271672412834615546649),
            new FalconFPR(-0.732654271672412834615546649), new FalconFPR(0.680600997795453050594430464),
            new FalconFPR(0.909167983090522376563884788), new FalconFPR(0.416429560097637182562598911),
            new FalconFPR(-0.416429560097637182562598911), new FalconFPR(0.909167983090522376563884788),
            new FalconFPR(0.348418680249434568419308588), new FalconFPR(0.937339011912574923201899593),
            new FalconFPR(-0.937339011912574923201899593), new FalconFPR(0.348418680249434568419308588),
            new FalconFPR(0.972939952205560145467720114), new FalconFPR(0.231058108280671119643236018),
            new FalconFPR(-0.231058108280671119643236018), new FalconFPR(0.972939952205560145467720114),
            new FalconFPR(0.524589682678468906215098464), new FalconFPR(0.851355193105265142261290312),
            new FalconFPR(-0.851355193105265142261290312), new FalconFPR(0.524589682678468906215098464),
            new FalconFPR(0.810457198252594791726703434), new FalconFPR(0.585797857456438860328080838),
            new FalconFPR(-0.585797857456438860328080838), new FalconFPR(0.810457198252594791726703434),
            new FalconFPR(0.158858143333861441684385360), new FalconFPR(0.987301418157858382399815802),
            new FalconFPR(-0.987301418157858382399815802), new FalconFPR(0.158858143333861441684385360),
            new FalconFPR(0.990902635427780025108237011), new FalconFPR(0.134580708507126186316358409),
            new FalconFPR(-0.134580708507126186316358409), new FalconFPR(0.990902635427780025108237011),
            new FalconFPR(0.605511041404325513920626941), new FalconFPR(0.795836904608883536262791915),
            new FalconFPR(-0.795836904608883536262791915), new FalconFPR(0.605511041404325513920626941),
            new FalconFPR(0.863972856121586737918147054), new FalconFPR(0.503538383725717558691867071),
            new FalconFPR(-0.503538383725717558691867071), new FalconFPR(0.863972856121586737918147054),
            new FalconFPR(0.254865659604514571553980779), new FalconFPR(0.966976471044852109087220226),
            new FalconFPR(-0.966976471044852109087220226), new FalconFPR(0.254865659604514571553980779),
            new FalconFPR(0.945607325380521325730945387), new FalconFPR(0.325310292162262934135954708),
            new FalconFPR(-0.325310292162262934135954708), new FalconFPR(0.945607325380521325730945387),
            new FalconFPR(0.438616238538527637647025738), new FalconFPR(0.898674465693953843041976744),
            new FalconFPR(-0.898674465693953843041976744), new FalconFPR(0.438616238538527637647025738),
            new FalconFPR(0.749136394523459325469203257), new FalconFPR(0.662415777590171761113069817),
            new FalconFPR(-0.662415777590171761113069817), new FalconFPR(0.749136394523459325469203257),
            new FalconFPR(0.061320736302208577782614593), new FalconFPR(0.998118112900149207125155861),
            new FalconFPR(-0.998118112900149207125155861), new FalconFPR(0.061320736302208577782614593),
            new FalconFPR(0.996312612182778012627226190), new FalconFPR(0.085797312344439890461556332),
            new FalconFPR(-0.085797312344439890461556332), new FalconFPR(0.996312612182778012627226190),
            new FalconFPR(0.643831542889791465068086063), new FalconFPR(0.765167265622458925888815999),
            new FalconFPR(-0.765167265622458925888815999), new FalconFPR(0.643831542889791465068086063),
            new FalconFPR(0.887639620402853947760181617), new FalconFPR(0.460538710958240023633181487),
            new FalconFPR(-0.460538710958240023633181487), new FalconFPR(0.887639620402853947760181617),
            new FalconFPR(0.302005949319228067003463232), new FalconFPR(0.953306040354193836916740383),
            new FalconFPR(-0.953306040354193836916740383), new FalconFPR(0.302005949319228067003463232),
            new FalconFPR(0.960430519415565811199035138), new FalconFPR(0.278519689385053105207848526),
            new FalconFPR(-0.278519689385053105207848526), new FalconFPR(0.960430519415565811199035138),
            new FalconFPR(0.482183772079122748517344481), new FalconFPR(0.876070094195406607095844268),
            new FalconFPR(-0.876070094195406607095844268), new FalconFPR(0.482183772079122748517344481),
            new FalconFPR(0.780737228572094478301588484), new FalconFPR(0.624859488142386377084072816),
            new FalconFPR(-0.624859488142386377084072816), new FalconFPR(0.780737228572094478301588484),
            new FalconFPR(0.110222207293883058807899140), new FalconFPR(0.993906970002356041546922813),
            new FalconFPR(-0.993906970002356041546922813), new FalconFPR(0.110222207293883058807899140),
            new FalconFPR(0.983105487431216327180301155), new FalconFPR(0.183039887955140958516532578),
            new FalconFPR(-0.183039887955140958516532578), new FalconFPR(0.983105487431216327180301155),
            new FalconFPR(0.565731810783613197389765011), new FalconFPR(0.824589302785025264474803737),
            new FalconFPR(-0.824589302785025264474803737), new FalconFPR(0.565731810783613197389765011),
            new FalconFPR(0.838224705554838043186996856), new FalconFPR(0.545324988422046422313987347),
            new FalconFPR(-0.545324988422046422313987347), new FalconFPR(0.838224705554838043186996856),
            new FalconFPR(0.207111376192218549708116020), new FalconFPR(0.978317370719627633106240097),
            new FalconFPR(-0.978317370719627633106240097), new FalconFPR(0.207111376192218549708116020),
            new FalconFPR(0.928506080473215565937167396), new FalconFPR(0.371317193951837543411934967),
            new FalconFPR(-0.371317193951837543411934967), new FalconFPR(0.928506080473215565937167396),
            new FalconFPR(0.393992040061048108596188661), new FalconFPR(0.919113851690057743908477789),
            new FalconFPR(-0.919113851690057743908477789), new FalconFPR(0.393992040061048108596188661),
            new FalconFPR(0.715730825283818654125532623), new FalconFPR(0.698376249408972853554813503),
            new FalconFPR(-0.698376249408972853554813503), new FalconFPR(0.715730825283818654125532623),
            new FalconFPR(0.012271538285719926079408262), new FalconFPR(0.999924701839144540921646491),
            new FalconFPR(-0.999924701839144540921646491), new FalconFPR(0.012271538285719926079408262),
            new FalconFPR(0.999981175282601142656990438), new FalconFPR(0.006135884649154475359640235),
            new FalconFPR(-0.006135884649154475359640235), new FalconFPR(0.999981175282601142656990438),
            new FalconFPR(0.702754744457225302452914421), new FalconFPR(0.711432195745216441522130290),
            new FalconFPR(-0.711432195745216441522130290), new FalconFPR(0.702754744457225302452914421),
            new FalconFPR(0.921514039342041943465396332), new FalconFPR(0.388345046698826291624993541),
            new FalconFPR(-0.388345046698826291624993541), new FalconFPR(0.921514039342041943465396332),
            new FalconFPR(0.377007410216418256726567823), new FalconFPR(0.926210242138311341974793388),
            new FalconFPR(-0.926210242138311341974793388), new FalconFPR(0.377007410216418256726567823),
            new FalconFPR(0.979569765685440534439326110), new FalconFPR(0.201104634842091911558443546),
            new FalconFPR(-0.201104634842091911558443546), new FalconFPR(0.979569765685440534439326110),
            new FalconFPR(0.550457972936604802977289893), new FalconFPR(0.834862874986380056304401383),
            new FalconFPR(-0.834862874986380056304401383), new FalconFPR(0.550457972936604802977289893),
            new FalconFPR(0.828045045257755752067527592), new FalconFPR(0.560661576197336023839710223),
            new FalconFPR(-0.560661576197336023839710223), new FalconFPR(0.828045045257755752067527592),
            new FalconFPR(0.189068664149806212754997837), new FalconFPR(0.981963869109555264072848154),
            new FalconFPR(-0.981963869109555264072848154), new FalconFPR(0.189068664149806212754997837),
            new FalconFPR(0.994564570734255452119106243), new FalconFPR(0.104121633872054579120943880),
            new FalconFPR(-0.104121633872054579120943880), new FalconFPR(0.994564570734255452119106243),
            new FalconFPR(0.629638238914927025372981341), new FalconFPR(0.776888465673232450040827983),
            new FalconFPR(-0.776888465673232450040827983), new FalconFPR(0.629638238914927025372981341),
            new FalconFPR(0.879012226428633477831323711), new FalconFPR(0.476799230063322133342158117),
            new FalconFPR(-0.476799230063322133342158117), new FalconFPR(0.879012226428633477831323711),
            new FalconFPR(0.284407537211271843618310615), new FalconFPR(0.958703474895871555374645792),
            new FalconFPR(-0.958703474895871555374645792), new FalconFPR(0.284407537211271843618310615),
            new FalconFPR(0.955141168305770721498157712), new FalconFPR(0.296150888243623824121786128),
            new FalconFPR(-0.296150888243623824121786128), new FalconFPR(0.955141168305770721498157712),
            new FalconFPR(0.465976495767966177902756065), new FalconFPR(0.884797098430937780104007041),
            new FalconFPR(-0.884797098430937780104007041), new FalconFPR(0.465976495767966177902756065),
            new FalconFPR(0.769103337645579639346626069), new FalconFPR(0.639124444863775743801488193),
            new FalconFPR(-0.639124444863775743801488193), new FalconFPR(0.769103337645579639346626069),
            new FalconFPR(0.091908956497132728624990979), new FalconFPR(0.995767414467659793982495643),
            new FalconFPR(-0.995767414467659793982495643), new FalconFPR(0.091908956497132728624990979),
            new FalconFPR(0.998475580573294752208559038), new FalconFPR(0.055195244349689939809447526),
            new FalconFPR(-0.055195244349689939809447526), new FalconFPR(0.998475580573294752208559038),
            new FalconFPR(0.666999922303637506650154222), new FalconFPR(0.745057785441465962407907310),
            new FalconFPR(-0.745057785441465962407907310), new FalconFPR(0.666999922303637506650154222),
            new FalconFPR(0.901348847046022014570746093), new FalconFPR(0.433093818853151968484222638),
            new FalconFPR(-0.433093818853151968484222638), new FalconFPR(0.901348847046022014570746093),
            new FalconFPR(0.331106305759876401737190737), new FalconFPR(0.943593458161960361495301445),
            new FalconFPR(-0.943593458161960361495301445), new FalconFPR(0.331106305759876401737190737),
            new FalconFPR(0.968522094274417316221088329), new FalconFPR(0.248927605745720168110682816),
            new FalconFPR(-0.248927605745720168110682816), new FalconFPR(0.968522094274417316221088329),
            new FalconFPR(0.508830142543107036931749324), new FalconFPR(0.860866938637767279344583877),
            new FalconFPR(-0.860866938637767279344583877), new FalconFPR(0.508830142543107036931749324),
            new FalconFPR(0.799537269107905033500246232), new FalconFPR(0.600616479383868926653875896),
            new FalconFPR(-0.600616479383868926653875896), new FalconFPR(0.799537269107905033500246232),
            new FalconFPR(0.140658239332849230714788846), new FalconFPR(0.990058210262297105505906464),
            new FalconFPR(-0.990058210262297105505906464), new FalconFPR(0.140658239332849230714788846),
            new FalconFPR(0.988257567730749491404792538), new FalconFPR(0.152797185258443427720336613),
            new FalconFPR(-0.152797185258443427720336613), new FalconFPR(0.988257567730749491404792538),
            new FalconFPR(0.590759701858874228423887908), new FalconFPR(0.806847553543799272206514313),
            new FalconFPR(-0.806847553543799272206514313), new FalconFPR(0.590759701858874228423887908),
            new FalconFPR(0.854557988365400520767862276), new FalconFPR(0.519355990165589587361829932),
            new FalconFPR(-0.519355990165589587361829932), new FalconFPR(0.854557988365400520767862276),
            new FalconFPR(0.237023605994367206867735915), new FalconFPR(0.971503890986251775537099622),
            new FalconFPR(-0.971503890986251775537099622), new FalconFPR(0.237023605994367206867735915),
            new FalconFPR(0.939459223602189911962669246), new FalconFPR(0.342660717311994397592781983),
            new FalconFPR(-0.342660717311994397592781983), new FalconFPR(0.939459223602189911962669246),
            new FalconFPR(0.422000270799799685941287941), new FalconFPR(0.906595704514915365332960588),
            new FalconFPR(-0.906595704514915365332960588), new FalconFPR(0.422000270799799685941287941),
            new FalconFPR(0.736816568877369875090132520), new FalconFPR(0.676092703575315960360419228),
            new FalconFPR(-0.676092703575315960360419228), new FalconFPR(0.736816568877369875090132520),
            new FalconFPR(0.042938256934940823077124540), new FalconFPR(0.999077727752645382888781997),
            new FalconFPR(-0.999077727752645382888781997), new FalconFPR(0.042938256934940823077124540),
            new FalconFPR(0.999529417501093163079703322), new FalconFPR(0.030674803176636625934021028),
            new FalconFPR(-0.030674803176636625934021028), new FalconFPR(0.999529417501093163079703322),
            new FalconFPR(0.685083667772700381362052545), new FalconFPR(0.728464390448225196492035438),
            new FalconFPR(-0.728464390448225196492035438), new FalconFPR(0.685083667772700381362052545),
            new FalconFPR(0.911706032005429851404397325), new FalconFPR(0.410843171057903942183466675),
            new FalconFPR(-0.410843171057903942183466675), new FalconFPR(0.911706032005429851404397325),
            new FalconFPR(0.354163525420490382357395796), new FalconFPR(0.935183509938947577642207480),
            new FalconFPR(-0.935183509938947577642207480), new FalconFPR(0.354163525420490382357395796),
            new FalconFPR(0.974339382785575860518721668), new FalconFPR(0.225083911359792835991642120),
            new FalconFPR(-0.225083911359792835991642120), new FalconFPR(0.974339382785575860518721668),
            new FalconFPR(0.529803624686294668216054671), new FalconFPR(0.848120344803297251279133563),
            new FalconFPR(-0.848120344803297251279133563), new FalconFPR(0.529803624686294668216054671),
            new FalconFPR(0.814036329705948361654516690), new FalconFPR(0.580813958095764545075595272),
            new FalconFPR(-0.580813958095764545075595272), new FalconFPR(0.814036329705948361654516690),
            new FalconFPR(0.164913120489969921418189113), new FalconFPR(0.986308097244598647863297524),
            new FalconFPR(-0.986308097244598647863297524), new FalconFPR(0.164913120489969921418189113),
            new FalconFPR(0.991709753669099522860049931), new FalconFPR(0.128498110793793172624415589),
            new FalconFPR(-0.128498110793793172624415589), new FalconFPR(0.991709753669099522860049931),
            new FalconFPR(0.610382806276309452716352152), new FalconFPR(0.792106577300212351782342879),
            new FalconFPR(-0.792106577300212351782342879), new FalconFPR(0.610382806276309452716352152),
            new FalconFPR(0.867046245515692651480195629), new FalconFPR(0.498227666972781852410983869),
            new FalconFPR(-0.498227666972781852410983869), new FalconFPR(0.867046245515692651480195629),
            new FalconFPR(0.260794117915275518280186509), new FalconFPR(0.965394441697689374550843858),
            new FalconFPR(-0.965394441697689374550843858), new FalconFPR(0.260794117915275518280186509),
            new FalconFPR(0.947585591017741134653387321), new FalconFPR(0.319502030816015677901518272),
            new FalconFPR(-0.319502030816015677901518272), new FalconFPR(0.947585591017741134653387321),
            new FalconFPR(0.444122144570429231642069418), new FalconFPR(0.895966249756185155914560282),
            new FalconFPR(-0.895966249756185155914560282), new FalconFPR(0.444122144570429231642069418),
            new FalconFPR(0.753186799043612482483430486), new FalconFPR(0.657806693297078656931182264),
            new FalconFPR(-0.657806693297078656931182264), new FalconFPR(0.753186799043612482483430486),
            new FalconFPR(0.067443919563664057897972422), new FalconFPR(0.997723066644191609848546728),
            new FalconFPR(-0.997723066644191609848546728), new FalconFPR(0.067443919563664057897972422),
            new FalconFPR(0.996820299291165714972629398), new FalconFPR(0.079682437971430121147120656),
            new FalconFPR(-0.079682437971430121147120656), new FalconFPR(0.996820299291165714972629398),
            new FalconFPR(0.648514401022112445084560551), new FalconFPR(0.761202385484261814029709836),
            new FalconFPR(-0.761202385484261814029709836), new FalconFPR(0.648514401022112445084560551),
            new FalconFPR(0.890448723244757889952150560), new FalconFPR(0.455083587126343823535869268),
            new FalconFPR(-0.455083587126343823535869268), new FalconFPR(0.890448723244757889952150560),
            new FalconFPR(0.307849640041534893682063646), new FalconFPR(0.951435020969008369549175569),
            new FalconFPR(-0.951435020969008369549175569), new FalconFPR(0.307849640041534893682063646),
            new FalconFPR(0.962121404269041595429604316), new FalconFPR(0.272621355449948984493347477),
            new FalconFPR(-0.272621355449948984493347477), new FalconFPR(0.962121404269041595429604316),
            new FalconFPR(0.487550160148435954641485027), new FalconFPR(0.873094978418290098636085973),
            new FalconFPR(-0.873094978418290098636085973), new FalconFPR(0.487550160148435954641485027),
            new FalconFPR(0.784556597155575233023892575), new FalconFPR(0.620057211763289178646268191),
            new FalconFPR(-0.620057211763289178646268191), new FalconFPR(0.784556597155575233023892575),
            new FalconFPR(0.116318630911904767252544319), new FalconFPR(0.993211949234794533104601012),
            new FalconFPR(-0.993211949234794533104601012), new FalconFPR(0.116318630911904767252544319),
            new FalconFPR(0.984210092386929073193874387), new FalconFPR(0.177004220412148756196839844),
            new FalconFPR(-0.177004220412148756196839844), new FalconFPR(0.984210092386929073193874387),
            new FalconFPR(0.570780745886967280232652864), new FalconFPR(0.821102514991104679060430820),
            new FalconFPR(-0.821102514991104679060430820), new FalconFPR(0.570780745886967280232652864),
            new FalconFPR(0.841554977436898409603499520), new FalconFPR(0.540171472729892881297845480),
            new FalconFPR(-0.540171472729892881297845480), new FalconFPR(0.841554977436898409603499520),
            new FalconFPR(0.213110319916091373967757518), new FalconFPR(0.977028142657754351485866211),
            new FalconFPR(-0.977028142657754351485866211), new FalconFPR(0.213110319916091373967757518),
            new FalconFPR(0.930766961078983731944872340), new FalconFPR(0.365612997804773870011745909),
            new FalconFPR(-0.365612997804773870011745909), new FalconFPR(0.930766961078983731944872340),
            new FalconFPR(0.399624199845646828544117031), new FalconFPR(0.916679059921042663116457013),
            new FalconFPR(-0.916679059921042663116457013), new FalconFPR(0.399624199845646828544117031),
            new FalconFPR(0.720002507961381629076682999), new FalconFPR(0.693971460889654009003734389),
            new FalconFPR(-0.693971460889654009003734389), new FalconFPR(0.720002507961381629076682999),
            new FalconFPR(0.018406729905804820927366313), new FalconFPR(0.999830581795823422015722275),
            new FalconFPR(-0.999830581795823422015722275), new FalconFPR(0.018406729905804820927366313),
            new FalconFPR(0.999830581795823422015722275), new FalconFPR(0.018406729905804820927366313),
            new FalconFPR(-0.018406729905804820927366313), new FalconFPR(0.999830581795823422015722275),
            new FalconFPR(0.693971460889654009003734389), new FalconFPR(0.720002507961381629076682999),
            new FalconFPR(-0.720002507961381629076682999), new FalconFPR(0.693971460889654009003734389),
            new FalconFPR(0.916679059921042663116457013), new FalconFPR(0.399624199845646828544117031),
            new FalconFPR(-0.399624199845646828544117031), new FalconFPR(0.916679059921042663116457013),
            new FalconFPR(0.365612997804773870011745909), new FalconFPR(0.930766961078983731944872340),
            new FalconFPR(-0.930766961078983731944872340), new FalconFPR(0.365612997804773870011745909),
            new FalconFPR(0.977028142657754351485866211), new FalconFPR(0.213110319916091373967757518),
            new FalconFPR(-0.213110319916091373967757518), new FalconFPR(0.977028142657754351485866211),
            new FalconFPR(0.540171472729892881297845480), new FalconFPR(0.841554977436898409603499520),
            new FalconFPR(-0.841554977436898409603499520), new FalconFPR(0.540171472729892881297845480),
            new FalconFPR(0.821102514991104679060430820), new FalconFPR(0.570780745886967280232652864),
            new FalconFPR(-0.570780745886967280232652864), new FalconFPR(0.821102514991104679060430820),
            new FalconFPR(0.177004220412148756196839844), new FalconFPR(0.984210092386929073193874387),
            new FalconFPR(-0.984210092386929073193874387), new FalconFPR(0.177004220412148756196839844),
            new FalconFPR(0.993211949234794533104601012), new FalconFPR(0.116318630911904767252544319),
            new FalconFPR(-0.116318630911904767252544319), new FalconFPR(0.993211949234794533104601012),
            new FalconFPR(0.620057211763289178646268191), new FalconFPR(0.784556597155575233023892575),
            new FalconFPR(-0.784556597155575233023892575), new FalconFPR(0.620057211763289178646268191),
            new FalconFPR(0.873094978418290098636085973), new FalconFPR(0.487550160148435954641485027),
            new FalconFPR(-0.487550160148435954641485027), new FalconFPR(0.873094978418290098636085973),
            new FalconFPR(0.272621355449948984493347477), new FalconFPR(0.962121404269041595429604316),
            new FalconFPR(-0.962121404269041595429604316), new FalconFPR(0.272621355449948984493347477),
            new FalconFPR(0.951435020969008369549175569), new FalconFPR(0.307849640041534893682063646),
            new FalconFPR(-0.307849640041534893682063646), new FalconFPR(0.951435020969008369549175569),
            new FalconFPR(0.455083587126343823535869268), new FalconFPR(0.890448723244757889952150560),
            new FalconFPR(-0.890448723244757889952150560), new FalconFPR(0.455083587126343823535869268),
            new FalconFPR(0.761202385484261814029709836), new FalconFPR(0.648514401022112445084560551),
            new FalconFPR(-0.648514401022112445084560551), new FalconFPR(0.761202385484261814029709836),
            new FalconFPR(0.079682437971430121147120656), new FalconFPR(0.996820299291165714972629398),
            new FalconFPR(-0.996820299291165714972629398), new FalconFPR(0.079682437971430121147120656),
            new FalconFPR(0.997723066644191609848546728), new FalconFPR(0.067443919563664057897972422),
            new FalconFPR(-0.067443919563664057897972422), new FalconFPR(0.997723066644191609848546728),
            new FalconFPR(0.657806693297078656931182264), new FalconFPR(0.753186799043612482483430486),
            new FalconFPR(-0.753186799043612482483430486), new FalconFPR(0.657806693297078656931182264),
            new FalconFPR(0.895966249756185155914560282), new FalconFPR(0.444122144570429231642069418),
            new FalconFPR(-0.444122144570429231642069418), new FalconFPR(0.895966249756185155914560282),
            new FalconFPR(0.319502030816015677901518272), new FalconFPR(0.947585591017741134653387321),
            new FalconFPR(-0.947585591017741134653387321), new FalconFPR(0.319502030816015677901518272),
            new FalconFPR(0.965394441697689374550843858), new FalconFPR(0.260794117915275518280186509),
            new FalconFPR(-0.260794117915275518280186509), new FalconFPR(0.965394441697689374550843858),
            new FalconFPR(0.498227666972781852410983869), new FalconFPR(0.867046245515692651480195629),
            new FalconFPR(-0.867046245515692651480195629), new FalconFPR(0.498227666972781852410983869),
            new FalconFPR(0.792106577300212351782342879), new FalconFPR(0.610382806276309452716352152),
            new FalconFPR(-0.610382806276309452716352152), new FalconFPR(0.792106577300212351782342879),
            new FalconFPR(0.128498110793793172624415589), new FalconFPR(0.991709753669099522860049931),
            new FalconFPR(-0.991709753669099522860049931), new FalconFPR(0.128498110793793172624415589),
            new FalconFPR(0.986308097244598647863297524), new FalconFPR(0.164913120489969921418189113),
            new FalconFPR(-0.164913120489969921418189113), new FalconFPR(0.986308097244598647863297524),
            new FalconFPR(0.580813958095764545075595272), new FalconFPR(0.814036329705948361654516690),
            new FalconFPR(-0.814036329705948361654516690), new FalconFPR(0.580813958095764545075595272),
            new FalconFPR(0.848120344803297251279133563), new FalconFPR(0.529803624686294668216054671),
            new FalconFPR(-0.529803624686294668216054671), new FalconFPR(0.848120344803297251279133563),
            new FalconFPR(0.225083911359792835991642120), new FalconFPR(0.974339382785575860518721668),
            new FalconFPR(-0.974339382785575860518721668), new FalconFPR(0.225083911359792835991642120),
            new FalconFPR(0.935183509938947577642207480), new FalconFPR(0.354163525420490382357395796),
            new FalconFPR(-0.354163525420490382357395796), new FalconFPR(0.935183509938947577642207480),
            new FalconFPR(0.410843171057903942183466675), new FalconFPR(0.911706032005429851404397325),
            new FalconFPR(-0.911706032005429851404397325), new FalconFPR(0.410843171057903942183466675),
            new FalconFPR(0.728464390448225196492035438), new FalconFPR(0.685083667772700381362052545),
            new FalconFPR(-0.685083667772700381362052545), new FalconFPR(0.728464390448225196492035438),
            new FalconFPR(0.030674803176636625934021028), new FalconFPR(0.999529417501093163079703322),
            new FalconFPR(-0.999529417501093163079703322), new FalconFPR(0.030674803176636625934021028),
            new FalconFPR(0.999077727752645382888781997), new FalconFPR(0.042938256934940823077124540),
            new FalconFPR(-0.042938256934940823077124540), new FalconFPR(0.999077727752645382888781997),
            new FalconFPR(0.676092703575315960360419228), new FalconFPR(0.736816568877369875090132520),
            new FalconFPR(-0.736816568877369875090132520), new FalconFPR(0.676092703575315960360419228),
            new FalconFPR(0.906595704514915365332960588), new FalconFPR(0.422000270799799685941287941),
            new FalconFPR(-0.422000270799799685941287941), new FalconFPR(0.906595704514915365332960588),
            new FalconFPR(0.342660717311994397592781983), new FalconFPR(0.939459223602189911962669246),
            new FalconFPR(-0.939459223602189911962669246), new FalconFPR(0.342660717311994397592781983),
            new FalconFPR(0.971503890986251775537099622), new FalconFPR(0.237023605994367206867735915),
            new FalconFPR(-0.237023605994367206867735915), new FalconFPR(0.971503890986251775537099622),
            new FalconFPR(0.519355990165589587361829932), new FalconFPR(0.854557988365400520767862276),
            new FalconFPR(-0.854557988365400520767862276), new FalconFPR(0.519355990165589587361829932),
            new FalconFPR(0.806847553543799272206514313), new FalconFPR(0.590759701858874228423887908),
            new FalconFPR(-0.590759701858874228423887908), new FalconFPR(0.806847553543799272206514313),
            new FalconFPR(0.152797185258443427720336613), new FalconFPR(0.988257567730749491404792538),
            new FalconFPR(-0.988257567730749491404792538), new FalconFPR(0.152797185258443427720336613),
            new FalconFPR(0.990058210262297105505906464), new FalconFPR(0.140658239332849230714788846),
            new FalconFPR(-0.140658239332849230714788846), new FalconFPR(0.990058210262297105505906464),
            new FalconFPR(0.600616479383868926653875896), new FalconFPR(0.799537269107905033500246232),
            new FalconFPR(-0.799537269107905033500246232), new FalconFPR(0.600616479383868926653875896),
            new FalconFPR(0.860866938637767279344583877), new FalconFPR(0.508830142543107036931749324),
            new FalconFPR(-0.508830142543107036931749324), new FalconFPR(0.860866938637767279344583877),
            new FalconFPR(0.248927605745720168110682816), new FalconFPR(0.968522094274417316221088329),
            new FalconFPR(-0.968522094274417316221088329), new FalconFPR(0.248927605745720168110682816),
            new FalconFPR(0.943593458161960361495301445), new FalconFPR(0.331106305759876401737190737),
            new FalconFPR(-0.331106305759876401737190737), new FalconFPR(0.943593458161960361495301445),
            new FalconFPR(0.433093818853151968484222638), new FalconFPR(0.901348847046022014570746093),
            new FalconFPR(-0.901348847046022014570746093), new FalconFPR(0.433093818853151968484222638),
            new FalconFPR(0.745057785441465962407907310), new FalconFPR(0.666999922303637506650154222),
            new FalconFPR(-0.666999922303637506650154222), new FalconFPR(0.745057785441465962407907310),
            new FalconFPR(0.055195244349689939809447526), new FalconFPR(0.998475580573294752208559038),
            new FalconFPR(-0.998475580573294752208559038), new FalconFPR(0.055195244349689939809447526),
            new FalconFPR(0.995767414467659793982495643), new FalconFPR(0.091908956497132728624990979),
            new FalconFPR(-0.091908956497132728624990979), new FalconFPR(0.995767414467659793982495643),
            new FalconFPR(0.639124444863775743801488193), new FalconFPR(0.769103337645579639346626069),
            new FalconFPR(-0.769103337645579639346626069), new FalconFPR(0.639124444863775743801488193),
            new FalconFPR(0.884797098430937780104007041), new FalconFPR(0.465976495767966177902756065),
            new FalconFPR(-0.465976495767966177902756065), new FalconFPR(0.884797098430937780104007041),
            new FalconFPR(0.296150888243623824121786128), new FalconFPR(0.955141168305770721498157712),
            new FalconFPR(-0.955141168305770721498157712), new FalconFPR(0.296150888243623824121786128),
            new FalconFPR(0.958703474895871555374645792), new FalconFPR(0.284407537211271843618310615),
            new FalconFPR(-0.284407537211271843618310615), new FalconFPR(0.958703474895871555374645792),
            new FalconFPR(0.476799230063322133342158117), new FalconFPR(0.879012226428633477831323711),
            new FalconFPR(-0.879012226428633477831323711), new FalconFPR(0.476799230063322133342158117),
            new FalconFPR(0.776888465673232450040827983), new FalconFPR(0.629638238914927025372981341),
            new FalconFPR(-0.629638238914927025372981341), new FalconFPR(0.776888465673232450040827983),
            new FalconFPR(0.104121633872054579120943880), new FalconFPR(0.994564570734255452119106243),
            new FalconFPR(-0.994564570734255452119106243), new FalconFPR(0.104121633872054579120943880),
            new FalconFPR(0.981963869109555264072848154), new FalconFPR(0.189068664149806212754997837),
            new FalconFPR(-0.189068664149806212754997837), new FalconFPR(0.981963869109555264072848154),
            new FalconFPR(0.560661576197336023839710223), new FalconFPR(0.828045045257755752067527592),
            new FalconFPR(-0.828045045257755752067527592), new FalconFPR(0.560661576197336023839710223),
            new FalconFPR(0.834862874986380056304401383), new FalconFPR(0.550457972936604802977289893),
            new FalconFPR(-0.550457972936604802977289893), new FalconFPR(0.834862874986380056304401383),
            new FalconFPR(0.201104634842091911558443546), new FalconFPR(0.979569765685440534439326110),
            new FalconFPR(-0.979569765685440534439326110), new FalconFPR(0.201104634842091911558443546),
            new FalconFPR(0.926210242138311341974793388), new FalconFPR(0.377007410216418256726567823),
            new FalconFPR(-0.377007410216418256726567823), new FalconFPR(0.926210242138311341974793388),
            new FalconFPR(0.388345046698826291624993541), new FalconFPR(0.921514039342041943465396332),
            new FalconFPR(-0.921514039342041943465396332), new FalconFPR(0.388345046698826291624993541),
            new FalconFPR(0.711432195745216441522130290), new FalconFPR(0.702754744457225302452914421),
            new FalconFPR(-0.702754744457225302452914421), new FalconFPR(0.711432195745216441522130290),
            new FalconFPR(0.006135884649154475359640235), new FalconFPR(0.999981175282601142656990438),
            new FalconFPR(-0.999981175282601142656990438), new FalconFPR(0.006135884649154475359640235),
            new FalconFPR(0.999995293809576171511580126), new FalconFPR(0.003067956762965976270145365),
            new FalconFPR(-0.003067956762965976270145365), new FalconFPR(0.999995293809576171511580126),
            new FalconFPR(0.704934080375904908852523758), new FalconFPR(0.709272826438865651316533772),
            new FalconFPR(-0.709272826438865651316533772), new FalconFPR(0.704934080375904908852523758),
            new FalconFPR(0.922701128333878570437264227), new FalconFPR(0.385516053843918864075607949),
            new FalconFPR(-0.385516053843918864075607949), new FalconFPR(0.922701128333878570437264227),
            new FalconFPR(0.379847208924051170576281147), new FalconFPR(0.925049240782677590302371869),
            new FalconFPR(-0.925049240782677590302371869), new FalconFPR(0.379847208924051170576281147),
            new FalconFPR(0.980182135968117392690210009), new FalconFPR(0.198098410717953586179324918),
            new FalconFPR(-0.198098410717953586179324918), new FalconFPR(0.980182135968117392690210009),
            new FalconFPR(0.553016705580027531764226988), new FalconFPR(0.833170164701913186439915922),
            new FalconFPR(-0.833170164701913186439915922), new FalconFPR(0.553016705580027531764226988),
            new FalconFPR(0.829761233794523042469023765), new FalconFPR(0.558118531220556115693702964),
            new FalconFPR(-0.558118531220556115693702964), new FalconFPR(0.829761233794523042469023765),
            new FalconFPR(0.192080397049892441679288205), new FalconFPR(0.981379193313754574318224190),
            new FalconFPR(-0.981379193313754574318224190), new FalconFPR(0.192080397049892441679288205),
            new FalconFPR(0.994879330794805620591166107), new FalconFPR(0.101069862754827824987887585),
            new FalconFPR(-0.101069862754827824987887585), new FalconFPR(0.994879330794805620591166107),
            new FalconFPR(0.632018735939809021909403706), new FalconFPR(0.774953106594873878359129282),
            new FalconFPR(-0.774953106594873878359129282), new FalconFPR(0.632018735939809021909403706),
            new FalconFPR(0.880470889052160770806542929), new FalconFPR(0.474100214650550014398580015),
            new FalconFPR(-0.474100214650550014398580015), new FalconFPR(0.880470889052160770806542929),
            new FalconFPR(0.287347459544729526477331841), new FalconFPR(0.957826413027532890321037029),
            new FalconFPR(-0.957826413027532890321037029), new FalconFPR(0.287347459544729526477331841),
            new FalconFPR(0.956045251349996443270479823), new FalconFPR(0.293219162694258650606608599),
            new FalconFPR(-0.293219162694258650606608599), new FalconFPR(0.956045251349996443270479823),
            new FalconFPR(0.468688822035827933697617870), new FalconFPR(0.883363338665731594736308015),
            new FalconFPR(-0.883363338665731594736308015), new FalconFPR(0.468688822035827933697617870),
            new FalconFPR(0.771060524261813773200605759), new FalconFPR(0.636761861236284230413943435),
            new FalconFPR(-0.636761861236284230413943435), new FalconFPR(0.771060524261813773200605759),
            new FalconFPR(0.094963495329638998938034312), new FalconFPR(0.995480755491926941769171600),
            new FalconFPR(-0.995480755491926941769171600), new FalconFPR(0.094963495329638998938034312),
            new FalconFPR(0.998640218180265222418199049), new FalconFPR(0.052131704680283321236358216),
            new FalconFPR(-0.052131704680283321236358216), new FalconFPR(0.998640218180265222418199049),
            new FalconFPR(0.669282588346636065720696366), new FalconFPR(0.743007952135121693517362293),
            new FalconFPR(-0.743007952135121693517362293), new FalconFPR(0.669282588346636065720696366),
            new FalconFPR(0.902673318237258806751502391), new FalconFPR(0.430326481340082633908199031),
            new FalconFPR(-0.430326481340082633908199031), new FalconFPR(0.902673318237258806751502391),
            new FalconFPR(0.333999651442009404650865481), new FalconFPR(0.942573197601446879280758735),
            new FalconFPR(-0.942573197601446879280758735), new FalconFPR(0.333999651442009404650865481),
            new FalconFPR(0.969281235356548486048290738), new FalconFPR(0.245955050335794611599924709),
            new FalconFPR(-0.245955050335794611599924709), new FalconFPR(0.969281235356548486048290738),
            new FalconFPR(0.511468850437970399504391001), new FalconFPR(0.859301818357008404783582139),
            new FalconFPR(-0.859301818357008404783582139), new FalconFPR(0.511468850437970399504391001),
            new FalconFPR(0.801376171723140219430247777), new FalconFPR(0.598160706996342311724958652),
            new FalconFPR(-0.598160706996342311724958652), new FalconFPR(0.801376171723140219430247777),
            new FalconFPR(0.143695033150294454819773349), new FalconFPR(0.989622017463200834623694454),
            new FalconFPR(-0.989622017463200834623694454), new FalconFPR(0.143695033150294454819773349),
            new FalconFPR(0.988721691960323767604516485), new FalconFPR(0.149764534677321517229695737),
            new FalconFPR(-0.149764534677321517229695737), new FalconFPR(0.988721691960323767604516485),
            new FalconFPR(0.593232295039799808047809426), new FalconFPR(0.805031331142963597922659282),
            new FalconFPR(-0.805031331142963597922659282), new FalconFPR(0.593232295039799808047809426),
            new FalconFPR(0.856147328375194481019630732), new FalconFPR(0.516731799017649881508753876),
            new FalconFPR(-0.516731799017649881508753876), new FalconFPR(0.856147328375194481019630732),
            new FalconFPR(0.240003022448741486568922365), new FalconFPR(0.970772140728950302138169611),
            new FalconFPR(-0.970772140728950302138169611), new FalconFPR(0.240003022448741486568922365),
            new FalconFPR(0.940506070593268323787291309), new FalconFPR(0.339776884406826857828825803),
            new FalconFPR(-0.339776884406826857828825803), new FalconFPR(0.940506070593268323787291309),
            new FalconFPR(0.424779681209108833357226189), new FalconFPR(0.905296759318118774354048329),
            new FalconFPR(-0.905296759318118774354048329), new FalconFPR(0.424779681209108833357226189),
            new FalconFPR(0.738887324460615147933116508), new FalconFPR(0.673829000378756060917568372),
            new FalconFPR(-0.673829000378756060917568372), new FalconFPR(0.738887324460615147933116508),
            new FalconFPR(0.046003182130914628814301788), new FalconFPR(0.998941293186856850633930266),
            new FalconFPR(-0.998941293186856850633930266), new FalconFPR(0.046003182130914628814301788),
            new FalconFPR(0.999618822495178597116830637), new FalconFPR(0.027608145778965741612354872),
            new FalconFPR(-0.027608145778965741612354872), new FalconFPR(0.999618822495178597116830637),
            new FalconFPR(0.687315340891759108199186948), new FalconFPR(0.726359155084345976817494315),
            new FalconFPR(-0.726359155084345976817494315), new FalconFPR(0.687315340891759108199186948),
            new FalconFPR(0.912962190428398164628018233), new FalconFPR(0.408044162864978680820747499),
            new FalconFPR(-0.408044162864978680820747499), new FalconFPR(0.912962190428398164628018233),
            new FalconFPR(0.357030961233430032614954036), new FalconFPR(0.934092550404258914729877883),
            new FalconFPR(-0.934092550404258914729877883), new FalconFPR(0.357030961233430032614954036),
            new FalconFPR(0.975025345066994146844913468), new FalconFPR(0.222093620973203534094094721),
            new FalconFPR(-0.222093620973203534094094721), new FalconFPR(0.975025345066994146844913468),
            new FalconFPR(0.532403127877197971442805218), new FalconFPR(0.846490938774052078300544488),
            new FalconFPR(-0.846490938774052078300544488), new FalconFPR(0.532403127877197971442805218),
            new FalconFPR(0.815814410806733789010772660), new FalconFPR(0.578313796411655563342245019),
            new FalconFPR(-0.578313796411655563342245019), new FalconFPR(0.815814410806733789010772660),
            new FalconFPR(0.167938294974731178054745536), new FalconFPR(0.985797509167567424700995000),
            new FalconFPR(-0.985797509167567424700995000), new FalconFPR(0.167938294974731178054745536),
            new FalconFPR(0.992099313142191757112085445), new FalconFPR(0.125454983411546238542336453),
            new FalconFPR(-0.125454983411546238542336453), new FalconFPR(0.992099313142191757112085445),
            new FalconFPR(0.612810082429409703935211936), new FalconFPR(0.790230221437310055030217152),
            new FalconFPR(-0.790230221437310055030217152), new FalconFPR(0.612810082429409703935211936),
            new FalconFPR(0.868570705971340895340449876), new FalconFPR(0.495565261825772531150266670),
            new FalconFPR(-0.495565261825772531150266670), new FalconFPR(0.868570705971340895340449876),
            new FalconFPR(0.263754678974831383611349322), new FalconFPR(0.964589793289812723836432159),
            new FalconFPR(-0.964589793289812723836432159), new FalconFPR(0.263754678974831383611349322),
            new FalconFPR(0.948561349915730288158494826), new FalconFPR(0.316593375556165867243047035),
            new FalconFPR(-0.316593375556165867243047035), new FalconFPR(0.948561349915730288158494826),
            new FalconFPR(0.446868840162374195353044389), new FalconFPR(0.894599485631382678433072126),
            new FalconFPR(-0.894599485631382678433072126), new FalconFPR(0.446868840162374195353044389),
            new FalconFPR(0.755201376896536527598710756), new FalconFPR(0.655492852999615385312679701),
            new FalconFPR(-0.655492852999615385312679701), new FalconFPR(0.755201376896536527598710756),
            new FalconFPR(0.070504573389613863027351471), new FalconFPR(0.997511456140303459699448390),
            new FalconFPR(-0.997511456140303459699448390), new FalconFPR(0.070504573389613863027351471),
            new FalconFPR(0.997060070339482978987989949), new FalconFPR(0.076623861392031492278332463),
            new FalconFPR(-0.076623861392031492278332463), new FalconFPR(0.997060070339482978987989949),
            new FalconFPR(0.650846684996380915068975573), new FalconFPR(0.759209188978388033485525443),
            new FalconFPR(-0.759209188978388033485525443), new FalconFPR(0.650846684996380915068975573),
            new FalconFPR(0.891840709392342727796478697), new FalconFPR(0.452349587233770874133026703),
            new FalconFPR(-0.452349587233770874133026703), new FalconFPR(0.891840709392342727796478697),
            new FalconFPR(0.310767152749611495835997250), new FalconFPR(0.950486073949481721759926101),
            new FalconFPR(-0.950486073949481721759926101), new FalconFPR(0.310767152749611495835997250),
            new FalconFPR(0.962953266873683886347921481), new FalconFPR(0.269668325572915106525464462),
            new FalconFPR(-0.269668325572915106525464462), new FalconFPR(0.962953266873683886347921481),
            new FalconFPR(0.490226483288291154229598449), new FalconFPR(0.871595086655951034842481435),
            new FalconFPR(-0.871595086655951034842481435), new FalconFPR(0.490226483288291154229598449),
            new FalconFPR(0.786455213599085757522319464), new FalconFPR(0.617647307937803932403979402),
            new FalconFPR(-0.617647307937803932403979402), new FalconFPR(0.786455213599085757522319464),
            new FalconFPR(0.119365214810991364593637790), new FalconFPR(0.992850414459865090793563344),
            new FalconFPR(-0.992850414459865090793563344), new FalconFPR(0.119365214810991364593637790),
            new FalconFPR(0.984748501801904218556553176), new FalconFPR(0.173983873387463827950700807),
            new FalconFPR(-0.173983873387463827950700807), new FalconFPR(0.984748501801904218556553176),
            new FalconFPR(0.573297166698042212820171239), new FalconFPR(0.819347520076796960824689637),
            new FalconFPR(-0.819347520076796960824689637), new FalconFPR(0.573297166698042212820171239),
            new FalconFPR(0.843208239641845437161743865), new FalconFPR(0.537587076295645482502214932),
            new FalconFPR(-0.537587076295645482502214932), new FalconFPR(0.843208239641845437161743865),
            new FalconFPR(0.216106797076219509948385131), new FalconFPR(0.976369731330021149312732194),
            new FalconFPR(-0.976369731330021149312732194), new FalconFPR(0.216106797076219509948385131),
            new FalconFPR(0.931884265581668106718557199), new FalconFPR(0.362755724367397216204854462),
            new FalconFPR(-0.362755724367397216204854462), new FalconFPR(0.931884265581668106718557199),
            new FalconFPR(0.402434650859418441082533934), new FalconFPR(0.915448716088267819566431292),
            new FalconFPR(-0.915448716088267819566431292), new FalconFPR(0.402434650859418441082533934),
            new FalconFPR(0.722128193929215321243607198), new FalconFPR(0.691759258364157774906734132),
            new FalconFPR(-0.691759258364157774906734132), new FalconFPR(0.722128193929215321243607198),
            new FalconFPR(0.021474080275469507418374898), new FalconFPR(0.999769405351215321657617036),
            new FalconFPR(-0.999769405351215321657617036), new FalconFPR(0.021474080275469507418374898),
            new FalconFPR(0.999882347454212525633049627), new FalconFPR(0.015339206284988101044151868),
            new FalconFPR(-0.015339206284988101044151868), new FalconFPR(0.999882347454212525633049627),
            new FalconFPR(0.696177131491462944788582591), new FalconFPR(0.717870045055731736211325329),
            new FalconFPR(-0.717870045055731736211325329), new FalconFPR(0.696177131491462944788582591),
            new FalconFPR(0.917900775621390457642276297), new FalconFPR(0.396809987416710328595290911),
            new FalconFPR(-0.396809987416710328595290911), new FalconFPR(0.917900775621390457642276297),
            new FalconFPR(0.368466829953372331712746222), new FalconFPR(0.929640895843181265457918066),
            new FalconFPR(-0.929640895843181265457918066), new FalconFPR(0.368466829953372331712746222),
            new FalconFPR(0.977677357824509979943404762), new FalconFPR(0.210111836880469621717489972),
            new FalconFPR(-0.210111836880469621717489972), new FalconFPR(0.977677357824509979943404762),
            new FalconFPR(0.542750784864515906586768661), new FalconFPR(0.839893794195999504583383987),
            new FalconFPR(-0.839893794195999504583383987), new FalconFPR(0.542750784864515906586768661),
            new FalconFPR(0.822849781375826332046780034), new FalconFPR(0.568258952670131549790548489),
            new FalconFPR(-0.568258952670131549790548489), new FalconFPR(0.822849781375826332046780034),
            new FalconFPR(0.180022901405699522679906590), new FalconFPR(0.983662419211730274396237776),
            new FalconFPR(-0.983662419211730274396237776), new FalconFPR(0.180022901405699522679906590),
            new FalconFPR(0.993564135520595333782021697), new FalconFPR(0.113270952177564349018228733),
            new FalconFPR(-0.113270952177564349018228733), new FalconFPR(0.993564135520595333782021697),
            new FalconFPR(0.622461279374149972519166721), new FalconFPR(0.782650596166575738458949301),
            new FalconFPR(-0.782650596166575738458949301), new FalconFPR(0.622461279374149972519166721),
            new FalconFPR(0.874586652278176112634431897), new FalconFPR(0.484869248000791101822951699),
            new FalconFPR(-0.484869248000791101822951699), new FalconFPR(0.874586652278176112634431897),
            new FalconFPR(0.275571819310958163076425168), new FalconFPR(0.961280485811320641748659653),
            new FalconFPR(-0.961280485811320641748659653), new FalconFPR(0.275571819310958163076425168),
            new FalconFPR(0.952375012719765858529893608), new FalconFPR(0.304929229735402406490728633),
            new FalconFPR(-0.304929229735402406490728633), new FalconFPR(0.952375012719765858529893608),
            new FalconFPR(0.457813303598877221904961155), new FalconFPR(0.889048355854664562540777729),
            new FalconFPR(-0.889048355854664562540777729), new FalconFPR(0.457813303598877221904961155),
            new FalconFPR(0.763188417263381271704838297), new FalconFPR(0.646176012983316364832802220),
            new FalconFPR(-0.646176012983316364832802220), new FalconFPR(0.763188417263381271704838297),
            new FalconFPR(0.082740264549375693111987083), new FalconFPR(0.996571145790554847093566910),
            new FalconFPR(-0.996571145790554847093566910), new FalconFPR(0.082740264549375693111987083),
            new FalconFPR(0.997925286198596012623025462), new FalconFPR(0.064382630929857460819324537),
            new FalconFPR(-0.064382630929857460819324537), new FalconFPR(0.997925286198596012623025462),
            new FalconFPR(0.660114342067420478559490747), new FalconFPR(0.751165131909686411205819422),
            new FalconFPR(-0.751165131909686411205819422), new FalconFPR(0.660114342067420478559490747),
            new FalconFPR(0.897324580705418281231391836), new FalconFPR(0.441371268731716692879988968),
            new FalconFPR(-0.441371268731716692879988968), new FalconFPR(0.897324580705418281231391836),
            new FalconFPR(0.322407678801069848384807478), new FalconFPR(0.946600913083283570044599823),
            new FalconFPR(-0.946600913083283570044599823), new FalconFPR(0.322407678801069848384807478),
            new FalconFPR(0.966190003445412555433832961), new FalconFPR(0.257831102162159005614471295),
            new FalconFPR(-0.257831102162159005614471295), new FalconFPR(0.966190003445412555433832961),
            new FalconFPR(0.500885382611240786241285004), new FalconFPR(0.865513624090569082825488358),
            new FalconFPR(-0.865513624090569082825488358), new FalconFPR(0.500885382611240786241285004),
            new FalconFPR(0.793975477554337164895083757), new FalconFPR(0.607949784967773667243642671),
            new FalconFPR(-0.607949784967773667243642671), new FalconFPR(0.793975477554337164895083757),
            new FalconFPR(0.131540028702883111103387493), new FalconFPR(0.991310859846115418957349799),
            new FalconFPR(-0.991310859846115418957349799), new FalconFPR(0.131540028702883111103387493),
            new FalconFPR(0.986809401814185476970235952), new FalconFPR(0.161886393780111837641387995),
            new FalconFPR(-0.161886393780111837641387995), new FalconFPR(0.986809401814185476970235952),
            new FalconFPR(0.583308652937698294392830961), new FalconFPR(0.812250586585203913049744181),
            new FalconFPR(-0.812250586585203913049744181), new FalconFPR(0.583308652937698294392830961),
            new FalconFPR(0.849741768000852489471268395), new FalconFPR(0.527199134781901348464274575),
            new FalconFPR(-0.527199134781901348464274575), new FalconFPR(0.849741768000852489471268395),
            new FalconFPR(0.228072083170885739254457379), new FalconFPR(0.973644249650811925318383912),
            new FalconFPR(-0.973644249650811925318383912), new FalconFPR(0.228072083170885739254457379),
            new FalconFPR(0.936265667170278246576310996), new FalconFPR(0.351292756085567125601307623),
            new FalconFPR(-0.351292756085567125601307623), new FalconFPR(0.936265667170278246576310996),
            new FalconFPR(0.413638312238434547471944324), new FalconFPR(0.910441292258067196934095369),
            new FalconFPR(-0.910441292258067196934095369), new FalconFPR(0.413638312238434547471944324),
            new FalconFPR(0.730562769227827561177758850), new FalconFPR(0.682845546385248068164596123),
            new FalconFPR(-0.682845546385248068164596123), new FalconFPR(0.730562769227827561177758850),
            new FalconFPR(0.033741171851377584833716112), new FalconFPR(0.999430604555461772019008327),
            new FalconFPR(-0.999430604555461772019008327), new FalconFPR(0.033741171851377584833716112),
            new FalconFPR(0.999204758618363895492950001), new FalconFPR(0.039872927587739811128578738),
            new FalconFPR(-0.039872927587739811128578738), new FalconFPR(0.999204758618363895492950001),
            new FalconFPR(0.678350043129861486873655042), new FalconFPR(0.734738878095963464563223604),
            new FalconFPR(-0.734738878095963464563223604), new FalconFPR(0.678350043129861486873655042),
            new FalconFPR(0.907886116487666212038681480), new FalconFPR(0.419216888363223956433010020),
            new FalconFPR(-0.419216888363223956433010020), new FalconFPR(0.907886116487666212038681480),
            new FalconFPR(0.345541324963989065539191723), new FalconFPR(0.938403534063108112192420774),
            new FalconFPR(-0.938403534063108112192420774), new FalconFPR(0.345541324963989065539191723),
            new FalconFPR(0.972226497078936305708321144), new FalconFPR(0.234041958583543423191242045),
            new FalconFPR(-0.234041958583543423191242045), new FalconFPR(0.972226497078936305708321144),
            new FalconFPR(0.521975292937154342694258318), new FalconFPR(0.852960604930363657746588082),
            new FalconFPR(-0.852960604930363657746588082), new FalconFPR(0.521975292937154342694258318),
            new FalconFPR(0.808656181588174991946968128), new FalconFPR(0.588281548222645304786439813),
            new FalconFPR(-0.588281548222645304786439813), new FalconFPR(0.808656181588174991946968128),
            new FalconFPR(0.155828397654265235743101486), new FalconFPR(0.987784141644572154230969032),
            new FalconFPR(-0.987784141644572154230969032), new FalconFPR(0.155828397654265235743101486),
            new FalconFPR(0.990485084256457037998682243), new FalconFPR(0.137620121586486044948441663),
            new FalconFPR(-0.137620121586486044948441663), new FalconFPR(0.990485084256457037998682243),
            new FalconFPR(0.603066598540348201693430617), new FalconFPR(0.797690840943391108362662755),
            new FalconFPR(-0.797690840943391108362662755), new FalconFPR(0.603066598540348201693430617),
            new FalconFPR(0.862423956111040538690933878), new FalconFPR(0.506186645345155291048942344),
            new FalconFPR(-0.506186645345155291048942344), new FalconFPR(0.862423956111040538690933878),
            new FalconFPR(0.251897818154216950498106628), new FalconFPR(0.967753837093475465243391912),
            new FalconFPR(-0.967753837093475465243391912), new FalconFPR(0.251897818154216950498106628),
            new FalconFPR(0.944604837261480265659265493), new FalconFPR(0.328209843579092526107916817),
            new FalconFPR(-0.328209843579092526107916817), new FalconFPR(0.944604837261480265659265493),
            new FalconFPR(0.435857079922255491032544080), new FalconFPR(0.900015892016160228714535267),
            new FalconFPR(-0.900015892016160228714535267), new FalconFPR(0.435857079922255491032544080),
            new FalconFPR(0.747100605980180144323078847), new FalconFPR(0.664710978203344868130324985),
            new FalconFPR(-0.664710978203344868130324985), new FalconFPR(0.747100605980180144323078847),
            new FalconFPR(0.058258264500435759613979782), new FalconFPR(0.998301544933892840738782163),
            new FalconFPR(-0.998301544933892840738782163), new FalconFPR(0.058258264500435759613979782),
            new FalconFPR(0.996044700901251989887944810), new FalconFPR(0.088853552582524596561586535),
            new FalconFPR(-0.088853552582524596561586535), new FalconFPR(0.996044700901251989887944810),
            new FalconFPR(0.641481012808583151988739898), new FalconFPR(0.767138911935820381181694573),
            new FalconFPR(-0.767138911935820381181694573), new FalconFPR(0.641481012808583151988739898),
            new FalconFPR(0.886222530148880631647990821), new FalconFPR(0.463259783551860197390719637),
            new FalconFPR(-0.463259783551860197390719637), new FalconFPR(0.886222530148880631647990821),
            new FalconFPR(0.299079826308040476750336973), new FalconFPR(0.954228095109105629780430732),
            new FalconFPR(-0.954228095109105629780430732), new FalconFPR(0.299079826308040476750336973),
            new FalconFPR(0.959571513081984528335528181), new FalconFPR(0.281464937925757984095231007),
            new FalconFPR(-0.281464937925757984095231007), new FalconFPR(0.959571513081984528335528181),
            new FalconFPR(0.479493757660153026679839798), new FalconFPR(0.877545290207261291668470750),
            new FalconFPR(-0.877545290207261291668470750), new FalconFPR(0.479493757660153026679839798),
            new FalconFPR(0.778816512381475953374724325), new FalconFPR(0.627251815495144113509622565),
            new FalconFPR(-0.627251815495144113509622565), new FalconFPR(0.778816512381475953374724325),
            new FalconFPR(0.107172424956808849175529148), new FalconFPR(0.994240449453187946358413442),
            new FalconFPR(-0.994240449453187946358413442), new FalconFPR(0.107172424956808849175529148),
            new FalconFPR(0.982539302287441255907040396), new FalconFPR(0.186055151663446648105438304),
            new FalconFPR(-0.186055151663446648105438304), new FalconFPR(0.982539302287441255907040396),
            new FalconFPR(0.563199344013834115007363772), new FalconFPR(0.826321062845663480311195452),
            new FalconFPR(-0.826321062845663480311195452), new FalconFPR(0.563199344013834115007363772),
            new FalconFPR(0.836547727223511984524285790), new FalconFPR(0.547894059173100165608820571),
            new FalconFPR(-0.547894059173100165608820571), new FalconFPR(0.836547727223511984524285790),
            new FalconFPR(0.204108966092816874181696950), new FalconFPR(0.978948175319062194715480124),
            new FalconFPR(-0.978948175319062194715480124), new FalconFPR(0.204108966092816874181696950),
            new FalconFPR(0.927362525650401087274536959), new FalconFPR(0.374164062971457997104393020),
            new FalconFPR(-0.374164062971457997104393020), new FalconFPR(0.927362525650401087274536959),
            new FalconFPR(0.391170384302253888687512949), new FalconFPR(0.920318276709110566440076541),
            new FalconFPR(-0.920318276709110566440076541), new FalconFPR(0.391170384302253888687512949),
            new FalconFPR(0.713584868780793592903125099), new FalconFPR(0.700568793943248366792866380),
            new FalconFPR(-0.700568793943248366792866380), new FalconFPR(0.713584868780793592903125099),
            new FalconFPR(0.009203754782059819315102378), new FalconFPR(0.999957644551963866333120920),
            new FalconFPR(-0.999957644551963866333120920), new FalconFPR(0.009203754782059819315102378),
            new FalconFPR(0.999957644551963866333120920), new FalconFPR(0.009203754782059819315102378),
            new FalconFPR(-0.009203754782059819315102378), new FalconFPR(0.999957644551963866333120920),
            new FalconFPR(0.700568793943248366792866380), new FalconFPR(0.713584868780793592903125099),
            new FalconFPR(-0.713584868780793592903125099), new FalconFPR(0.700568793943248366792866380),
            new FalconFPR(0.920318276709110566440076541), new FalconFPR(0.391170384302253888687512949),
            new FalconFPR(-0.391170384302253888687512949), new FalconFPR(0.920318276709110566440076541),
            new FalconFPR(0.374164062971457997104393020), new FalconFPR(0.927362525650401087274536959),
            new FalconFPR(-0.927362525650401087274536959), new FalconFPR(0.374164062971457997104393020),
            new FalconFPR(0.978948175319062194715480124), new FalconFPR(0.204108966092816874181696950),
            new FalconFPR(-0.204108966092816874181696950), new FalconFPR(0.978948175319062194715480124),
            new FalconFPR(0.547894059173100165608820571), new FalconFPR(0.836547727223511984524285790),
            new FalconFPR(-0.836547727223511984524285790), new FalconFPR(0.547894059173100165608820571),
            new FalconFPR(0.826321062845663480311195452), new FalconFPR(0.563199344013834115007363772),
            new FalconFPR(-0.563199344013834115007363772), new FalconFPR(0.826321062845663480311195452),
            new FalconFPR(0.186055151663446648105438304), new FalconFPR(0.982539302287441255907040396),
            new FalconFPR(-0.982539302287441255907040396), new FalconFPR(0.186055151663446648105438304),
            new FalconFPR(0.994240449453187946358413442), new FalconFPR(0.107172424956808849175529148),
            new FalconFPR(-0.107172424956808849175529148), new FalconFPR(0.994240449453187946358413442),
            new FalconFPR(0.627251815495144113509622565), new FalconFPR(0.778816512381475953374724325),
            new FalconFPR(-0.778816512381475953374724325), new FalconFPR(0.627251815495144113509622565),
            new FalconFPR(0.877545290207261291668470750), new FalconFPR(0.479493757660153026679839798),
            new FalconFPR(-0.479493757660153026679839798), new FalconFPR(0.877545290207261291668470750),
            new FalconFPR(0.281464937925757984095231007), new FalconFPR(0.959571513081984528335528181),
            new FalconFPR(-0.959571513081984528335528181), new FalconFPR(0.281464937925757984095231007),
            new FalconFPR(0.954228095109105629780430732), new FalconFPR(0.299079826308040476750336973),
            new FalconFPR(-0.299079826308040476750336973), new FalconFPR(0.954228095109105629780430732),
            new FalconFPR(0.463259783551860197390719637), new FalconFPR(0.886222530148880631647990821),
            new FalconFPR(-0.886222530148880631647990821), new FalconFPR(0.463259783551860197390719637),
            new FalconFPR(0.767138911935820381181694573), new FalconFPR(0.641481012808583151988739898),
            new FalconFPR(-0.641481012808583151988739898), new FalconFPR(0.767138911935820381181694573),
            new FalconFPR(0.088853552582524596561586535), new FalconFPR(0.996044700901251989887944810),
            new FalconFPR(-0.996044700901251989887944810), new FalconFPR(0.088853552582524596561586535),
            new FalconFPR(0.998301544933892840738782163), new FalconFPR(0.058258264500435759613979782),
            new FalconFPR(-0.058258264500435759613979782), new FalconFPR(0.998301544933892840738782163),
            new FalconFPR(0.664710978203344868130324985), new FalconFPR(0.747100605980180144323078847),
            new FalconFPR(-0.747100605980180144323078847), new FalconFPR(0.664710978203344868130324985),
            new FalconFPR(0.900015892016160228714535267), new FalconFPR(0.435857079922255491032544080),
            new FalconFPR(-0.435857079922255491032544080), new FalconFPR(0.900015892016160228714535267),
            new FalconFPR(0.328209843579092526107916817), new FalconFPR(0.944604837261480265659265493),
            new FalconFPR(-0.944604837261480265659265493), new FalconFPR(0.328209843579092526107916817),
            new FalconFPR(0.967753837093475465243391912), new FalconFPR(0.251897818154216950498106628),
            new FalconFPR(-0.251897818154216950498106628), new FalconFPR(0.967753837093475465243391912),
            new FalconFPR(0.506186645345155291048942344), new FalconFPR(0.862423956111040538690933878),
            new FalconFPR(-0.862423956111040538690933878), new FalconFPR(0.506186645345155291048942344),
            new FalconFPR(0.797690840943391108362662755), new FalconFPR(0.603066598540348201693430617),
            new FalconFPR(-0.603066598540348201693430617), new FalconFPR(0.797690840943391108362662755),
            new FalconFPR(0.137620121586486044948441663), new FalconFPR(0.990485084256457037998682243),
            new FalconFPR(-0.990485084256457037998682243), new FalconFPR(0.137620121586486044948441663),
            new FalconFPR(0.987784141644572154230969032), new FalconFPR(0.155828397654265235743101486),
            new FalconFPR(-0.155828397654265235743101486), new FalconFPR(0.987784141644572154230969032),
            new FalconFPR(0.588281548222645304786439813), new FalconFPR(0.808656181588174991946968128),
            new FalconFPR(-0.808656181588174991946968128), new FalconFPR(0.588281548222645304786439813),
            new FalconFPR(0.852960604930363657746588082), new FalconFPR(0.521975292937154342694258318),
            new FalconFPR(-0.521975292937154342694258318), new FalconFPR(0.852960604930363657746588082),
            new FalconFPR(0.234041958583543423191242045), new FalconFPR(0.972226497078936305708321144),
            new FalconFPR(-0.972226497078936305708321144), new FalconFPR(0.234041958583543423191242045),
            new FalconFPR(0.938403534063108112192420774), new FalconFPR(0.345541324963989065539191723),
            new FalconFPR(-0.345541324963989065539191723), new FalconFPR(0.938403534063108112192420774),
            new FalconFPR(0.419216888363223956433010020), new FalconFPR(0.907886116487666212038681480),
            new FalconFPR(-0.907886116487666212038681480), new FalconFPR(0.419216888363223956433010020),
            new FalconFPR(0.734738878095963464563223604), new FalconFPR(0.678350043129861486873655042),
            new FalconFPR(-0.678350043129861486873655042), new FalconFPR(0.734738878095963464563223604),
            new FalconFPR(0.039872927587739811128578738), new FalconFPR(0.999204758618363895492950001),
            new FalconFPR(-0.999204758618363895492950001), new FalconFPR(0.039872927587739811128578738),
            new FalconFPR(0.999430604555461772019008327), new FalconFPR(0.033741171851377584833716112),
            new FalconFPR(-0.033741171851377584833716112), new FalconFPR(0.999430604555461772019008327),
            new FalconFPR(0.682845546385248068164596123), new FalconFPR(0.730562769227827561177758850),
            new FalconFPR(-0.730562769227827561177758850), new FalconFPR(0.682845546385248068164596123),
            new FalconFPR(0.910441292258067196934095369), new FalconFPR(0.413638312238434547471944324),
            new FalconFPR(-0.413638312238434547471944324), new FalconFPR(0.910441292258067196934095369),
            new FalconFPR(0.351292756085567125601307623), new FalconFPR(0.936265667170278246576310996),
            new FalconFPR(-0.936265667170278246576310996), new FalconFPR(0.351292756085567125601307623),
            new FalconFPR(0.973644249650811925318383912), new FalconFPR(0.228072083170885739254457379),
            new FalconFPR(-0.228072083170885739254457379), new FalconFPR(0.973644249650811925318383912),
            new FalconFPR(0.527199134781901348464274575), new FalconFPR(0.849741768000852489471268395),
            new FalconFPR(-0.849741768000852489471268395), new FalconFPR(0.527199134781901348464274575),
            new FalconFPR(0.812250586585203913049744181), new FalconFPR(0.583308652937698294392830961),
            new FalconFPR(-0.583308652937698294392830961), new FalconFPR(0.812250586585203913049744181),
            new FalconFPR(0.161886393780111837641387995), new FalconFPR(0.986809401814185476970235952),
            new FalconFPR(-0.986809401814185476970235952), new FalconFPR(0.161886393780111837641387995),
            new FalconFPR(0.991310859846115418957349799), new FalconFPR(0.131540028702883111103387493),
            new FalconFPR(-0.131540028702883111103387493), new FalconFPR(0.991310859846115418957349799),
            new FalconFPR(0.607949784967773667243642671), new FalconFPR(0.793975477554337164895083757),
            new FalconFPR(-0.793975477554337164895083757), new FalconFPR(0.607949784967773667243642671),
            new FalconFPR(0.865513624090569082825488358), new FalconFPR(0.500885382611240786241285004),
            new FalconFPR(-0.500885382611240786241285004), new FalconFPR(0.865513624090569082825488358),
            new FalconFPR(0.257831102162159005614471295), new FalconFPR(0.966190003445412555433832961),
            new FalconFPR(-0.966190003445412555433832961), new FalconFPR(0.257831102162159005614471295),
            new FalconFPR(0.946600913083283570044599823), new FalconFPR(0.322407678801069848384807478),
            new FalconFPR(-0.322407678801069848384807478), new FalconFPR(0.946600913083283570044599823),
            new FalconFPR(0.441371268731716692879988968), new FalconFPR(0.897324580705418281231391836),
            new FalconFPR(-0.897324580705418281231391836), new FalconFPR(0.441371268731716692879988968),
            new FalconFPR(0.751165131909686411205819422), new FalconFPR(0.660114342067420478559490747),
            new FalconFPR(-0.660114342067420478559490747), new FalconFPR(0.751165131909686411205819422),
            new FalconFPR(0.064382630929857460819324537), new FalconFPR(0.997925286198596012623025462),
            new FalconFPR(-0.997925286198596012623025462), new FalconFPR(0.064382630929857460819324537),
            new FalconFPR(0.996571145790554847093566910), new FalconFPR(0.082740264549375693111987083),
            new FalconFPR(-0.082740264549375693111987083), new FalconFPR(0.996571145790554847093566910),
            new FalconFPR(0.646176012983316364832802220), new FalconFPR(0.763188417263381271704838297),
            new FalconFPR(-0.763188417263381271704838297), new FalconFPR(0.646176012983316364832802220),
            new FalconFPR(0.889048355854664562540777729), new FalconFPR(0.457813303598877221904961155),
            new FalconFPR(-0.457813303598877221904961155), new FalconFPR(0.889048355854664562540777729),
            new FalconFPR(0.304929229735402406490728633), new FalconFPR(0.952375012719765858529893608),
            new FalconFPR(-0.952375012719765858529893608), new FalconFPR(0.304929229735402406490728633),
            new FalconFPR(0.961280485811320641748659653), new FalconFPR(0.275571819310958163076425168),
            new FalconFPR(-0.275571819310958163076425168), new FalconFPR(0.961280485811320641748659653),
            new FalconFPR(0.484869248000791101822951699), new FalconFPR(0.874586652278176112634431897),
            new FalconFPR(-0.874586652278176112634431897), new FalconFPR(0.484869248000791101822951699),
            new FalconFPR(0.782650596166575738458949301), new FalconFPR(0.622461279374149972519166721),
            new FalconFPR(-0.622461279374149972519166721), new FalconFPR(0.782650596166575738458949301),
            new FalconFPR(0.113270952177564349018228733), new FalconFPR(0.993564135520595333782021697),
            new FalconFPR(-0.993564135520595333782021697), new FalconFPR(0.113270952177564349018228733),
            new FalconFPR(0.983662419211730274396237776), new FalconFPR(0.180022901405699522679906590),
            new FalconFPR(-0.180022901405699522679906590), new FalconFPR(0.983662419211730274396237776),
            new FalconFPR(0.568258952670131549790548489), new FalconFPR(0.822849781375826332046780034),
            new FalconFPR(-0.822849781375826332046780034), new FalconFPR(0.568258952670131549790548489),
            new FalconFPR(0.839893794195999504583383987), new FalconFPR(0.542750784864515906586768661),
            new FalconFPR(-0.542750784864515906586768661), new FalconFPR(0.839893794195999504583383987),
            new FalconFPR(0.210111836880469621717489972), new FalconFPR(0.977677357824509979943404762),
            new FalconFPR(-0.977677357824509979943404762), new FalconFPR(0.210111836880469621717489972),
            new FalconFPR(0.929640895843181265457918066), new FalconFPR(0.368466829953372331712746222),
            new FalconFPR(-0.368466829953372331712746222), new FalconFPR(0.929640895843181265457918066),
            new FalconFPR(0.396809987416710328595290911), new FalconFPR(0.917900775621390457642276297),
            new FalconFPR(-0.917900775621390457642276297), new FalconFPR(0.396809987416710328595290911),
            new FalconFPR(0.717870045055731736211325329), new FalconFPR(0.696177131491462944788582591),
            new FalconFPR(-0.696177131491462944788582591), new FalconFPR(0.717870045055731736211325329),
            new FalconFPR(0.015339206284988101044151868), new FalconFPR(0.999882347454212525633049627),
            new FalconFPR(-0.999882347454212525633049627), new FalconFPR(0.015339206284988101044151868),
            new FalconFPR(0.999769405351215321657617036), new FalconFPR(0.021474080275469507418374898),
            new FalconFPR(-0.021474080275469507418374898), new FalconFPR(0.999769405351215321657617036),
            new FalconFPR(0.691759258364157774906734132), new FalconFPR(0.722128193929215321243607198),
            new FalconFPR(-0.722128193929215321243607198), new FalconFPR(0.691759258364157774906734132),
            new FalconFPR(0.915448716088267819566431292), new FalconFPR(0.402434650859418441082533934),
            new FalconFPR(-0.402434650859418441082533934), new FalconFPR(0.915448716088267819566431292),
            new FalconFPR(0.362755724367397216204854462), new FalconFPR(0.931884265581668106718557199),
            new FalconFPR(-0.931884265581668106718557199), new FalconFPR(0.362755724367397216204854462),
            new FalconFPR(0.976369731330021149312732194), new FalconFPR(0.216106797076219509948385131),
            new FalconFPR(-0.216106797076219509948385131), new FalconFPR(0.976369731330021149312732194),
            new FalconFPR(0.537587076295645482502214932), new FalconFPR(0.843208239641845437161743865),
            new FalconFPR(-0.843208239641845437161743865), new FalconFPR(0.537587076295645482502214932),
            new FalconFPR(0.819347520076796960824689637), new FalconFPR(0.573297166698042212820171239),
            new FalconFPR(-0.573297166698042212820171239), new FalconFPR(0.819347520076796960824689637),
            new FalconFPR(0.173983873387463827950700807), new FalconFPR(0.984748501801904218556553176),
            new FalconFPR(-0.984748501801904218556553176), new FalconFPR(0.173983873387463827950700807),
            new FalconFPR(0.992850414459865090793563344), new FalconFPR(0.119365214810991364593637790),
            new FalconFPR(-0.119365214810991364593637790), new FalconFPR(0.992850414459865090793563344),
            new FalconFPR(0.617647307937803932403979402), new FalconFPR(0.786455213599085757522319464),
            new FalconFPR(-0.786455213599085757522319464), new FalconFPR(0.617647307937803932403979402),
            new FalconFPR(0.871595086655951034842481435), new FalconFPR(0.490226483288291154229598449),
            new FalconFPR(-0.490226483288291154229598449), new FalconFPR(0.871595086655951034842481435),
            new FalconFPR(0.269668325572915106525464462), new FalconFPR(0.962953266873683886347921481),
            new FalconFPR(-0.962953266873683886347921481), new FalconFPR(0.269668325572915106525464462),
            new FalconFPR(0.950486073949481721759926101), new FalconFPR(0.310767152749611495835997250),
            new FalconFPR(-0.310767152749611495835997250), new FalconFPR(0.950486073949481721759926101),
            new FalconFPR(0.452349587233770874133026703), new FalconFPR(0.891840709392342727796478697),
            new FalconFPR(-0.891840709392342727796478697), new FalconFPR(0.452349587233770874133026703),
            new FalconFPR(0.759209188978388033485525443), new FalconFPR(0.650846684996380915068975573),
            new FalconFPR(-0.650846684996380915068975573), new FalconFPR(0.759209188978388033485525443),
            new FalconFPR(0.076623861392031492278332463), new FalconFPR(0.997060070339482978987989949),
            new FalconFPR(-0.997060070339482978987989949), new FalconFPR(0.076623861392031492278332463),
            new FalconFPR(0.997511456140303459699448390), new FalconFPR(0.070504573389613863027351471),
            new FalconFPR(-0.070504573389613863027351471), new FalconFPR(0.997511456140303459699448390),
            new FalconFPR(0.655492852999615385312679701), new FalconFPR(0.755201376896536527598710756),
            new FalconFPR(-0.755201376896536527598710756), new FalconFPR(0.655492852999615385312679701),
            new FalconFPR(0.894599485631382678433072126), new FalconFPR(0.446868840162374195353044389),
            new FalconFPR(-0.446868840162374195353044389), new FalconFPR(0.894599485631382678433072126),
            new FalconFPR(0.316593375556165867243047035), new FalconFPR(0.948561349915730288158494826),
            new FalconFPR(-0.948561349915730288158494826), new FalconFPR(0.316593375556165867243047035),
            new FalconFPR(0.964589793289812723836432159), new FalconFPR(0.263754678974831383611349322),
            new FalconFPR(-0.263754678974831383611349322), new FalconFPR(0.964589793289812723836432159),
            new FalconFPR(0.495565261825772531150266670), new FalconFPR(0.868570705971340895340449876),
            new FalconFPR(-0.868570705971340895340449876), new FalconFPR(0.495565261825772531150266670),
            new FalconFPR(0.790230221437310055030217152), new FalconFPR(0.612810082429409703935211936),
            new FalconFPR(-0.612810082429409703935211936), new FalconFPR(0.790230221437310055030217152),
            new FalconFPR(0.125454983411546238542336453), new FalconFPR(0.992099313142191757112085445),
            new FalconFPR(-0.992099313142191757112085445), new FalconFPR(0.125454983411546238542336453),
            new FalconFPR(0.985797509167567424700995000), new FalconFPR(0.167938294974731178054745536),
            new FalconFPR(-0.167938294974731178054745536), new FalconFPR(0.985797509167567424700995000),
            new FalconFPR(0.578313796411655563342245019), new FalconFPR(0.815814410806733789010772660),
            new FalconFPR(-0.815814410806733789010772660), new FalconFPR(0.578313796411655563342245019),
            new FalconFPR(0.846490938774052078300544488), new FalconFPR(0.532403127877197971442805218),
            new FalconFPR(-0.532403127877197971442805218), new FalconFPR(0.846490938774052078300544488),
            new FalconFPR(0.222093620973203534094094721), new FalconFPR(0.975025345066994146844913468),
            new FalconFPR(-0.975025345066994146844913468), new FalconFPR(0.222093620973203534094094721),
            new FalconFPR(0.934092550404258914729877883), new FalconFPR(0.357030961233430032614954036),
            new FalconFPR(-0.357030961233430032614954036), new FalconFPR(0.934092550404258914729877883),
            new FalconFPR(0.408044162864978680820747499), new FalconFPR(0.912962190428398164628018233),
            new FalconFPR(-0.912962190428398164628018233), new FalconFPR(0.408044162864978680820747499),
            new FalconFPR(0.726359155084345976817494315), new FalconFPR(0.687315340891759108199186948),
            new FalconFPR(-0.687315340891759108199186948), new FalconFPR(0.726359155084345976817494315),
            new FalconFPR(0.027608145778965741612354872), new FalconFPR(0.999618822495178597116830637),
            new FalconFPR(-0.999618822495178597116830637), new FalconFPR(0.027608145778965741612354872),
            new FalconFPR(0.998941293186856850633930266), new FalconFPR(0.046003182130914628814301788),
            new FalconFPR(-0.046003182130914628814301788), new FalconFPR(0.998941293186856850633930266),
            new FalconFPR(0.673829000378756060917568372), new FalconFPR(0.738887324460615147933116508),
            new FalconFPR(-0.738887324460615147933116508), new FalconFPR(0.673829000378756060917568372),
            new FalconFPR(0.905296759318118774354048329), new FalconFPR(0.424779681209108833357226189),
            new FalconFPR(-0.424779681209108833357226189), new FalconFPR(0.905296759318118774354048329),
            new FalconFPR(0.339776884406826857828825803), new FalconFPR(0.940506070593268323787291309),
            new FalconFPR(-0.940506070593268323787291309), new FalconFPR(0.339776884406826857828825803),
            new FalconFPR(0.970772140728950302138169611), new FalconFPR(0.240003022448741486568922365),
            new FalconFPR(-0.240003022448741486568922365), new FalconFPR(0.970772140728950302138169611),
            new FalconFPR(0.516731799017649881508753876), new FalconFPR(0.856147328375194481019630732),
            new FalconFPR(-0.856147328375194481019630732), new FalconFPR(0.516731799017649881508753876),
            new FalconFPR(0.805031331142963597922659282), new FalconFPR(0.593232295039799808047809426),
            new FalconFPR(-0.593232295039799808047809426), new FalconFPR(0.805031331142963597922659282),
            new FalconFPR(0.149764534677321517229695737), new FalconFPR(0.988721691960323767604516485),
            new FalconFPR(-0.988721691960323767604516485), new FalconFPR(0.149764534677321517229695737),
            new FalconFPR(0.989622017463200834623694454), new FalconFPR(0.143695033150294454819773349),
            new FalconFPR(-0.143695033150294454819773349), new FalconFPR(0.989622017463200834623694454),
            new FalconFPR(0.598160706996342311724958652), new FalconFPR(0.801376171723140219430247777),
            new FalconFPR(-0.801376171723140219430247777), new FalconFPR(0.598160706996342311724958652),
            new FalconFPR(0.859301818357008404783582139), new FalconFPR(0.511468850437970399504391001),
            new FalconFPR(-0.511468850437970399504391001), new FalconFPR(0.859301818357008404783582139),
            new FalconFPR(0.245955050335794611599924709), new FalconFPR(0.969281235356548486048290738),
            new FalconFPR(-0.969281235356548486048290738), new FalconFPR(0.245955050335794611599924709),
            new FalconFPR(0.942573197601446879280758735), new FalconFPR(0.333999651442009404650865481),
            new FalconFPR(-0.333999651442009404650865481), new FalconFPR(0.942573197601446879280758735),
            new FalconFPR(0.430326481340082633908199031), new FalconFPR(0.902673318237258806751502391),
            new FalconFPR(-0.902673318237258806751502391), new FalconFPR(0.430326481340082633908199031),
            new FalconFPR(0.743007952135121693517362293), new FalconFPR(0.669282588346636065720696366),
            new FalconFPR(-0.669282588346636065720696366), new FalconFPR(0.743007952135121693517362293),
            new FalconFPR(0.052131704680283321236358216), new FalconFPR(0.998640218180265222418199049),
            new FalconFPR(-0.998640218180265222418199049), new FalconFPR(0.052131704680283321236358216),
            new FalconFPR(0.995480755491926941769171600), new FalconFPR(0.094963495329638998938034312),
            new FalconFPR(-0.094963495329638998938034312), new FalconFPR(0.995480755491926941769171600),
            new FalconFPR(0.636761861236284230413943435), new FalconFPR(0.771060524261813773200605759),
            new FalconFPR(-0.771060524261813773200605759), new FalconFPR(0.636761861236284230413943435),
            new FalconFPR(0.883363338665731594736308015), new FalconFPR(0.468688822035827933697617870),
            new FalconFPR(-0.468688822035827933697617870), new FalconFPR(0.883363338665731594736308015),
            new FalconFPR(0.293219162694258650606608599), new FalconFPR(0.956045251349996443270479823),
            new FalconFPR(-0.956045251349996443270479823), new FalconFPR(0.293219162694258650606608599),
            new FalconFPR(0.957826413027532890321037029), new FalconFPR(0.287347459544729526477331841),
            new FalconFPR(-0.287347459544729526477331841), new FalconFPR(0.957826413027532890321037029),
            new FalconFPR(0.474100214650550014398580015), new FalconFPR(0.880470889052160770806542929),
            new FalconFPR(-0.880470889052160770806542929), new FalconFPR(0.474100214650550014398580015),
            new FalconFPR(0.774953106594873878359129282), new FalconFPR(0.632018735939809021909403706),
            new FalconFPR(-0.632018735939809021909403706), new FalconFPR(0.774953106594873878359129282),
            new FalconFPR(0.101069862754827824987887585), new FalconFPR(0.994879330794805620591166107),
            new FalconFPR(-0.994879330794805620591166107), new FalconFPR(0.101069862754827824987887585),
            new FalconFPR(0.981379193313754574318224190), new FalconFPR(0.192080397049892441679288205),
            new FalconFPR(-0.192080397049892441679288205), new FalconFPR(0.981379193313754574318224190),
            new FalconFPR(0.558118531220556115693702964), new FalconFPR(0.829761233794523042469023765),
            new FalconFPR(-0.829761233794523042469023765), new FalconFPR(0.558118531220556115693702964),
            new FalconFPR(0.833170164701913186439915922), new FalconFPR(0.553016705580027531764226988),
            new FalconFPR(-0.553016705580027531764226988), new FalconFPR(0.833170164701913186439915922),
            new FalconFPR(0.198098410717953586179324918), new FalconFPR(0.980182135968117392690210009),
            new FalconFPR(-0.980182135968117392690210009), new FalconFPR(0.198098410717953586179324918),
            new FalconFPR(0.925049240782677590302371869), new FalconFPR(0.379847208924051170576281147),
            new FalconFPR(-0.379847208924051170576281147), new FalconFPR(0.925049240782677590302371869),
            new FalconFPR(0.385516053843918864075607949), new FalconFPR(0.922701128333878570437264227),
            new FalconFPR(-0.922701128333878570437264227), new FalconFPR(0.385516053843918864075607949),
            new FalconFPR(0.709272826438865651316533772), new FalconFPR(0.704934080375904908852523758),
            new FalconFPR(-0.704934080375904908852523758), new FalconFPR(0.709272826438865651316533772),
            new FalconFPR(0.003067956762965976270145365), new FalconFPR(0.999995293809576171511580126),
            new FalconFPR(-0.999995293809576171511580126), new FalconFPR(0.003067956762965976270145365)
        };

        p2_tab = new FalconFPR[]{
            new FalconFPR(2.00000000000),
            new FalconFPR(1.00000000000),
            new FalconFPR(0.50000000000),
            new FalconFPR(0.25000000000),
            new FalconFPR(0.12500000000),
            new FalconFPR(0.06250000000),
            new FalconFPR(0.03125000000),
            new FalconFPR(0.01562500000),
            new FalconFPR(0.00781250000),
            new FalconFPR(0.00390625000),
            new FalconFPR(0.00195312500)
        };
    }

    FPREngine()
    {
        this.fpr_q = new FalconFPR(12289.0);
        this.fpr_inverse_of_q = new FalconFPR(1.0 / 12289.0);
        this.fpr_inv_2sqrsigma0 = new FalconFPR(0.150865048875372721532312163019);
        this.fpr_inv_sigma = inv_sigma;
        this.fpr_sigma_min = sigma_min;
        this.fpr_log2 = new FalconFPR(0.69314718055994530941723212146);
        this.fpr_inv_log2 = new FalconFPR(1.4426950408889634073599246810);
        this.fpr_bnorm_max = new FalconFPR(16822.4121);
        this.fpr_zero = new FalconFPR(0.0);
        this.fpr_one = new FalconFPR(1.0);
        this.fpr_two = new FalconFPR(2.0);
        this.fpr_onehalf = new FalconFPR(0.5);
        this.fpr_invsqrt2 = new FalconFPR(0.707106781186547524400844362105);
        this.fpr_invsqrt8 = new FalconFPR(0.353553390593273762200422181052);
        this.fpr_ptwo31 = new FalconFPR(2147483648.0);
        this.fpr_ptwo31m1 = new FalconFPR(2147483647.0);
        this.fpr_mtwo31m1 = new FalconFPR(-2147483647.0);
        this.fpr_ptwo63m1 = new FalconFPR(9223372036854775807.0);
        this.fpr_mtwo63m1 = new FalconFPR(-9223372036854775807.0);
        this.fpr_ptwo63 = new FalconFPR(9223372036854775808.0);
        this.fpr_gm_tab = gm_tab;
        this.fpr_p2_tab = p2_tab;
    }

    FalconFPR FPR(double v)
    {
        FalconFPR x = new FalconFPR(v);
        return x;
    }

    FalconFPR fpr_of(long i)
    {
        return FPR((double)i);
    }

    final FalconFPR fpr_q;
    final FalconFPR fpr_inverse_of_q;
    final FalconFPR fpr_inv_2sqrsigma0;
    final FalconFPR[] fpr_inv_sigma;
    final FalconFPR[] fpr_sigma_min;
    final FalconFPR fpr_log2;
    final FalconFPR fpr_inv_log2;
    final FalconFPR fpr_bnorm_max;
    final FalconFPR fpr_zero;
    final FalconFPR fpr_one;
    final FalconFPR fpr_two;
    final FalconFPR fpr_onehalf;
    final FalconFPR fpr_invsqrt2;
    final FalconFPR fpr_invsqrt8;
    final FalconFPR fpr_ptwo31;
    final FalconFPR fpr_ptwo31m1;
    final FalconFPR fpr_mtwo31m1;
    final FalconFPR fpr_ptwo63m1;
    final FalconFPR fpr_mtwo63m1;
    final FalconFPR fpr_ptwo63;
    final FalconFPR[] fpr_gm_tab;
    final FalconFPR[] fpr_p2_tab;

    long
    fpr_rint(FalconFPR x)
    {
        /*
         * We do not want to use llrint() since it might be not
         * constant-time.
         *
         * Suppose that x >= 0. If x >= 2^52, then it is already an
         * integer. Otherwise, if x < 2^52, then computing x+2^52 will
         * yield a value that will be rounded to the nearest integer
         * with exactly the right rules (round-to-nearest-even).
         *
         * In order to have constant-time processing, we must do the
         * computation for both x >= 0 and x < 0 cases, and use a
         * cast to an integer to access the sign and select the proper
         * value. Such casts also allow us to find out if |x| < 2^52.
         */
        long sx, tx, rp, rn, m;
        int ub;

        sx = (long)(x.v - 1.0);
        tx = (long)x.v;
        rp = (long)(x.v + 4503599627370496.0) - 4503599627370496l;
        rn = (long)(x.v - 4503599627370496.0) + 4503599627370496l;

        /*
         * If tx >= 2^52 or tx < -2^52, then result is tx.
         * Otherwise, if sx >= 0, then result is rp.
         * Otherwise, result is rn. We use the fact that when x is
         * close to 0 (|x| <= 0.25) then both rp and rn are correct;
         * and if x is not close to 0, then trunc(x-1.0) yields the
         * appropriate sign.
         */

        /*
         * Clamp rp to zero if tx < 0.
         * Clamp rn to zero if tx >= 0.
         */
        m = sx >> 63;
        rn &= m;
        rp &= ~m;

        /*
         * Get the 12 upper bits of tx; if they are not all zeros or
         * all ones, then tx >= 2^52 or tx < -2^52, and we clamp both
         * rp and rn to zero. Otherwise, we clamp tx to zero.
         */
        ub = (int)(tx >>> 52);
        m = -(long)((((ub + 1) & 0xFFF) - 2) >>> 31);
        rp &= m;
        rn &= m;
        tx &= ~m;

        /*
         * Only one of tx, rn or rp (at most) can be non-zero at this
         * point.
         */
        return tx | rn | rp;
    }

    long fpr_floor(FalconFPR x)
    {
        long r;

        /*
         * The cast performs a trunc() (rounding toward 0) and thus is
         * wrong by 1 for most negative values. The correction below is
         * constant-time as long as the compiler turns the
         * floating-point conversion result into a 0/1 integer without a
         * conditional branch or another non-constant-time construction.
         * This should hold on all modern architectures with an FPU (and
         * if it is false on a given arch, then chances are that the FPU
         * itself is not constant-time, making the point moot).
         */
        r = (long)x.v;
        return r - (x.v < (double)r ? 1 : 0);
    }

    long
    fpr_trunc(FalconFPR x)
    {
        return (long)x.v;
    }

    FalconFPR
    fpr_add(FalconFPR x, FalconFPR y)
    {
        return FPR(x.v + y.v);
    }

    FalconFPR
    fpr_sub(FalconFPR x, FalconFPR y)
    {
        return FPR(x.v - y.v);
    }

    FalconFPR
    fpr_neg(FalconFPR x)
    {
        return FPR(-x.v);
    }

    FalconFPR
    fpr_half(FalconFPR x)
    {
        return FPR(x.v * 0.5);
    }

    FalconFPR
    fpr_double(FalconFPR x)
    {
        return FPR(x.v + x.v);
    }

    FalconFPR
    fpr_mul(FalconFPR x, FalconFPR y)
    {
        return FPR(x.v * y.v);
    }

    FalconFPR
    fpr_sqr(FalconFPR x)
    {
        return FPR(x.v * x.v);
    }

    FalconFPR
    fpr_inv(FalconFPR x)
    {
        return FPR(1.0 / x.v);
    }

    FalconFPR
    fpr_div(FalconFPR x, FalconFPR y)
    {
        return FPR(x.v / y.v);
    }


    FalconFPR
    fpr_sqrt(FalconFPR x)
    {
        return FPR(Math.sqrt(x.v));
    }

    boolean
    fpr_lt(FalconFPR x, FalconFPR y)
    {
        return x.v < y.v;
    }

    long
    fpr_expm_p63(FalconFPR x, FalconFPR ccs)
    {
        /*
         * Polynomial approximation of exp(-x) is taken from FACCT:
         *   https://eprint.iacr.org/2018/1234
         * Specifically, values are extracted from the implementation
         * referenced from the FACCT article, and available at:
         *   https://github.com/raykzhao/gaussian
         * Tests over more than 24 billions of random inputs in the
         * 0..log(2) range have never shown a deviation larger than
         * 2^(-50) from the true mathematical value.
         */


        /*
         * Normal implementation uses Horner's method, which minimizes
         * the number of operations.
         */

        double d, y;

        d = x.v;
        y = 0.000000002073772366009083061987;
        y = 0.000000025299506379442070029551 - y * d;
        y = 0.000000275607356160477811864927 - y * d;
        y = 0.000002755586350219122514855659 - y * d;
        y = 0.000024801566833585381209939524 - y * d;
        y = 0.000198412739277311890541063977 - y * d;
        y = 0.001388888894063186997887560103 - y * d;
        y = 0.008333333327800835146903501993 - y * d;
        y = 0.041666666666110491190622155955 - y * d;
        y = 0.166666666666984014666397229121 - y * d;
        y = 0.500000000000019206858326015208 - y * d;
        y = 0.999999999999994892974086724280 - y * d;
        y = 1.000000000000000000000000000000 - y * d;
        y *= ccs.v;
        return (long)(y * fpr_ptwo63.v);
    }
}
