/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.cms;

import io.gatling.recorder.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import io.gatling.recorder.internal.bouncycastle.asn1.ASN1OctetString;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.CompressedData;
import io.gatling.recorder.internal.bouncycastle.asn1.cms.ContentInfo;
import io.gatling.recorder.internal.bouncycastle.cms.CMSException;
import io.gatling.recorder.internal.bouncycastle.cms.CMSTypedStream;
import io.gatling.recorder.internal.bouncycastle.cms.CMSUtils;
import io.gatling.recorder.internal.bouncycastle.operator.InputExpander;
import io.gatling.recorder.internal.bouncycastle.operator.InputExpanderProvider;
import io.gatling.recorder.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.InputStream;

public class CMSCompressedData
implements Encodable {
    ContentInfo contentInfo;
    CompressedData comData;

    public CMSCompressedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSCompressedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSCompressedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            this.comData = CompressedData.getInstance(contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentInfo.getContentType();
    }

    public ASN1ObjectIdentifier getCompressedContentType() {
        return this.comData.getEncapContentInfo().getContentType();
    }

    public CMSTypedStream getContentStream(InputExpanderProvider inputExpanderProvider) {
        ContentInfo contentInfo = this.comData.getEncapContentInfo();
        ASN1OctetString aSN1OctetString = (ASN1OctetString)contentInfo.getContent();
        InputExpander inputExpander = inputExpanderProvider.get(this.comData.getCompressionAlgorithmIdentifier());
        InputStream inputStream = inputExpander.getInputStream(aSN1OctetString.getOctetStream());
        return new CMSTypedStream(contentInfo.getContentType(), inputStream);
    }

    public byte[] getContent(InputExpanderProvider inputExpanderProvider) throws CMSException {
        ContentInfo contentInfo = this.comData.getEncapContentInfo();
        ASN1OctetString aSN1OctetString = (ASN1OctetString)contentInfo.getContent();
        InputExpander inputExpander = inputExpanderProvider.get(this.comData.getCompressionAlgorithmIdentifier());
        InputStream inputStream = inputExpander.getInputStream(aSN1OctetString.getOctetStream());
        try {
            return CMSUtils.streamToByteArray(inputStream);
        }
        catch (IOException iOException) {
            throw new CMSException("exception reading compressed stream.", iOException);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

