/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber;

import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.gatling.recorder.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import io.gatling.recorder.internal.bouncycastle.crypto.KeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import io.gatling.recorder.internal.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import java.security.SecureRandom;

public class KyberKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private KyberParameters kyberParams;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.kyberParams = ((KyberKeyGenerationParameters)keyGenerationParameters).getParameters();
        this.random = keyGenerationParameters.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        KyberEngine kyberEngine = this.kyberParams.getEngine();
        kyberEngine.init(this.random);
        byte[][] byArray = kyberEngine.generateKemKeyPair();
        KyberPublicKeyParameters kyberPublicKeyParameters = new KyberPublicKeyParameters(this.kyberParams, byArray[0], byArray[1]);
        KyberPrivateKeyParameters kyberPrivateKeyParameters = new KyberPrivateKeyParameters(this.kyberParams, byArray[2], byArray[3], byArray[4], byArray[0], byArray[1]);
        return new AsymmetricCipherKeyPair(kyberPublicKeyParameters, kyberPrivateKeyParameters);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

