/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import io.getunleash.FeatureToggle;
import io.getunleash.UnleashException;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.UnleashReady;
import io.getunleash.lang.Nullable;
import io.getunleash.repository.FeatureToggleResponse;
import io.getunleash.repository.ToggleBackupHandler;
import io.getunleash.repository.ToggleBootstrapHandler;
import io.getunleash.repository.ToggleCollection;
import io.getunleash.repository.ToggleFetcher;
import io.getunleash.repository.ToggleRepository;
import io.getunleash.util.UnleashConfig;
import io.getunleash.util.UnleashScheduledExecutor;
import java.util.List;
import java.util.stream.Collectors;

public final class FeatureToggleRepository
implements ToggleRepository {
    private final ToggleBackupHandler toggleBackupHandler;
    private final ToggleBootstrapHandler toggleBootstrapHandler;
    private final ToggleFetcher toggleFetcher;
    private final EventDispatcher eventDispatcher;
    private ToggleCollection toggleCollection;
    private boolean ready;

    public FeatureToggleRepository(UnleashConfig unleashConfig, ToggleFetcher toggleFetcher, ToggleBackupHandler toggleBackupHandler) {
        this(unleashConfig, unleashConfig.getScheduledExecutor(), toggleFetcher, toggleBackupHandler);
    }

    public FeatureToggleRepository(UnleashConfig unleashConfig, UnleashScheduledExecutor executor, ToggleFetcher toggleFetcher, ToggleBackupHandler toggleBackupHandler) {
        this.toggleBackupHandler = toggleBackupHandler;
        this.toggleFetcher = toggleFetcher;
        this.eventDispatcher = new EventDispatcher(unleashConfig);
        this.toggleBootstrapHandler = new ToggleBootstrapHandler(unleashConfig);
        this.toggleCollection = toggleBackupHandler.read();
        if (this.toggleCollection.getFeatures().isEmpty()) {
            this.toggleCollection = this.toggleBootstrapHandler.read();
        }
        if (unleashConfig.isSynchronousFetchOnInitialisation()) {
            this.updateToggles().run();
        }
        executor.setInterval(this.updateToggles(), 0L, unleashConfig.getFetchTogglesInterval());
    }

    private Runnable updateToggles() {
        return () -> {
            try {
                FeatureToggleResponse response = this.toggleFetcher.fetchToggles();
                this.eventDispatcher.dispatch(response);
                if (response.getStatus() == FeatureToggleResponse.Status.CHANGED) {
                    this.toggleCollection = response.getToggleCollection();
                    this.toggleBackupHandler.write(response.getToggleCollection());
                }
                if (!this.ready) {
                    this.eventDispatcher.dispatch(new UnleashReady());
                    this.ready = true;
                }
            }
            catch (UnleashException e) {
                this.eventDispatcher.dispatch(e);
            }
        };
    }

    @Override
    @Nullable
    public FeatureToggle getToggle(String name) {
        return this.toggleCollection.getToggle(name);
    }

    @Override
    public List<String> getFeatureNames() {
        return this.toggleCollection.getFeatures().stream().map(toggle -> toggle.getName()).collect(Collectors.toList());
    }
}

