/*
 * Decompiled with CFR 0.152.
 */
package io.github.ashwith.flutter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.remote.RemoteWebElement;

public class FlutterElement
extends RemoteWebElement {
    private final Map<String, Object> rawMap;
    private final Gson gson = new Gson();

    protected FlutterElement(Map<String, Object> rawMap) {
        this.rawMap = rawMap;
        this.id = this.serialize(rawMap);
    }

    protected Map<String, Object> getRawMap() {
        return this.rawMap;
    }

    private String serialize(Map<String, Object> rawMap) {
        JsonPrimitive localInstance = new JsonPrimitive(String.valueOf(false));
        HashMap tempMap = new HashMap();
        rawMap.forEach((key, value) -> {
            if (value instanceof String || value instanceof Integer || value instanceof Boolean) {
                tempMap.put(key, new JsonPrimitive(String.valueOf(value)));
            } else if (value instanceof JsonElement) {
                tempMap.put(key, value);
            } else if (value instanceof Map) {
                tempMap.put(key, this.gson.toJson(value));
            } else {
                tempMap.put(key, localInstance);
            }
        });
        String mapJsonStringify = this.gson.toJson(tempMap);
        return Base64.getEncoder().encodeToString(mapJsonStringify.getBytes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlutterElement that = (FlutterElement)((Object)o);
        return Objects.equals(this.rawMap, that.rawMap) && Objects.equals(this.gson, that.gson);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rawMap, this.gson);
    }
}

