/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.bit;

import io.github.binaryfoo.bit.EmvBit;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\n\"\u00020\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u001e\u0010\r\u001a\u00020\u000e*\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0004*\u00020\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0018\u0010\u0012\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0006\u001a\u0018\u0010\u0014\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000e\u00a8\u0006\u0016"}, d2={"fromHex", "", "Lio/github/binaryfoo/bit/EmvBit;", "hex", "", "firstByteNumber", "", "labelFor", "setOf", "bits", "", "([Lio/github/binaryfoo/bit/EmvBit;)Ljava/util/Set;", "getByteCount", "matches", "", "other", "reduceToOnBits", "toConfigString", "toHexString", "fieldLengthInBytes", "toString", "includeValue", "emv-bertlv"})
@JvmName(name="BitPackage")
public final class BitPackage {
    @NotNull
    public static final Set<EmvBit> fromHex(@NotNull String hex) {
        Intrinsics.checkParameterIsNotNull((Object)hex, (String)"hex");
        return BitPackage.fromHex(hex, 1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<EmvBit> fromHex(@NotNull String hex, int firstByteNumber) {
        Intrinsics.checkParameterIsNotNull((Object)hex, (String)"hex");
        TreeSet<EmvBit> set = new TreeSet<EmvBit>();
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)new IntRange(0, hex.length() - 1)), (int)2);
        int n = intProgression.getFirst();
        int n2 = intProgression.getLast();
        int n3 = intProgression.getStep();
        int n4 = n;
        int n5 = n2;
        if (n3 > 0 ? n4 <= n5 : n4 >= n5) {
            while (true) {
                int endIndex$iv;
                void $receiver$iv;
                void i;
                String string = hex;
                void var8_9 = i + 2;
                void v3 = $receiver$iv;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)v3).substring((int)i, endIndex$iv);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                int b = Integer.parseInt(string2, 16);
                void byteNumber = i / 2 + firstByteNumber;
                IntProgression intProgression2 = RangesKt.downTo((int)7, (int)0);
                endIndex$iv = intProgression2.getFirst();
                int n6 = intProgression2.getLast();
                int n7 = intProgression2.getStep();
                int n8 = endIndex$iv;
                int n9 = n6;
                if (n7 > 0 ? n8 <= n9 : n8 >= n9) {
                    while (true) {
                        void j;
                        set.add(new EmvBit((int)byteNumber, (int)(j + true), (b >> j & 1) == 1));
                        if (j == n6) break;
                        j += n7;
                    }
                }
                if (i == n2) break;
                n = i + n3;
            }
        }
        return set;
    }

    @NotNull
    public static final String toHexString(Set<EmvBit> $receiver, int fieldLengthInBytes) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        byte[] bytes = new byte[fieldLengthInBytes];
        for (EmvBit bit : $receiver) {
            if (!bit.getSet()) continue;
            int byteIndex = bit.getByteNumber() - 1;
            byte b = bytes[byteIndex];
            bytes[byteIndex] = b = (byte)(b | 1 << bit.getBitNumber() - 1);
        }
        String string = ISOUtil.hexString(bytes);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(bytes)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<EmvBit> reduceToOnBits(Set<EmvBit> $receiver) {
        void var3_5;
        void $receiver$iv$iv;
        void $receiver$iv;
        TreeSet treeSet;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable iterable = $receiver;
        TreeSet treeSet2 = treeSet;
        TreeSet treeSet3 = treeSet;
        void var2_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            EmvBit it = (EmvBit)element$iv$iv;
            if (!it.getSet()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)var3_5;
        treeSet2(list);
        return treeSet3;
    }

    @NotNull
    public static final Set<EmvBit> setOf(EmvBit ... bits) {
        Intrinsics.checkParameterIsNotNull((Object)bits, (String)"bits");
        return SetsKt.sortedSetOf((Object[])Arrays.copyOf(bits, bits.length));
    }

    @NotNull
    public static final String toConfigString(Set<EmvBit> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        StringBuilder b = new StringBuilder();
        for (EmvBit bit : $receiver) {
            if (b.length() > 0) {
                b.append(" & ");
            }
            b.append(BitPackage.toConfigString(bit));
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    public static final String toConfigString(EmvBit $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "(" + $receiver.getByteNumber() + "," + $receiver.getBitNumber() + ")=" + $receiver.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public static final int getByteCount(Set<EmvBit> $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Iterable $receiver$iv = $receiver;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            EmvBit emvBit = (EmvBit)item$iv$iv;
            Collection collection = destination$iv$iv;
            Integer n = it.getByteNumber();
            collection.add(n);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw (Throwable)new UnsupportedOperationException("Empty iterable can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            int n = ((Number)iterator$iv.next()).intValue();
            int a = ((Number)accumulator$iv).intValue();
            accumulator$iv = a >= b ? a : b;
        }
        return ((Number)var3_3).intValue();
    }

    public static final boolean matches(Set<EmvBit> $receiver, @NotNull Set<EmvBit> other) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(other, (String)"other");
        return CollectionsKt.intersect((Iterable)$receiver, (Iterable)other).size() == $receiver.size();
    }

    @NotNull
    public static final String toString(Set<EmvBit> $receiver, boolean includeValue) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        StringBuilder b = new StringBuilder();
        for (EmvBit bit : $receiver) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(bit.toString(false, includeValue));
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    @NotNull
    public static final String labelFor(@NotNull String hex) {
        Intrinsics.checkParameterIsNotNull((Object)hex, (String)"hex");
        return BitPackage.toString(BitPackage.fromHex(hex), false);
    }
}

