/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.crypto;

import io.github.binaryfoo.crypto.PublicKeyCertificate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/github/binaryfoo/crypto/CaPublicKey;", "Lio/github/binaryfoo/crypto/PublicKeyCertificate;", "rid", "", "index", "exponent", "modulus", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getExponent", "()Ljava/lang/String;", "getIndex", "getModulus", "name", "getName", "getRid", "component1", "component2", "component3", "component4", "copy", "emv-bertlv"})
public final class CaPublicKey
implements PublicKeyCertificate {
    @NotNull
    private final String name;
    @NotNull
    private final String rid;
    @NotNull
    private final String index;
    @NotNull
    private final String exponent;
    @NotNull
    private final String modulus;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final String getRid() {
        return this.rid;
    }

    @NotNull
    public final String getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public String getExponent() {
        return this.exponent;
    }

    @Override
    @NotNull
    public String getModulus() {
        return this.modulus;
    }

    public CaPublicKey(@NotNull String rid, @NotNull String index, @NotNull String exponent, @NotNull String modulus) {
        Intrinsics.checkParameterIsNotNull((Object)rid, (String)"rid");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)exponent, (String)"exponent");
        Intrinsics.checkParameterIsNotNull((Object)modulus, (String)"modulus");
        this.rid = rid;
        this.index = index;
        this.exponent = exponent;
        this.modulus = modulus;
        this.name = "CA public key (" + this.rid + "," + this.index + ")";
    }

    @Override
    public int getModulusLength() {
        return PublicKeyCertificate.DefaultImpls.getModulusLength(this);
    }

    @NotNull
    public final String component1() {
        return this.rid;
    }

    @NotNull
    public final String component2() {
        return this.index;
    }

    @NotNull
    public final String component3() {
        return this.getExponent();
    }

    @NotNull
    public final String component4() {
        return this.getModulus();
    }

    @NotNull
    public final CaPublicKey copy(@NotNull String rid, @NotNull String index, @NotNull String exponent, @NotNull String modulus) {
        Intrinsics.checkParameterIsNotNull((Object)rid, (String)"rid");
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        Intrinsics.checkParameterIsNotNull((Object)exponent, (String)"exponent");
        Intrinsics.checkParameterIsNotNull((Object)modulus, (String)"modulus");
        return new CaPublicKey(rid, index, exponent, modulus);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ CaPublicKey copy$default(CaPublicKey caPublicKey, String string, String string2, String string3, String string4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            string = caPublicKey.rid;
        }
        if ((n & 2) != 0) {
            string2 = caPublicKey.index;
        }
        if ((n & 4) != 0) {
            string3 = caPublicKey.getExponent();
        }
        if ((n & 8) != 0) {
            string4 = caPublicKey.getModulus();
        }
        return caPublicKey.copy(string, string2, string3, string4);
    }

    public String toString() {
        return "CaPublicKey(rid=" + this.rid + ", index=" + this.index + ", exponent=" + this.getExponent() + ", modulus=" + this.getModulus() + ")";
    }

    public int hashCode() {
        String string = this.rid;
        String string2 = this.index;
        String string3 = this.getExponent();
        String string4 = this.getModulus();
        return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CaPublicKey)) break block3;
                CaPublicKey caPublicKey = (CaPublicKey)object;
                if (!Intrinsics.areEqual((Object)this.rid, (Object)caPublicKey.rid) || !Intrinsics.areEqual((Object)this.index, (Object)caPublicKey.index) || !Intrinsics.areEqual((Object)this.getExponent(), (Object)caPublicKey.getExponent()) || !Intrinsics.areEqual((Object)this.getModulus(), (Object)caPublicKey.getModulus())) break block3;
            }
            return true;
        }
        return false;
    }
}

