/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.crypto;

import io.github.binaryfoo.tlv.ISOUtil;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u00a8\u0006\f"}, d2={"Lio/github/binaryfoo/crypto/SignedDataRecoverer;", "", "()V", "recover", "", "signed", "exponent", "modulus", "", "verify", "", "recovered", "emv-bertlv"})
public final class SignedDataRecoverer {
    @NotNull
    public final byte[] recover(@NotNull String signed, @NotNull String exponent, @NotNull String modulus) {
        Intrinsics.checkParameterIsNotNull((Object)signed, (String)"signed");
        Intrinsics.checkParameterIsNotNull((Object)exponent, (String)"exponent");
        Intrinsics.checkParameterIsNotNull((Object)modulus, (String)"modulus");
        byte[] byArray = ISOUtil.hex2byte(signed);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ISOUtil.hex2byte(signed)");
        byte[] byArray2 = ISOUtil.hex2byte(exponent);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"ISOUtil.hex2byte(exponent)");
        byte[] byArray3 = ISOUtil.hex2byte(modulus);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"ISOUtil.hex2byte(modulus)");
        return this.recover(byArray, byArray2, byArray3);
    }

    @NotNull
    public final byte[] recover(@NotNull byte[] signed, @NotNull byte[] exponent, @NotNull byte[] modulus) {
        Intrinsics.checkParameterIsNotNull((Object)signed, (String)"signed");
        Intrinsics.checkParameterIsNotNull((Object)exponent, (String)"exponent");
        Intrinsics.checkParameterIsNotNull((Object)modulus, (String)"modulus");
        BigInteger biSigned = new BigInteger(1, signed);
        BigInteger biExponent = new BigInteger(exponent);
        BigInteger bigModulus = new BigInteger(1, modulus);
        byte[] recovered = biSigned.modPow(biExponent, bigModulus).toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)recovered, (String)"recovered");
        this.verify(recovered);
        Intrinsics.checkExpressionValueIsNotNull((Object)recovered, (String)"recovered");
        return recovered;
    }

    private final void verify(byte[] recovered) {
        byte header = recovered[0];
        if (header != 106) {
            throw (Throwable)new IllegalStateException("Recover failed: bad header byte " + Integer.toHexString(header));
        }
        int footer = recovered[ArraysKt.getLastIndex((byte[])recovered)] & 0xFF;
        if (footer != 188) {
            throw (Throwable)new IllegalStateException("Recover failed: bad footer byte " + Integer.toHexString(footer));
        }
    }
}

