/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.tlv.Tag;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lio/github/binaryfoo/decoders/DOLParser;", "", "()V", "parse", "", "Lio/github/binaryfoo/decoders/DOLParser$DOLElement;", "dol", "", "DOLElement", "emv-bertlv"})
public final class DOLParser {
    @NotNull
    public final List<DOLElement> parse(@NotNull byte[] dol) {
        Intrinsics.checkParameterIsNotNull((Object)dol, (String)"dol");
        ArrayList<DOLElement> elements = new ArrayList<DOLElement>();
        ByteBuffer buffer = ByteBuffer.wrap(dol);
        while (buffer.hasRemaining()) {
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            Tag tag = Tag.Companion.parse(byteBuffer);
            byte length = buffer.get();
            elements.add(new DOLElement(tag, length));
        }
        return elements;
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lio/github/binaryfoo/decoders/DOLParser$DOLElement;", "", "tag", "Lio/github/binaryfoo/tlv/Tag;", "length", "", "(Lio/github/binaryfoo/tlv/Tag;I)V", "getLength", "()I", "getTag", "()Lio/github/binaryfoo/tlv/Tag;", "component1", "component2", "copy", "emv-bertlv"})
    public static final class DOLElement {
        @NotNull
        private final Tag tag;
        private final int length;

        @NotNull
        public final Tag getTag() {
            return this.tag;
        }

        public final int getLength() {
            return this.length;
        }

        public DOLElement(@NotNull Tag tag, int length) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            this.tag = tag;
            this.length = length;
        }

        @NotNull
        public final Tag component1() {
            return this.tag;
        }

        public final int component2() {
            return this.length;
        }

        @NotNull
        public final DOLElement copy(@NotNull Tag tag, int length) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            return new DOLElement(tag, length);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ DOLElement copy$default(DOLElement dOLElement, Tag tag, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n2 & 1) != 0) {
                tag = dOLElement.tag;
            }
            if ((n2 & 2) != 0) {
                n = dOLElement.length;
            }
            return dOLElement.copy(tag, n);
        }

        public String toString() {
            return "DOLElement(tag=" + this.tag + ", length=" + this.length + ")";
        }

        public int hashCode() {
            Tag tag = this.tag;
            return (tag != null ? ((Object)tag).hashCode() : 0) * 31 + this.length;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DOLElement)) break block3;
                    DOLElement dOLElement = (DOLElement)object;
                    if (!Intrinsics.areEqual((Object)this.tag, (Object)dOLElement.tag) || !(this.length == dOLElement.length)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

