/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.Decoder;
import io.github.binaryfoo.TagMetaData;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.tlv.ISOUtil;
import io.github.binaryfoo.tlv.Tag;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lio/github/binaryfoo/decoders/DataObjectListDecoder;", "Lio/github/binaryfoo/Decoder;", "()V", "decode", "", "Lio/github/binaryfoo/DecodedData;", "input", "", "startIndexInBytes", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "getMaxLength", "validate", "emv-bertlv"})
public final class DataObjectListDecoder
implements Decoder {
    @Override
    @NotNull
    public List<DecodedData> decode(@NotNull String input, int startIndexInBytes, @NotNull DecodeSession session) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        ArrayList<DecodedData> children = new ArrayList<DecodedData>();
        ByteBuffer buffer = ByteBuffer.wrap(ISOUtil.hex2byte(input));
        int offset = startIndexInBytes;
        while (buffer.hasRemaining()) {
            ByteBuffer byteBuffer = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
            Tag tag = Tag.Companion.parse(byteBuffer);
            byte b = buffer.get();
            int newOffset = offset + tag.getBytes().size() + 1;
            StringBuilder stringBuilder = new StringBuilder();
            TagMetaData tagMetaData = session.getTagMetaData();
            if (tagMetaData == null) {
                Intrinsics.throwNpe();
            }
            children.add(DecodedData.Companion.primitive("", stringBuilder.append(tag.toString(tagMetaData)).append(" ").append(b).append(" bytes").toString(), offset, newOffset));
            offset = newOffset;
        }
        return children;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String validate(@Nullable String input) {
        if (input != null) {
            void $receiver$iv;
            CharSequence charSequence = input;
            Regex regex$iv = new Regex("^[0-9A-Za-z]$");
            if (regex$iv.matches((CharSequence)$receiver$iv)) {
                return "Only A-Z and 0-9 are valid";
            }
        }
        return null;
    }

    @Override
    public int getMaxLength() {
        return Integer.MAX_VALUE;
    }
}

