/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.crypto.RecoveredPublicKeyCertificate;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"decodeICCPublicKeyCertificate", "Lio/github/binaryfoo/crypto/RecoveredPublicKeyCertificate;", "recovered", "", "byteLengthOfIssuerModulus", "", "startIndexInBytes", "emv-bertlv"})
public final class ICCPublicKeyDecoderKt {
    @NotNull
    public static final RecoveredPublicKeyCertificate decodeICCPublicKeyCertificate(@NotNull byte[] recovered, int byteLengthOfIssuerModulus, int startIndexInBytes) {
        Intrinsics.checkParameterIsNotNull((Object)recovered, (String)"recovered");
        int publicKeyLength = Integer.parseInt(ISOUtil.hexString(recovered, 19, 1), 16);
        String exponentLength = ISOUtil.hexString(recovered, 20, 1);
        int lengthOfLeftKeyPart = publicKeyLength > byteLengthOfIssuerModulus - 42 ? byteLengthOfIssuerModulus - 42 : publicKeyLength;
        String leftKeyPart = ISOUtil.hexString(recovered, 21, lengthOfLeftKeyPart);
        Object[] objectArray = new DecodedData[12];
        objectArray[0] = DecodedData.Companion.byteRange("Header", recovered, 0, 1, startIndexInBytes);
        objectArray[1] = DecodedData.Companion.byteRange("Format", recovered, 1, 1, startIndexInBytes);
        objectArray[2] = DecodedData.Companion.byteRange("PAN", recovered, 2, 10, startIndexInBytes);
        objectArray[3] = DecodedData.Companion.byteRange("Expiry Date (MMYY)", recovered, 12, 2, startIndexInBytes);
        objectArray[4] = DecodedData.Companion.byteRange("Serial number", recovered, 14, 3, startIndexInBytes);
        objectArray[5] = DecodedData.Companion.byteRange("Hash algorithm", recovered, 17, 1, startIndexInBytes);
        objectArray[6] = DecodedData.Companion.byteRange("Public key algorithm", recovered, 18, 1, startIndexInBytes);
        objectArray[7] = DecodedData.Companion.byteRange("Public key length", String.valueOf(publicKeyLength), 19, 1, startIndexInBytes);
        String string = exponentLength;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"exponentLength");
        objectArray[8] = DecodedData.Companion.byteRange("Public key exponent length", string, 20, 1, startIndexInBytes);
        String string2 = leftKeyPart;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"leftKeyPart");
        objectArray[9] = DecodedData.Companion.byteRange("Public key", string2, 21, lengthOfLeftKeyPart, startIndexInBytes);
        objectArray[10] = DecodedData.Companion.byteRange("Hash", recovered, 21 + byteLengthOfIssuerModulus - 42, 20, startIndexInBytes);
        objectArray[11] = DecodedData.Companion.byteRange("Trailer", recovered, 21 + byteLengthOfIssuerModulus - 42 + 20, 1, startIndexInBytes);
        List children = CollectionsKt.listOf((Object[])objectArray);
        String string3 = exponentLength;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"exponentLength");
        String string4 = leftKeyPart;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"leftKeyPart");
        return new RecoveredPublicKeyCertificate("ICC", children, string3, string4, null, 16, null);
    }
}

