/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.crypto.RecoveredPublicKeyCertificate;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"decodeIssuerPublicKey", "Lio/github/binaryfoo/crypto/RecoveredPublicKeyCertificate;", "recovered", "", "byteLengthOfCAModulus", "", "startIndexInBytes", "emv-bertlv"})
public final class IssuerPublicKeyDecoderKt {
    @NotNull
    public static final RecoveredPublicKeyCertificate decodeIssuerPublicKey(@NotNull byte[] recovered, int byteLengthOfCAModulus, int startIndexInBytes) {
        Intrinsics.checkParameterIsNotNull((Object)recovered, (String)"recovered");
        int publicKeyLength = Integer.parseInt(ISOUtil.hexString(recovered, 13, 1), 16);
        String exponentLength = ISOUtil.hexString(recovered, 14, 1);
        int lengthOfLeftKeyPart = publicKeyLength > byteLengthOfCAModulus - 36 ? byteLengthOfCAModulus - 36 : publicKeyLength;
        String leftKeyPart = ISOUtil.hexString(recovered, 15, lengthOfLeftKeyPart);
        Object[] objectArray = new DecodedData[12];
        objectArray[0] = DecodedData.Companion.byteRange("Header", recovered, 0, 1, startIndexInBytes);
        objectArray[1] = DecodedData.Companion.byteRange("Format", recovered, 1, 1, startIndexInBytes);
        objectArray[2] = DecodedData.Companion.byteRange("Identifier (PAN prefix)", recovered, 2, 4, startIndexInBytes);
        objectArray[3] = DecodedData.Companion.byteRange("Expiry Date (MMYY)", recovered, 6, 2, startIndexInBytes);
        objectArray[4] = DecodedData.Companion.byteRange("Serial number", recovered, 8, 3, startIndexInBytes);
        objectArray[5] = DecodedData.Companion.byteRange("Hash algorithm", recovered, 11, 1, startIndexInBytes);
        objectArray[6] = DecodedData.Companion.byteRange("Public key algorithm", recovered, 12, 1, startIndexInBytes);
        objectArray[7] = DecodedData.Companion.byteRange("Public key length", String.valueOf(publicKeyLength), 13, 1, startIndexInBytes);
        String string = exponentLength;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"exponentLength");
        objectArray[8] = DecodedData.Companion.byteRange("Public key exponent length", string, 14, 1, startIndexInBytes);
        String string2 = leftKeyPart;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"leftKeyPart");
        objectArray[9] = DecodedData.Companion.byteRange("Public key", string2, 15, lengthOfLeftKeyPart, startIndexInBytes);
        objectArray[10] = DecodedData.Companion.byteRange("Hash", recovered, 15 + byteLengthOfCAModulus - 36, 20, startIndexInBytes);
        objectArray[11] = DecodedData.Companion.byteRange("Trailer", recovered, 15 + byteLengthOfCAModulus - 36 + 20, 1, startIndexInBytes);
        List b = CollectionsKt.listOf((Object[])objectArray);
        String string3 = exponentLength;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"exponentLength");
        String string4 = leftKeyPart;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"leftKeyPart");
        return new RecoveredPublicKeyCertificate("Issuer", b, string3, string4, null, 16, null);
    }
}

