/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.annotator;

import io.github.binaryfoo.DecodedData;
import io.github.binaryfoo.crypto.PublicKeyCertificate;
import io.github.binaryfoo.crypto.RecoveredPublicKeyCertificate;
import io.github.binaryfoo.crypto.SignedDataRecoverer;
import io.github.binaryfoo.decoders.DecodeSession;
import io.github.binaryfoo.hex.HexDumpElement;
import io.github.binaryfoo.tlv.BerTlv;
import io.github.binaryfoo.tlv.ISOUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001:\u0001 J\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J@\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0011H\u0016J@\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00132\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0011H\u0002J@\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00142\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u001aH\u0016J@\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00132\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u001aH\u0016J \u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0013H\u0002\u00a8\u0006!"}, d2={"Lio/github/binaryfoo/decoders/annotator/SignedDataDecoder;", "", "decodeSignedData", "", "session", "Lio/github/binaryfoo/decoders/DecodeSession;", "decoded", "", "Lio/github/binaryfoo/DecodedData;", "recoverCertificate", "Lio/github/binaryfoo/decoders/annotator/SignedDataDecoder$RecoveryResult;", "encryptedCertificate", "Lio/github/binaryfoo/tlv/BerTlv;", "decodedCertificate", "certificateOfSigner", "Lio/github/binaryfoo/crypto/PublicKeyCertificate;", "decode", "Lkotlin/Function3;", "", "", "Lio/github/binaryfoo/crypto/RecoveredPublicKeyCertificate;", "signedData", "", "startIndexInBytes", "recoverSignedData", "decodedSignedData", "Lkotlin/Function2;", "recoverText", "updateWithRecoveredData", "source", "result", "startIndex", "RecoveryResult", "emv-bertlv"})
public interface SignedDataDecoder {
    public void decodeSignedData(@NotNull DecodeSession var1, @NotNull List<DecodedData> var2);

    public void recoverSignedData(@NotNull BerTlv var1, @NotNull DecodedData var2, @NotNull RecoveredPublicKeyCertificate var3, @NotNull Function2<? super byte[], ? super Integer, ? extends List<DecodedData>> var4);

    @NotNull
    public RecoveryResult recoverText(@NotNull String var1, @NotNull RecoveredPublicKeyCertificate var2, int var3, @NotNull Function2<? super byte[], ? super Integer, ? extends List<DecodedData>> var4);

    @NotNull
    public RecoveryResult recoverCertificate(@NotNull BerTlv var1, @NotNull DecodedData var2, @NotNull PublicKeyCertificate var3, @NotNull Function3<? super byte[], ? super Integer, ? super Integer, RecoveredPublicKeyCertificate> var4);

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lio/github/binaryfoo/decoders/annotator/SignedDataDecoder$RecoveryResult;", "", "text", "", "_decoded", "", "Lio/github/binaryfoo/DecodedData;", "recoveredHex", "certificate", "Lio/github/binaryfoo/crypto/RecoveredPublicKeyCertificate;", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lio/github/binaryfoo/crypto/RecoveredPublicKeyCertificate;)V", "get_decoded", "()Ljava/util/List;", "getCertificate", "()Lio/github/binaryfoo/crypto/RecoveredPublicKeyCertificate;", "decoded", "getDecoded", "getRecoveredHex", "()Ljava/lang/String;", "getText", "component1", "component2", "component3", "component4", "copy", "emv-bertlv"})
    public static final class RecoveryResult {
        @NotNull
        private final String text;
        @NotNull
        private final List<DecodedData> _decoded;
        @Nullable
        private final String recoveredHex;
        @Nullable
        private final RecoveredPublicKeyCertificate certificate;

        @NotNull
        public final List<DecodedData> getDecoded() {
            return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)DecodedData.Companion.primitive$default(DecodedData.Companion, "", this.text, 0, 0, 12, null)), (Iterable)this._decoded);
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<DecodedData> get_decoded() {
            return this._decoded;
        }

        @Nullable
        public final String getRecoveredHex() {
            return this.recoveredHex;
        }

        @Nullable
        public final RecoveredPublicKeyCertificate getCertificate() {
            return this.certificate;
        }

        public RecoveryResult(@NotNull String text, @NotNull List<DecodedData> _decoded, @Nullable String recoveredHex, @Nullable RecoveredPublicKeyCertificate certificate) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(_decoded, (String)"_decoded");
            this.text = text;
            this._decoded = _decoded;
            this.recoveredHex = recoveredHex;
            this.certificate = certificate;
        }

        public /* synthetic */ RecoveryResult(String string, List list, String string2, RecoveredPublicKeyCertificate recoveredPublicKeyCertificate, int n, DefaultConstructorMarker defaultConstructorMarker) {
            RecoveryResult recoveryResult = this;
            String string3 = string;
            if ((n & 2) != 0) {
                String string4 = string3;
                RecoveryResult recoveryResult2 = recoveryResult;
                List list2 = CollectionsKt.emptyList();
                recoveryResult = recoveryResult2;
                string3 = string4;
                list = list2;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                recoveredPublicKeyCertificate = null;
            }
            recoveryResult(string3, list, string2, recoveredPublicKeyCertificate);
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<DecodedData> component2() {
            return this._decoded;
        }

        @Nullable
        public final String component3() {
            return this.recoveredHex;
        }

        @Nullable
        public final RecoveredPublicKeyCertificate component4() {
            return this.certificate;
        }

        @NotNull
        public final RecoveryResult copy(@NotNull String text, @NotNull List<DecodedData> _decoded, @Nullable String recoveredHex, @Nullable RecoveredPublicKeyCertificate certificate) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull(_decoded, (String)"_decoded");
            return new RecoveryResult(text, _decoded, recoveredHex, certificate);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ RecoveryResult copy$default(RecoveryResult recoveryResult, String string, List list, String string2, RecoveredPublicKeyCertificate recoveredPublicKeyCertificate, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n & 1) != 0) {
                string = recoveryResult.text;
            }
            if ((n & 2) != 0) {
                list = recoveryResult._decoded;
            }
            if ((n & 4) != 0) {
                string2 = recoveryResult.recoveredHex;
            }
            if ((n & 8) != 0) {
                recoveredPublicKeyCertificate = recoveryResult.certificate;
            }
            return recoveryResult.copy(string, list, string2, recoveredPublicKeyCertificate);
        }

        public String toString() {
            return "RecoveryResult(text=" + this.text + ", _decoded=" + this._decoded + ", recoveredHex=" + this.recoveredHex + ", certificate=" + this.certificate + ")";
        }

        public int hashCode() {
            String string = this.text;
            List<DecodedData> list = this._decoded;
            String string2 = this.recoveredHex;
            RecoveredPublicKeyCertificate recoveredPublicKeyCertificate = this.certificate;
            return (((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (recoveredPublicKeyCertificate != null ? ((Object)recoveredPublicKeyCertificate).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RecoveryResult)) break block3;
                    RecoveryResult recoveryResult = (RecoveryResult)object;
                    if (!Intrinsics.areEqual((Object)this.text, (Object)recoveryResult.text) || !Intrinsics.areEqual(this._decoded, recoveryResult._decoded) || !Intrinsics.areEqual((Object)this.recoveredHex, (Object)recoveryResult.recoveredHex) || !Intrinsics.areEqual((Object)this.certificate, (Object)recoveryResult.certificate)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=3)
    public static final class DefaultImpls {
        public static void recoverSignedData(@NotNull SignedDataDecoder $this, @NotNull BerTlv signedData, @NotNull DecodedData decodedSignedData, @NotNull RecoveredPublicKeyCertificate certificateOfSigner, Function2<? super byte[], ? super Integer, ? extends List<DecodedData>> decode) {
            Intrinsics.checkParameterIsNotNull((Object)signedData, (String)"signedData");
            Intrinsics.checkParameterIsNotNull((Object)decodedSignedData, (String)"decodedSignedData");
            Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
            Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
            int startIndex = decodedSignedData.getStartIndex() + signedData.getStartIndexOfValue();
            RecoveryResult result2 = $this.recoverText(signedData.getValueAsHexString(), certificateOfSigner, startIndex, decode);
            DefaultImpls.updateWithRecoveredData($this, decodedSignedData, result2, startIndex);
        }

        @NotNull
        public static RecoveryResult recoverText(@NotNull SignedDataDecoder $this, @NotNull String signedData, RecoveredPublicKeyCertificate certificateOfSigner, @NotNull int startIndexInBytes, Function2<? super byte[], ? super Integer, ? extends List<DecodedData>> decode) {
            Intrinsics.checkParameterIsNotNull((Object)signedData, (String)"signedData");
            Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
            Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
            if (certificateOfSigner.getExponent() == null) {
                return new RecoveryResult("Failed to recover: missing " + certificateOfSigner.getName() + " exponent", null, null, null, 14, null);
            }
            try {
                SignedDataRecoverer signedDataRecoverer = new SignedDataRecoverer();
                String string = certificateOfSigner.getExponent();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                byte[] recoveredBytes = signedDataRecoverer.recover(signedData, string, certificateOfSigner.getModulus());
                List recoveredData = (List)decode.invoke((Object)recoveredBytes, (Object)startIndexInBytes);
                return new RecoveryResult("Recovered using " + certificateOfSigner.getName(), recoveredData, ISOUtil.hexString(recoveredBytes), null, 8, null);
            }
            catch (Exception e) {
                return new RecoveryResult("Failed to recover: " + e, null, null, null, 14, null);
            }
        }

        @NotNull
        public static RecoveryResult recoverCertificate(@NotNull SignedDataDecoder $this, @NotNull BerTlv encryptedCertificate, @NotNull DecodedData decodedCertificate, @NotNull PublicKeyCertificate certificateOfSigner, Function3<? super byte[], ? super Integer, ? super Integer, RecoveredPublicKeyCertificate> decode) {
            Intrinsics.checkParameterIsNotNull((Object)encryptedCertificate, (String)"encryptedCertificate");
            Intrinsics.checkParameterIsNotNull((Object)decodedCertificate, (String)"decodedCertificate");
            Intrinsics.checkParameterIsNotNull((Object)certificateOfSigner, (String)"certificateOfSigner");
            Intrinsics.checkParameterIsNotNull(decode, (String)"decode");
            int startIndex = decodedCertificate.getStartIndex() + encryptedCertificate.getStartIndexOfValue();
            RecoveryResult result2 = DefaultImpls.recoverCertificate($this, encryptedCertificate.getValueAsHexString(), certificateOfSigner, startIndex, decode);
            DefaultImpls.updateWithRecoveredData($this, decodedCertificate, result2, startIndex);
            return result2;
        }

        private static RecoveryResult recoverCertificate(SignedDataDecoder $this, String signedData, PublicKeyCertificate certificateOfSigner, int startIndexInBytes, Function3<? super byte[], ? super Integer, ? super Integer, RecoveredPublicKeyCertificate> decode) {
            if (certificateOfSigner.getExponent() == null) {
                return new RecoveryResult("Failed to recover: missing " + certificateOfSigner.getName() + " exponent", null, null, null, 14, null);
            }
            try {
                SignedDataRecoverer signedDataRecoverer = new SignedDataRecoverer();
                String string = certificateOfSigner.getExponent();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                byte[] recoveredBytes = signedDataRecoverer.recover(signedData, string, certificateOfSigner.getModulus());
                RecoveredPublicKeyCertificate recoveredCertificate = (RecoveredPublicKeyCertificate)decode.invoke((Object)recoveredBytes, (Object)certificateOfSigner.getModulusLength(), (Object)startIndexInBytes);
                return new RecoveryResult("Recovered using " + certificateOfSigner.getName(), recoveredCertificate.getDetail(), ISOUtil.hexString(recoveredBytes), recoveredCertificate);
            }
            catch (Exception e) {
                return new RecoveryResult("Failed to recover: " + e, null, null, null, 14, null);
            }
        }

        private static void updateWithRecoveredData(SignedDataDecoder $this, DecodedData source, RecoveryResult result2, int startIndex) {
            source.addChildren(result2.getDecoded());
            if (result2.getRecoveredHex() != null) {
                source.setHexDump(HexDumpElement.Companion.splitIntoByteLengthStrings(result2.getRecoveredHex(), startIndex));
                source.setCategory("recovered");
            }
        }
    }
}

