/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.bit;

import io.github.binaryfoo.bit.BitPackage;
import io.github.binaryfoo.bit.EmvBit;
import io.github.binaryfoo.decoders.bit.BitStringField;
import io.github.binaryfoo.decoders.bit.EmvBitStringParser;
import io.github.binaryfoo.decoders.bit.EmvBitStringParserKt;
import io.github.binaryfoo.decoders.bit.EnumeratedBitStringField;
import io.github.binaryfoo.decoders.bit.FullByteField;
import io.github.binaryfoo.decoders.bit.NumericBitStringField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0007J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lio/github/binaryfoo/decoders/bit/EmvBitStringParser;", "", "()V", "FULL_BYTE_FIELD_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getFULL_BYTE_FIELD_PATTERN", "()Ljava/util/regex/Pattern;", "NUMERIC_FIELD_PATTERN", "getNUMERIC_FIELD_PATTERN", "SINGLE_BIT_PATTERN", "getSINGLE_BIT_PATTERN", "parse", "", "Lio/github/binaryfoo/decoders/bit/BitStringField;", "lines", "", "parseEnumeratedField", "key", "label", "parseField", "parseFullByteField", "parseNumericField", "emv-bertlv"})
public final class EmvBitStringParser {
    private static final Pattern SINGLE_BIT_PATTERN;
    private static final Pattern NUMERIC_FIELD_PATTERN;
    private static final Pattern FULL_BYTE_FIELD_PATTERN;
    public static final EmvBitStringParser INSTANCE;

    public final Pattern getSINGLE_BIT_PATTERN() {
        return SINGLE_BIT_PATTERN;
    }

    public final Pattern getNUMERIC_FIELD_PATTERN() {
        return NUMERIC_FIELD_PATTERN;
    }

    public final Pattern getFULL_BYTE_FIELD_PATTERN() {
        return FULL_BYTE_FIELD_PATTERN;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<BitStringField> parse(@NotNull List<String> lines) {
        Collection destination$iv$iv;
        String p1;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        parse.1 usefulLine$ = parse.1.INSTANCE;
        Iterable $receiver$iv = lines;
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            p1 = (String)element$iv$iv;
            if (!parse.1.INSTANCE.invoke(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void limit$iv;
            void $receiver$iv2;
            void regex$iv;
            void it;
            p1 = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            CharSequence $i$a$2 = (CharSequence)it;
            Regex $i$f$filterTo = new Regex("\\s*:\\s*");
            int $i$f$filter = 2;
            List fields = regex$iv.split((CharSequence)$receiver$iv2, (int)limit$iv);
            BitStringField bitStringField = INSTANCE.parseField((String)fields.get(0), (String)fields.get(1));
            collection2.add(bitStringField);
        }
        return (List)destination$iv$iv;
    }

    private final BitStringField parseField(String key, String label) {
        if (StringsKt.contains$default((CharSequence)key, (CharSequence)"-", (boolean)false, (int)2, null)) {
            return this.parseNumericField(key, label);
        }
        if (StringsKt.contains$default((CharSequence)key, (CharSequence)",", (boolean)false, (int)2, null)) {
            return this.parseEnumeratedField(key, label);
        }
        return this.parseFullByteField(key, label);
    }

    /*
     * WARNING - void declaration
     */
    private final BitStringField parseNumericField(String key, String label) {
        void $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        Pattern pattern = NUMERIC_FIELD_PATTERN;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"NUMERIC_FIELD_PATTERN");
        Matcher matcher = EmvBitStringParserKt.access$match(key, pattern, "numeric");
        String string = matcher.group("byte");
        int byteNumber = Integer.parseInt((String)$receiver$iv3);
        String $i$f$toInt = matcher.group("firstBit");
        int firstBit = Integer.parseInt((String)$receiver$iv2);
        String $i$f$toInt2 = matcher.group("lastBit");
        int lastBit = Integer.parseInt((String)$receiver$iv);
        return new NumericBitStringField(byteNumber, firstBit, lastBit, label);
    }

    /*
     * WARNING - void declaration
     */
    private final BitStringField parseEnumeratedField(String key, String label) {
        List list;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        TreeSet treeSet;
        Iterable iterable = StringsKt.split$default((CharSequence)key, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
        TreeSet treeSet2 = treeSet;
        TreeSet treeSet3 = treeSet;
        void var5_6 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            String string = (String)item$iv$iv;
            list = destination$iv$iv;
            EmvBit emvBit = EmvBitStringParserKt.access$parseBit((String)p1);
            list.add(emvBit);
        }
        list = (List)destination$iv$iv;
        treeSet2(list);
        TreeSet bits = treeSet3;
        return new EnumeratedBitStringField(bits, label);
    }

    /*
     * WARNING - void declaration
     */
    private final BitStringField parseFullByteField(String key, String label) {
        String hexValue;
        void $receiver$iv;
        Pattern pattern = FULL_BYTE_FIELD_PATTERN;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"FULL_BYTE_FIELD_PATTERN");
        Matcher matcher = EmvBitStringParserKt.access$match(key, pattern, "full byte");
        String string = matcher.group("byte");
        int byteNumber = Integer.parseInt((String)$receiver$iv);
        String string2 = hexValue = matcher.group("value");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hexValue");
        Set<EmvBit> bits = BitPackage.fromHex(string2, byteNumber);
        String string3 = hexValue;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"hexValue");
        return new FullByteField(bits, byteNumber, string3, label);
    }

    private EmvBitStringParser() {
        INSTANCE = this;
        SINGLE_BIT_PATTERN = Pattern.compile("\\s*\\((?<byte>\\d+),(?<bit>\\d+)\\)=(?<value>\\d+)\\s*");
        NUMERIC_FIELD_PATTERN = Pattern.compile("\\s*\\((?<byte>\\d+),(?<firstBit>\\d+)-(?<lastBit>\\d+)\\)=INT\\s*");
        FULL_BYTE_FIELD_PATTERN = Pattern.compile("\\s*\\((?<byte>\\d+)\\)=0x(?<value>[0-9a-fA-F]{2})\\s*");
    }

    static {
        new EmvBitStringParser();
    }
}

