/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.bit;

import io.github.binaryfoo.bit.BitPackage;
import io.github.binaryfoo.bit.EmvBit;
import io.github.binaryfoo.decoders.bit.BitStringField;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00062\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/github/binaryfoo/decoders/bit/EnumeratedBitStringField;", "Lio/github/binaryfoo/decoders/bit/BitStringField;", "field", "", "Lio/github/binaryfoo/bit/EmvBit;", "value", "", "(Ljava/util/Set;Ljava/lang/String;)V", "getLengthInBytes", "", "getPositionIn", "bits", "getStartBytesOffset", "getValueIn", "emv-bertlv"})
public final class EnumeratedBitStringField
implements BitStringField {
    private final Set<EmvBit> field;
    private final String value;

    @Override
    @NotNull
    public String getPositionIn(@Nullable Set<EmvBit> bits) {
        if (bits == null) {
            return BitPackage.toString(this.field, true);
        }
        return BitPackage.toHexString(this.field, BitPackage.getByteCount(bits)) + " (" + BitPackage.toString(this.field, this.field.size() > 1) + ")";
    }

    @Override
    @Nullable
    public String getValueIn(@NotNull Set<EmvBit> bits) {
        Intrinsics.checkParameterIsNotNull(bits, (String)"bits");
        return BitPackage.matches(this.field, bits) ? this.value : (String)null;
    }

    @Override
    public int getStartBytesOffset() {
        return ((EmvBit)CollectionsKt.first((Iterable)this.field)).getByteNumber() - 1;
    }

    @Override
    public int getLengthInBytes() {
        return 1;
    }

    public EnumeratedBitStringField(@NotNull Set<EmvBit> field, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull(field, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.value = value;
        this.field = new TreeSet(field);
    }
}

