/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.decoders.bit;

import io.github.binaryfoo.bit.BitPackage;
import io.github.binaryfoo.bit.EmvBit;
import io.github.binaryfoo.decoders.bit.BitStringField;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/binaryfoo/decoders/bit/FullByteField;", "Lio/github/binaryfoo/decoders/bit/BitStringField;", "field", "", "Lio/github/binaryfoo/bit/EmvBit;", "byteNumber", "", "hexValue", "", "decodedValue", "(Ljava/util/Set;ILjava/lang/String;Ljava/lang/String;)V", "getLengthInBytes", "getPositionIn", "bits", "getStartBytesOffset", "getValueIn", "emv-bertlv"})
public final class FullByteField
implements BitStringField {
    private final Set<EmvBit> field;
    private final int byteNumber;
    private final String hexValue;
    private final String decodedValue;

    @Override
    @NotNull
    public String getPositionIn(@Nullable Set<EmvBit> bits) {
        return "Byte " + this.byteNumber + " = 0x" + this.hexValue;
    }

    @Override
    @Nullable
    public String getValueIn(@NotNull Set<EmvBit> bits) {
        Intrinsics.checkParameterIsNotNull(bits, (String)"bits");
        return BitPackage.matches(this.field, bits) ? this.decodedValue : (String)null;
    }

    @Override
    public int getStartBytesOffset() {
        return this.byteNumber - 1;
    }

    @Override
    public int getLengthInBytes() {
        return 1;
    }

    public FullByteField(@NotNull Set<EmvBit> field, int byteNumber, @NotNull String hexValue, @NotNull String decodedValue) {
        Intrinsics.checkParameterIsNotNull(field, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)hexValue, (String)"hexValue");
        Intrinsics.checkParameterIsNotNull((Object)decodedValue, (String)"decodedValue");
        this.byteNumber = byteNumber;
        this.hexValue = hexValue;
        this.decodedValue = decodedValue;
        this.field = new TreeSet(field);
    }
}

