/*
 * Decompiled with CFR 0.152.
 */
package io.github.binaryfoo.tlv;

import io.github.binaryfoo.tlv.CompliantTagMode;
import io.github.binaryfoo.tlv.ConstructedBerTlv;
import io.github.binaryfoo.tlv.HexExtensionsKt;
import io.github.binaryfoo.tlv.ISOUtil;
import io.github.binaryfoo.tlv.PrimitiveBerTlv;
import io.github.binaryfoo.tlv.Tag;
import io.github.binaryfoo.tlv.TagRecognitionMode;
import io.github.binaryfoo.tlv.TlvParseException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0002\u001a\u00020\u0003H&J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u00152\u0006\u0010\u0002\u001a\u00020\u0003H&J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015H&J\u0012\u0010\u0007\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H&J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0010R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lio/github/binaryfoo/tlv/BerTlv;", "", "tag", "Lio/github/binaryfoo/tlv/Tag;", "(Lio/github/binaryfoo/tlv/Tag;)V", "length", "", "getLength", "()I", "lengthInBytesOfEncodedLength", "getLengthInBytesOfEncodedLength", "startIndexOfValue", "getStartIndexOfValue", "getTag", "()Lio/github/binaryfoo/tlv/Tag;", "valueAsHexString", "", "getValueAsHexString", "()Ljava/lang/String;", "findTlv", "findTlvs", "", "getChildren", "", "value", "getValue", "toBinary", "toHexString", "Companion", "emv-bertlv"})
public abstract class BerTlv {
    @NotNull
    private final Tag tag;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] toBinary() {
        byte[] value = this.getValue();
        List<Byte> encodedTag = this.tag.getBytes();
        byte[] encodedLength = this.getLength(value);
        ByteBuffer b = ByteBuffer.allocate(encodedTag.size() + encodedLength.length + value.length);
        b.put(CollectionsKt.toByteArray((Collection)encodedTag));
        b.put(encodedLength);
        b.put(value);
        b.flip();
        byte[] byArray = b.array();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"b.array()");
        return byArray;
    }

    @NotNull
    public final String toHexString() {
        String string = ISOUtil.hexString(this.toBinary());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(toBinary())");
        return string;
    }

    @NotNull
    public final String getValueAsHexString() {
        String string = ISOUtil.hexString(this.getValue());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISOUtil.hexString(getValue())");
        return string;
    }

    public final int getLengthInBytesOfEncodedLength() {
        return this.getLength(this.getValue()).length;
    }

    public final int getLength() {
        return this.getValue().length;
    }

    public final int getStartIndexOfValue() {
        return this.tag.getBytes().size() + this.getLengthInBytesOfEncodedLength();
    }

    @Nullable
    public abstract BerTlv findTlv(@NotNull Tag var1);

    @NotNull
    public abstract List<BerTlv> findTlvs(@NotNull Tag var1);

    @NotNull
    public abstract byte[] getValue();

    @NotNull
    public abstract List<BerTlv> getChildren();

    /*
     * WARNING - void declaration
     */
    private final byte[] getLength(byte[] value) {
        byte[] length;
        if (value == null) {
            return new byte[]{(byte)0};
        }
        if (value.length <= 127) {
            length = new byte[]{(byte)value.length};
        } else {
            int wanted = value.length;
            int expected = 256;
            int needed = 1;
            while (wanted >= expected) {
                ++needed;
                if ((expected <<= 8) != 0) continue;
                throw (Throwable)new IllegalArgumentException();
            }
            length = new byte[needed + 1];
            length[0] = (byte)(0x80 | needed);
            int n = 1;
            int n2 = length.length - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    length[length.length - i] = (byte)(wanted >> 8 * (i - true) & 0xFF);
                    if (i == n2) break;
                    ++i;
                }
            }
        }
        return length;
    }

    @NotNull
    public final Tag getTag() {
        return this.tag;
    }

    public BerTlv(@NotNull Tag tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.tag = tag;
    }

    @JvmStatic
    @NotNull
    public static final BerTlv newInstance(@NotNull Tag tag, @NotNull byte[] value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return Companion.newInstance(tag, value);
    }

    @JvmStatic
    @NotNull
    public static final BerTlv newInstance(@NotNull Tag tag, @NotNull String hexString) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)hexString, (String)"hexString");
        return Companion.newInstance(tag, hexString);
    }

    @JvmStatic
    @NotNull
    public static final BerTlv newInstance(@NotNull Tag tag, int value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        return Companion.newInstance(tag, value);
    }

    @JvmStatic
    @NotNull
    public static final BerTlv newInstance(@NotNull Tag tag, @NotNull List<? extends BerTlv> value) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return Companion.newInstance(tag, value);
    }

    @JvmStatic
    @NotNull
    public static final BerTlv newInstance(@NotNull Tag tag, @NotNull BerTlv tlv1, @NotNull BerTlv tlv2) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull((Object)tlv1, (String)"tlv1");
        Intrinsics.checkParameterIsNotNull((Object)tlv2, (String)"tlv2");
        return Companion.newInstance(tag, tlv1, tlv2);
    }

    @JvmStatic
    @NotNull
    public static final BerTlv parse(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return Companion.parse(data);
    }

    @JvmStatic
    @NotNull
    public static final BerTlv parseAsPrimitiveTag(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return Companion.parseAsPrimitiveTag(data);
    }

    @JvmStatic
    @NotNull
    public static final List<BerTlv> parseList(@NotNull byte[] data, boolean parseConstructedTags) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return Companion.parseList(data, parseConstructedTags);
    }

    @JvmStatic
    @NotNull
    public static final List<BerTlv> parseList(@NotNull byte[] data, boolean parseConstructedTags, @NotNull TagRecognitionMode recognitionMode) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)recognitionMode, (String)"recognitionMode");
        return Companion.parseList(data, parseConstructedTags, recognitionMode);
    }

    @JvmStatic
    @Nullable
    public static final BerTlv findTlv(@NotNull List<? extends BerTlv> tlvs, @NotNull Tag tag) {
        Intrinsics.checkParameterIsNotNull(tlvs, (String)"tlvs");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        return Companion.findTlv(tlvs, tag);
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0010H\u0007J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\n2\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\nH\u0007J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0018\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0010H\u0002\u00a8\u0006\u001e"}, d2={"Lio/github/binaryfoo/tlv/BerTlv$Companion;", "", "()V", "findTlv", "Lio/github/binaryfoo/tlv/BerTlv;", "tlvs", "", "tag", "Lio/github/binaryfoo/tlv/Tag;", "isPaddingByte", "", "newInstance", "tlv1", "tlv2", "value", "", "", "hexString", "", "parse", "data", "parseAsPrimitiveTag", "parseLength", "Ljava/nio/ByteBuffer;", "parseList", "parseConstructedTags", "recognitionMode", "Lio/github/binaryfoo/tlv/TagRecognitionMode;", "readUpToLength", "length", "emv-bertlv"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final BerTlv newInstance(@NotNull Tag tag, @NotNull byte[] value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new PrimitiveBerTlv(tag, value);
        }

        @JvmStatic
        @NotNull
        public final BerTlv newInstance(@NotNull Tag tag, @NotNull String hexString) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)hexString, (String)"hexString");
            byte[] byArray = ISOUtil.hex2byte(hexString);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ISOUtil.hex2byte(hexString)");
            return new PrimitiveBerTlv(tag, byArray);
        }

        @JvmStatic
        @NotNull
        public final BerTlv newInstance(@NotNull Tag tag, int value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            if (value > 255) {
                throw (Throwable)new IllegalArgumentException("Value greater than 255 must be encoded in a byte array");
            }
            return new PrimitiveBerTlv(tag, new byte[]{(byte)value});
        }

        @JvmStatic
        @NotNull
        public final BerTlv newInstance(@NotNull Tag tag, @NotNull List<? extends BerTlv> value) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            return new ConstructedBerTlv(tag, value);
        }

        @JvmStatic
        @NotNull
        public final BerTlv newInstance(@NotNull Tag tag, @NotNull BerTlv tlv1, @NotNull BerTlv tlv2) {
            Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
            Intrinsics.checkParameterIsNotNull((Object)tlv1, (String)"tlv1");
            Intrinsics.checkParameterIsNotNull((Object)tlv2, (String)"tlv2");
            List<BerTlv> list = Arrays.asList(tlv1, tlv2);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList<BerTlv>(tlv1, tlv2)");
            return new ConstructedBerTlv(tag, list);
        }

        @JvmStatic
        @NotNull
        public final BerTlv parse(@NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(data)");
            return (BerTlv)io.github.binaryfoo.tlv.BerTlv$Companion.parseList$default(this, byteBuffer, true, null, 4, null).get(0);
        }

        @JvmStatic
        @NotNull
        public final BerTlv parseAsPrimitiveTag(@NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(data)");
            return (BerTlv)io.github.binaryfoo.tlv.BerTlv$Companion.parseList$default(this, byteBuffer, false, null, 4, null).get(0);
        }

        @JvmStatic
        @NotNull
        public final List<BerTlv> parseList(@NotNull byte[] data, boolean parseConstructedTags) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(data)");
            return io.github.binaryfoo.tlv.BerTlv$Companion.parseList$default(this, byteBuffer, parseConstructedTags, null, 4, null);
        }

        @JvmStatic
        @NotNull
        public final List<BerTlv> parseList(@NotNull byte[] data, boolean parseConstructedTags, @NotNull TagRecognitionMode recognitionMode) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)recognitionMode, (String)"recognitionMode");
            ByteBuffer byteBuffer = ByteBuffer.wrap(data);
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(data)");
            return this.parseList(byteBuffer, parseConstructedTags, recognitionMode);
        }

        private final List<BerTlv> parseList(ByteBuffer data, boolean parseConstructedTags, TagRecognitionMode recognitionMode) {
            ArrayList<BerTlv> tlvs = new ArrayList<BerTlv>();
            while (data.hasRemaining()) {
                Tag tag = Tag.Companion.parse(data, recognitionMode);
                if (this.isPaddingByte(tag)) continue;
                try {
                    int length = this.parseLength(data);
                    byte[] value = this.readUpToLength(data, length);
                    if (tag.getConstructed() && parseConstructedTags) {
                        try {
                            tlvs.add(this.newInstance(tag, this.parseList(value, true, recognitionMode)));
                        }
                        catch (Exception e) {
                            tlvs.add(this.newInstance(tag, value));
                        }
                        continue;
                    }
                    tlvs.add(this.newInstance(tag, value));
                }
                catch (Exception e) {
                    throw (Throwable)new TlvParseException((List<? extends BerTlv>)tlvs, "Failed parsing TLV with tag " + tag + ": " + e.getMessage(), e);
                }
            }
            return tlvs;
        }

        static /* bridge */ /* synthetic */ List parseList$default(Companion companion, ByteBuffer byteBuffer, boolean bl, TagRecognitionMode tagRecognitionMode, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseList");
            }
            if ((n & 4) != 0) {
                tagRecognitionMode = CompliantTagMode.INSTANCE;
            }
            return companion.parseList(byteBuffer, bl, tagRecognitionMode);
        }

        private final byte[] readUpToLength(ByteBuffer data, int length) {
            byte[] value = new byte[length > data.remaining() ? data.remaining() : length];
            data.get(value);
            return value;
        }

        private final boolean isPaddingByte(Tag tag) {
            return tag.getBytes().size() == 1 && ((Number)tag.getBytes().get(0)).byteValue() == (byte)0;
        }

        /*
         * WARNING - void declaration
         */
        private final int parseLength(ByteBuffer data) {
            int firstByte = data.get();
            int length = 0;
            if ((firstByte & 0x80) == 128) {
                int n = 1;
                int numberOfBytesToEncodeLength = firstByte & 0x7F;
                int n2 = numberOfBytesToEncodeLength;
                if (n <= n2) {
                    while (true) {
                        void i;
                        if (!data.hasRemaining()) {
                            throw (Throwable)new IllegalArgumentException("Bad length: expected to read " + numberOfBytesToEncodeLength + " (0x" + HexExtensionsKt.toHexString((byte)firstByte) + ") bytes. Only have " + (int)(i - true) + ".");
                        }
                        length += data.get() & 0xFF;
                        if (i != numberOfBytesToEncodeLength) {
                            length *= 256;
                        }
                        if (length < 0) {
                            throw (Throwable)new IllegalArgumentException("Bad length: " + length + " < 0. Read " + (int)i + " of " + numberOfBytesToEncodeLength + " (0x" + HexExtensionsKt.toHexString((byte)firstByte) + ") bytes used to encode length of TLV.");
                        }
                        if (i != n2) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                length = firstByte;
            }
            return length;
        }

        @JvmStatic
        @Nullable
        public final BerTlv findTlv(@NotNull List<? extends BerTlv> tlvs, @NotNull Tag tag) {
            Object v0;
            block1: {
                Intrinsics.checkParameterIsNotNull(tlvs, (String)"tlvs");
                Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
                Iterable $receiver$iv = tlvs;
                for (Object element$iv : $receiver$iv) {
                    BerTlv it = (BerTlv)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getTag(), (Object)tag)) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

