/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv.internal;

import io.github.cdimascio.dotenv.DotEnvException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lio/github/cdimascio/dotenv/internal/ClasspathHelper;", "", "()V", "loadFileFromClasspath", "Ljava/util/stream/Stream;", "", "location", "java-dotenv"})
public final class ClasspathHelper {
    public static final ClasspathHelper INSTANCE;

    @NotNull
    public final Stream<String> loadFileFromClasspath(@NotNull String location) {
        InputStream inputStream;
        InputStream inputStream2;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Class<ClasspathHelper> loader = ClasspathHelper.class;
        InputStream inputStream3 = loader.getResourceAsStream(location);
        if (inputStream3 == null) {
            inputStream3 = inputStream2 = loader.getResourceAsStream(location);
        }
        if (inputStream3 == null) {
            inputStream2 = inputStream = ClassLoader.getSystemResourceAsStream(location);
        }
        if (inputStream != null) {
            try {
                Scanner scanner = new Scanner(inputStream, "utf-8");
                List lines = new ArrayList();
                while (scanner.hasNext()) {
                    String string = scanner.nextLine();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scanner.nextLine()");
                    lines.add(string);
                }
                Stream<String> stream = lines.stream();
                Intrinsics.checkExpressionValueIsNotNull(stream, (String)"lines.stream()");
                return stream;
            }
            catch (IOException e) {
                throw (Throwable)new DotEnvException("Could not parse " + location + " from the classpath");
            }
        }
        throw (Throwable)new DotEnvException("Could not find " + location + " on the classpath");
    }

    private ClasspathHelper() {
    }

    static {
        ClasspathHelper classpathHelper;
        INSTANCE = classpathHelper = new ClasspathHelper();
    }
}

