/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv.internal;

import io.github.cdimascio.dotenv.DotEnvException;
import io.github.cdimascio.dotenv.internal.ClasspathHelper;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/github/cdimascio/dotenv/internal/DotenvReader;", "", "directory", "", "filename", "(Ljava/lang/String;Ljava/lang/String;)V", "read", "Ljava/util/stream/Stream;", "java-dotenv"})
public final class DotenvReader {
    private final String directory;
    private final String filename;

    @NotNull
    public final Stream<String> read() {
        Object object;
        Path path;
        CharSequence charSequence = this.directory;
        String string = "\\\\";
        boolean bl = false;
        string = new Regex(string);
        Object object2 = "/";
        boolean bl2 = false;
        String dir = StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string.replace(charSequence, (String)object2), (CharSequence)".env"), (CharSequence)"/");
        String location = dir + '/' + this.filename;
        Path path2 = path = StringsKt.startsWith((String)location, (String)"file:", (boolean)true) || StringsKt.startsWith((String)location, (String)"android.resource:", (boolean)true) ? Paths.get(URI.create(location)) : Paths.get(location, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            Stream<String> stream = Files.lines(path);
            object = stream;
            Intrinsics.checkNotNullExpressionValue(stream, (String)"Files.lines(path)");
        } else {
            try {
                object2 = ClasspathHelper.INSTANCE.loadFileFromClasspath(StringsKt.replaceFirst$default((String)location, (String)"./", (String)"/", (boolean)false, (int)4, null));
            }
            catch (DotEnvException e) {
                Path cwd = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath().normalize();
                Path path3 = path;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
                String cwdMessage = !path3.isAbsolute() ? "(working directory: " + cwd + ')' : "";
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)new DotEnvException("Could not find " + path + " on the file system " + cwdMessage));
                throw (Throwable)e;
            }
            object = object2;
        }
        return object;
    }

    public DotenvReader(@NotNull String directory, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.directory = directory;
        this.filename = filename;
    }
}

