/*
 * Decompiled with CFR 0.152.
 */
package io.github.deweyjose.graphqlcodegen;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class DependencySchemaExtractor {
    public static List<File> extract(MavenProject project, String[] schemaJarFilesFromDependencies) {
        ArrayList<File> files = new ArrayList<File>();
        for (String jarDep : schemaJarFilesFromDependencies) {
            Optional<Artifact> artifactOpt;
            String jarDepClean = jarDep.trim();
            if (jarDepClean.isEmpty() || !(artifactOpt = DependencySchemaExtractor.findFromDependencies(project, jarDepClean)).isPresent()) continue;
            Artifact artifact = artifactOpt.get();
            File file = artifact.getFile();
            files.add(file);
        }
        return files;
    }

    private static Optional<Artifact> findFromDependencies(MavenProject project, String artifactRef) {
        String cleanRef = artifactRef.trim();
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            String ref = String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            if (!ref.equals(cleanRef)) continue;
            return Optional.of(artifact);
        }
        return Optional.empty();
    }
}

