/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.bloom;

import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class BlockedBloom
implements Filter {
    private final int buckets;
    private final long seed;
    private final long[] data;

    public static BlockedBloom construct(long[] keys, int bitsPerKey) {
        int n = keys.length;
        BlockedBloom f = new BlockedBloom(n, bitsPerKey);
        for (long x : keys) {
            f.add(x);
        }
        return f;
    }

    @Override
    public long getBitCount() {
        return (long)this.data.length * 64L;
    }

    BlockedBloom(int entryCount, int bitsPerKey) {
        entryCount = Math.max(1, entryCount);
        this.seed = Hash.randomSeed();
        long bits = (long)entryCount * (long)bitsPerKey;
        this.buckets = (int)bits / 64;
        this.data = new long[this.buckets + 16 + 1];
    }

    @Override
    public boolean supportsAdd() {
        return true;
    }

    @Override
    public void add(long key) {
        long hash = Hash.hash64(key, this.seed);
        int start = Hash.reduce((int)hash, this.buckets);
        hash ^= Long.rotateLeft(hash, 32);
        long m1 = 1L << (int)hash | 1L << (int)(hash >> 6);
        long m2 = 1L << (int)(hash >> 12) | 1L << (int)(hash >> 18);
        int n = start;
        this.data[n] = this.data[n] | m1;
        int n2 = start + 1 + (int)(hash >>> 60);
        this.data[n2] = this.data[n2] | m2;
    }

    @Override
    public boolean mayContain(long key) {
        long hash = Hash.hash64(key, this.seed);
        int start = Hash.reduce((int)hash, this.buckets);
        hash ^= Long.rotateLeft(hash, 32);
        long a = this.data[start];
        long b = this.data[start + 1 + (int)(hash >>> 60)];
        long m1 = 1L << (int)hash | 1L << (int)(hash >> 6);
        long m2 = 1L << (int)(hash >> 12) | 1L << (int)(hash >> 18);
        return (m1 & a) == m1 && (m2 & b) == m2;
    }
}

