/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.bloom;

import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class Bloom
implements Filter {
    private final int k;
    private final long bits;
    private final long seed;
    private final int arraySize;
    private final long[] data;

    public static Bloom construct(long[] keys, double bitsPerKey) {
        long n = keys.length;
        int k = Bloom.getBestK(bitsPerKey);
        Bloom f = new Bloom((int)n, bitsPerKey, k);
        for (long x : keys) {
            f.add(x);
        }
        return f;
    }

    private static int getBestK(double bitsPerKey) {
        return Math.max(1, (int)Math.round(bitsPerKey * Math.log(2.0)));
    }

    @Override
    public long getBitCount() {
        return (long)this.data.length * 64L;
    }

    Bloom(int entryCount, double bitsPerKey, int k) {
        entryCount = Math.max(1, entryCount);
        this.k = k;
        this.seed = Hash.randomSeed();
        this.bits = (long)((double)entryCount * bitsPerKey);
        this.arraySize = (int)((this.bits + 63L) / 64L);
        this.data = new long[this.arraySize];
    }

    @Override
    public boolean supportsAdd() {
        return true;
    }

    @Override
    public void add(long key) {
        long hash = Hash.hash64(key, this.seed);
        long a = hash >>> 32 | hash << 32;
        long b = hash;
        for (int i = 0; i < this.k; ++i) {
            int n = Hash.reduce((int)(a >>> 32), this.arraySize);
            this.data[n] = this.data[n] | 1L << (int)a;
            a += b;
        }
    }

    @Override
    public boolean mayContain(long key) {
        long hash = Hash.hash64(key, this.seed);
        long a = hash >>> 32 | hash << 32;
        long b = hash;
        for (int i = 0; i < this.k; ++i) {
            if ((this.data[Hash.reduce((int)(a >>> 32), this.arraySize)] & 1L << (int)a) == 0L) {
                return false;
            }
            a += b;
        }
        return true;
    }
}

