/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.bloom.count;

import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class CountingBloom
implements Filter {
    private final int k;
    private final long bits;
    private final long seed;
    private final int arraySize;
    private final long[] counts;

    public static CountingBloom construct(long[] keys, double bitsPerKey) {
        long n = keys.length;
        int k = CountingBloom.getBestK(bitsPerKey);
        CountingBloom f = new CountingBloom((int)n, bitsPerKey, k);
        for (long x : keys) {
            f.add(x);
        }
        return f;
    }

    private static int getBestK(double bitsPerKey) {
        return Math.max(1, (int)Math.round(bitsPerKey * Math.log(2.0)));
    }

    @Override
    public long getBitCount() {
        return (long)this.counts.length * 64L;
    }

    CountingBloom(int entryCount, double bitsPerKey, int k) {
        entryCount = Math.max(1, entryCount);
        this.k = k;
        this.seed = Hash.randomSeed();
        this.bits = (long)((double)(4 * entryCount) * bitsPerKey) + 64L;
        this.arraySize = (int)((this.bits + 63L) / 64L);
        this.counts = new long[this.arraySize];
    }

    @Override
    public boolean supportsAdd() {
        return true;
    }

    @Override
    public void add(long key) {
        long hash = Hash.hash64(key, this.seed);
        int a = (int)(hash >>> 32);
        int b = (int)hash;
        for (int i = 0; i < this.k; ++i) {
            int index = Hash.reduce(a, this.arraySize << 4);
            int oldCount = (int)(this.counts[index >>> 4] >>> (index << 2)) & 0xF;
            if (oldCount >= 15) {
                throw new UnsupportedOperationException("Counter overflow");
            }
            int n = index >>> 4;
            this.counts[n] = this.counts[n] + CountingBloom.getBit(index);
            a += b;
        }
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Override
    public void remove(long key) {
        long hash = Hash.hash64(key, this.seed);
        int a = (int)(hash >>> 32);
        int b = (int)hash;
        for (int i = 0; i < this.k; ++i) {
            int index = Hash.reduce(a, this.arraySize << 4);
            int n = index >>> 4;
            this.counts[n] = this.counts[n] - CountingBloom.getBit(index);
            a += b;
        }
    }

    private static long getBit(int index) {
        return 1L << (index << 2);
    }

    @Override
    public boolean mayContain(long key) {
        long hash = Hash.hash64(key, this.seed);
        int a = (int)(hash >>> 32);
        int b = (int)hash;
        for (int i = 0; i < this.k; ++i) {
            int index = Hash.reduce(a, this.arraySize << 4);
            if ((this.counts[index >>> 4] >>> (index << 2) & 0xFL) == 0L) {
                return false;
            }
            a += b;
        }
        return true;
    }

    @Override
    public long cardinality() {
        long sum = 0L;
        for (long x : this.counts) {
            sum += (long)Long.bitCount(x);
        }
        return sum;
    }
}

