/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.bloom.count;

import org.fastfilter.Filter;
import org.fastfilter.bloom.count.Select;
import org.fastfilter.utils.Hash;

public class SuccinctCountingBloom
implements Filter {
    private static final boolean VERIFY_COUNTS = false;
    private final int k;
    private final long seed;
    private final int arraySize;
    private final BitField data;
    private final BitField counts;
    private int nextFreeOverflow;
    private final long[] overflow;
    private final byte[] realCounts;

    public static SuccinctCountingBloom construct(long[] keys, double bitsPerKey) {
        long n = keys.length;
        int k = SuccinctCountingBloom.getBestK(bitsPerKey);
        SuccinctCountingBloom f = new SuccinctCountingBloom((int)n, bitsPerKey, k);
        for (long x : keys) {
            f.add(x);
        }
        return f;
    }

    private static int getBestK(double bitsPerKey) {
        return Math.max(1, (int)Math.round(bitsPerKey * Math.log(2.0)));
    }

    @Override
    public long getBitCount() {
        return this.data.getBitCount() + this.counts.getBitCount() + (long)(64 * this.overflow.length);
    }

    SuccinctCountingBloom(int entryCount, double bitsPerKey, int k) {
        entryCount = Math.max(1, entryCount);
        this.k = k;
        this.seed = Hash.randomSeed();
        long bits = (long)((double)entryCount * bitsPerKey);
        this.arraySize = (int)((bits + 63L) / 64L);
        this.data = new BitField(64 * (this.arraySize + 10));
        this.counts = new BitField(64 * (this.arraySize + 10));
        this.overflow = new long[100 + this.arraySize * 12 / 100];
        for (int i = 0; i < this.overflow.length; i += 4) {
            this.overflow[i] = i + 4;
        }
        this.realCounts = null;
    }

    @Override
    public boolean supportsAdd() {
        return true;
    }

    @Override
    public void add(long key) {
        long hash = Hash.hash64(key, this.seed);
        int a = (int)(hash >>> 32);
        int b = (int)hash;
        for (int i = 0; i < this.k; ++i) {
            int index = (Hash.reduce(a, this.arraySize) << 6) + (a & 0x3F);
            this.increment(index);
            a += b;
        }
    }

    @Override
    public boolean supportsRemove() {
        return true;
    }

    @Override
    public void remove(long key) {
        long hash = Hash.hash64(key, this.seed);
        int a = (int)(hash >>> 32);
        int b = (int)hash;
        for (int i = 0; i < this.k; ++i) {
            int index = (Hash.reduce(a, this.arraySize) << 6) + (a & 0x3F);
            this.decrement(index);
            a += b;
        }
    }

    @Override
    public long cardinality() {
        return this.data.cardinality() + this.counts.cardinality();
    }

    private void increment(int x) {
        int group = x >>> 6;
        long m = this.data.getLong(group);
        long d = m >>> x & 1L;
        long c = this.counts.getLong(group);
        if ((c & 0xC000000000000000L) != 0L) {
            int index;
            if ((c & Long.MIN_VALUE) == 0L) {
                index = this.allocateOverflow();
                for (int i = 0; i < 64; ++i) {
                    int n = this.readCount((group << 6) + i);
                    int n2 = index + i / 16;
                    this.overflow[n2] = this.overflow[n2] + (long)n * SuccinctCountingBloom.getBit(i);
                }
                long count = 64L;
                c = Long.MIN_VALUE | count << 32 | (long)index;
            } else {
                index = (int)(c & 0xFFFFFFFL);
                c += 0x100000000L;
            }
            this.counts.setLong(group, c);
            int bitIndex = x & 0x3F;
            int n = index + bitIndex / 16;
            this.overflow[n] = this.overflow[n] + SuccinctCountingBloom.getBit(bitIndex);
            this.data.set(x);
            return;
        }
        this.data.set(x);
        int bitsBefore = Long.bitCount(m & -1L >>> 63 - x);
        int before = Select.selectInLong(c << 1 | 1L, bitsBefore);
        int insertAt = before - (int)d;
        long mask = (1L << insertAt) - 1L;
        long left = c & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        long right = c & mask;
        c = left << 1 | (1L ^ d) << insertAt | right;
        this.counts.setLong(group, c);
    }

    private int allocateOverflow() {
        int result = this.nextFreeOverflow;
        this.nextFreeOverflow = (int)this.overflow[result];
        this.overflow[result] = 0L;
        this.overflow[result + 1] = 0L;
        this.overflow[result + 2] = 0L;
        this.overflow[result + 3] = 0L;
        return result;
    }

    private void freeOverflow(int index) {
        this.overflow[index] = this.nextFreeOverflow;
        this.nextFreeOverflow = index;
    }

    private static long getBit(int index) {
        return 1L << index * 4;
    }

    private void decrement(int x) {
        int group = x >>> 6;
        long m = this.data.getLong(group);
        long c = this.counts.getLong(group);
        if ((c & Long.MIN_VALUE) != 0L) {
            int count = (int)(c >>> 32) & 0xFFFFFFF;
            this.counts.setLong(group, c -= 0x100000000L);
            int index = (int)(c & 0xFFFFFFFL);
            int bitIndex = x & 0x3F;
            long n = this.overflow[index + bitIndex / 16];
            this.overflow[index + bitIndex / 16] = n - SuccinctCountingBloom.getBit(bitIndex);
            if (((n >>>= 4 * (bitIndex & 0xF)) & 0xFL) == 1L) {
                this.data.clear(x);
            }
            if (count < 64) {
                long c2 = 0L;
                for (int j = 63; j >= 0; --j) {
                    int cj = (int)(this.overflow[index + j / 16] >>> 4 * j & 0xFL);
                    if (cj <= 0) continue;
                    c2 = (c2 << 1 | 1L) << cj - 1;
                }
                this.counts.setLong(group, c2);
                this.freeOverflow(index);
            }
            return;
        }
        int bitsBefore = Long.bitCount(m & -1L >>> 63 - x);
        int before = Select.selectInLong(c << 1 | 1L, bitsBefore) - 1;
        int removeAt = Math.max(0, before - 1);
        long mask = (1L << removeAt) - 1L;
        long left = c >>> 1 & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        long right = c & mask;
        this.counts.setLong(group, left | right);
        long removed = c >> removeAt & 1L;
        this.data.setLong(group, m & (removed << x ^ 0xFFFFFFFFFFFFFFFFL));
    }

    private int readCount(int x) {
        int group = x >>> 6;
        long m = this.data.getLong(group);
        long d = m >>> x & 1L;
        if (d == 0L) {
            return 0;
        }
        long c = this.counts.getLong(group);
        if ((c & Long.MIN_VALUE) != 0L) {
            int index = (int)(c & 0xFFFFFFFL);
            int bitIndex = x & 0x3F;
            long n = this.overflow[index + bitIndex / 16];
            return (int)((n >>>= 4 * (bitIndex & 0xF)) & 0xFL);
        }
        int bitsBefore = Long.bitCount(m & -1L >>> 63 - x);
        int bitPos = Select.selectInLong(c, bitsBefore - 1);
        long y = c << 63 - bitPos << 1 | 1L << 63 - bitPos;
        return Long.numberOfLeadingZeros(y) + 1;
    }

    private void verifyCounts(int from, int to) {
    }

    @Override
    public boolean mayContain(long key) {
        long hash = Hash.hash64(key, this.seed);
        int a = (int)(hash >>> 32);
        int b = (int)hash;
        for (int i = 0; i < this.k; ++i) {
            int index = Hash.reduce(a, this.arraySize) * 64 + (a & 0x3F);
            if (this.data.get(index) == 0L) {
                return false;
            }
            a += b;
        }
        return true;
    }

    static class BitField {
        private final long[] data;

        BitField(int bitCount) {
            this.data = new long[(bitCount + 63) / 64];
        }

        long cardinality() {
            long sum = 0L;
            for (long x : this.data) {
                sum += (long)Long.bitCount(x);
            }
            return sum;
        }

        void clear(int index) {
            int n = index >>> 6;
            this.data[n] = this.data[n] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        }

        void setLong(int longIndex, long x) {
            this.data[longIndex] = x;
        }

        long getLong(int longIndex) {
            return this.data[longIndex];
        }

        long getBitCount() {
            return this.data.length << 6;
        }

        long get(int index) {
            return this.data[index >>> 6] >> index & 1L;
        }

        void set(int index) {
            int n = index >>> 6;
            this.data[n] = this.data[n] | 1L << index;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < this.data.length * 64; ++i) {
                if ((i & 0x3F) == 0) {
                    if (this.data[i >>> 6] == 0L) {
                        i += 63;
                        continue;
                    }
                    buff.append("\n" + i + ":");
                    continue;
                }
                if (this.get(i) == 0L) {
                    buff.append('0');
                    continue;
                }
                buff.append('1');
            }
            return buff.toString();
        }
    }
}

