/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.cuckoo;

import java.util.Random;
import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class Cuckoo16
implements Filter {
    private static final int FINGERPRINT_BITS = 16;
    private static final int ENTRIES_PER_BUCKET = 4;
    private static final long FINGERPRINT_MASK = 65535L;
    private final long seed;
    private final long[] data;
    private final int bucketCount;
    private final Random random = new Random(1L);

    public static Cuckoo16 construct(long[] keys) {
        int len = keys.length;
        while (true) {
            try {
                Cuckoo16 f = new Cuckoo16((int)((double)len / 0.95));
                for (long k : keys) {
                    f.insert(k);
                }
                return f;
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            break;
        }
    }

    public Cuckoo16(int capacity) {
        this.bucketCount = Math.max(1, (int)Math.ceil((double)capacity / 4.0) / 2 * 2);
        this.data = new long[this.bucketCount];
        this.seed = Hash.randomSeed();
    }

    public void insert(long key) {
        long hash = Hash.hash64(key, this.seed);
        this.insertFingerprint(this.getBucket(hash), this.getFingerprint(hash));
    }

    @Override
    public boolean mayContain(long key) {
        int fingerprint;
        long hash = Hash.hash64(key, this.seed);
        int bucket = this.getBucket(hash);
        if (this.bucketContains(bucket, fingerprint = this.getFingerprint(hash))) {
            return true;
        }
        int bucket2 = this.getBucket2(bucket, fingerprint);
        return this.bucketContains(bucket2, fingerprint);
    }

    private int getBucket(long hash) {
        return Hash.reduce((int)hash, this.bucketCount);
    }

    private int getFingerprint(long hash) {
        hash = Hash.hash64(hash, this.seed);
        int fingerprint = (int)(hash & 0xFFFFL);
        return Math.max(1, fingerprint);
    }

    private int getBucket2(int bucket, int fingerprint) {
        long hash = (long)fingerprint * -4265267296055464877L;
        int r = (Hash.reduce((int)hash, this.bucketCount >> 1) << 1) + 1;
        int b2 = this.bucketCount - bucket - r;
        if (b2 < 0) {
            b2 += this.bucketCount;
        }
        return b2;
    }

    private boolean bucketContains(int bucket, int fingerprint) {
        long allFingerprints = this.data[bucket];
        long v = allFingerprints ^ (long)fingerprint * 0x1000100010001L;
        long hasZeroByte = ((v & 0x7FFF7FFF7FFF7FFFL) + 0x7FFF7FFF7FFF7FFFL | v | 0x7FFF7FFF7FFF7FFFL) ^ 0xFFFFFFFFFFFFFFFFL;
        return hasZeroByte != 0L;
    }

    private int getFingerprintAt(int bucket, int entry) {
        return (int)(this.data[bucket] >>> 16 * entry & 0xFFFFL);
    }

    private void setFingerprintAt(int bucket, int entry, int fingerprint) {
        int n = bucket;
        this.data[n] = this.data[n] & (65535L << 16 * entry ^ 0xFFFFFFFFFFFFFFFFL);
        int n2 = bucket;
        this.data[n2] = this.data[n2] | (long)fingerprint << 16 * entry;
    }

    private boolean bucketInsert(int bucket, int fingerprint) {
        for (int entry = 0; entry < 4; ++entry) {
            int fp = this.getFingerprintAt(bucket, entry);
            if (fp == 0) {
                this.setFingerprintAt(bucket, entry, fingerprint);
                return true;
            }
            if (fp != fingerprint) continue;
            return true;
        }
        return false;
    }

    private void insertFingerprint(int bucket, int fingerprint) {
        if (this.bucketInsert(bucket, fingerprint)) {
            return;
        }
        int bucket2 = this.getBucket2(bucket, fingerprint);
        if (this.bucketInsert(bucket2, fingerprint)) {
            return;
        }
        this.swap(bucket2, fingerprint);
    }

    private void swap(int bucket, int fingerprint) {
        for (int n = 0; n < 1000; ++n) {
            int entry = this.random.nextInt() & 3;
            fingerprint = this.bucketsSwap(bucket, entry, fingerprint);
            if (!this.bucketInsert(bucket = this.getBucket2(bucket, fingerprint), fingerprint)) continue;
            return;
        }
        throw new IllegalStateException("Table full");
    }

    private int bucketsSwap(int bucket, int entry, int fingerprint) {
        int old = this.getFingerprintAt(bucket, entry);
        this.setFingerprintAt(bucket, entry, fingerprint);
        return old;
    }

    @Override
    public long getBitCount() {
        return 64 * this.bucketCount;
    }
}

