/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.cuckoo;

import java.util.Random;
import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class Cuckoo8
implements Filter {
    private static final int FINGERPRINT_BITS = 8;
    private static final int ENTRIES_PER_BUCKET = 4;
    private static final int FINGERPRINT_MASK = 255;
    private final int[] data;
    private final long seed;
    private final int bucketCount;
    private final Random random = new Random(1L);

    public static Cuckoo8 construct(long[] keys) {
        int len = keys.length;
        while (true) {
            try {
                Cuckoo8 f = new Cuckoo8((int)((double)len / 0.95));
                for (long k : keys) {
                    f.insert(k);
                }
                return f;
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            break;
        }
    }

    public Cuckoo8(int capacity) {
        this.bucketCount = Math.max(1, (int)Math.ceil((double)capacity / 4.0) / 2 * 2);
        this.data = new int[this.bucketCount];
        this.seed = Hash.randomSeed();
    }

    public void insert(long key) {
        long hash = Hash.hash64(key, this.seed);
        this.insertFingerprint(this.getBucket(hash), this.getFingerprint(hash));
    }

    @Override
    public boolean mayContain(long key) {
        int fingerprint;
        long hash = Hash.hash64(key, this.seed);
        int bucket = this.getBucket(hash);
        if (this.bucketContains(bucket, fingerprint = this.getFingerprint(hash))) {
            return true;
        }
        int bucket2 = this.getBucket2(bucket, fingerprint);
        return this.bucketContains(bucket2, fingerprint);
    }

    private int getBucket(long hash) {
        return Hash.reduce((int)hash, this.bucketCount);
    }

    private int getFingerprint(long hash) {
        hash = Hash.hash64(hash, this.seed);
        int fingerprint = (int)(hash & 0xFFL);
        return Math.max(1, fingerprint);
    }

    private int getBucket2(int bucket, int fingerprint) {
        long hash = (long)fingerprint * -4265267296055464877L;
        int r = (Hash.reduce((int)hash, this.bucketCount >> 1) << 1) + 1;
        int b2 = this.bucketCount - bucket - r;
        if (b2 < 0) {
            b2 += this.bucketCount;
        }
        return b2;
    }

    private boolean bucketContains(int bucket, int fingerprint) {
        int allFingerprints = this.data[bucket];
        int v = allFingerprints ^ fingerprint * 0x1010101;
        int hasZeroByte = ~((v & 0x7F7F7F7F) + 0x7F7F7F7F | v | 0x7F7F7F7F);
        return hasZeroByte != 0;
    }

    private int getFingerprintAt(int bucket, int entry) {
        return this.data[bucket] >>> 8 * entry & 0xFF;
    }

    private void setFingerprintAt(int bucket, int entry, int fingerprint) {
        int n = bucket;
        this.data[n] = this.data[n] & ~(255 << 8 * entry);
        int n2 = bucket;
        this.data[n2] = this.data[n2] | fingerprint << 8 * entry;
    }

    private boolean bucketInsert(int bucket, int fingerprint) {
        for (int entry = 0; entry < 4; ++entry) {
            long fp = this.getFingerprintAt(bucket, entry);
            if (fp == 0L) {
                this.setFingerprintAt(bucket, entry, fingerprint);
                return true;
            }
            if (fp != (long)fingerprint) continue;
            return true;
        }
        return false;
    }

    private void insertFingerprint(int bucket, int fingerprint) {
        if (this.bucketInsert(bucket, fingerprint)) {
            return;
        }
        int bucket2 = this.getBucket2(bucket, fingerprint);
        if (this.bucketInsert(bucket2, fingerprint)) {
            return;
        }
        this.swap(bucket2, fingerprint);
    }

    private void swap(int bucket, int fingerprint) {
        for (int n = 0; n < 1000; ++n) {
            int entry = this.random.nextInt() & 3;
            fingerprint = this.bucketsSwap(bucket, entry, fingerprint);
            if (!this.bucketInsert(bucket = this.getBucket2(bucket, fingerprint), fingerprint)) continue;
            return;
        }
        throw new IllegalStateException("Table full");
    }

    private int bucketsSwap(int bucket, int entry, int fingerprint) {
        int old = this.getFingerprintAt(bucket, entry);
        this.setFingerprintAt(bucket, entry, fingerprint);
        return old;
    }

    @Override
    public long getBitCount() {
        return 32 * this.bucketCount;
    }
}

