/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.cuckoo;

import java.util.Random;
import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class CuckooPlus16
implements Filter {
    private static final int SHIFTED = 1;
    private static final int SECOND = 2;
    private static final int FINGERPRINT_MASK = 16383;
    private short[] data;
    private final long seed;
    private final int bucketCount;
    private final Random random = new Random(1L);

    public static CuckooPlus16 construct(long[] keys) {
        int len = keys.length;
        while (true) {
            CuckooPlus16 f = new CuckooPlus16((int)((double)len / 0.94));
            try {
                for (long k : keys) {
                    f.insert(k);
                }
                return f;
            }
            catch (IllegalStateException illegalStateException) {
                continue;
            }
            break;
        }
    }

    public CuckooPlus16(int capacity) {
        this.bucketCount = (int)Math.ceil(capacity) / 2 * 2;
        this.data = new short[this.bucketCount + 2];
        this.seed = Hash.randomSeed();
    }

    public void insert(long key) {
        long fingerprint;
        long x;
        long hash = Hash.hash64(key, this.seed);
        int bucket = this.getBucket(hash);
        if (this.bucketInsert(bucket, x = (fingerprint = this.getFingerprint(hash)) << 2)) {
            return;
        }
        int bucket2 = this.getBucket2(bucket, x);
        if (this.bucketInsert(bucket2, x | 2L)) {
            return;
        }
        if (this.random.nextBoolean()) {
            this.swap(bucket, x);
        } else {
            this.swap(bucket2, x | 2L);
        }
    }

    private void set(int index, long x) {
        this.data[index] = (short)x;
    }

    private long get(int index) {
        return this.data[index] & 0xFFFF;
    }

    private boolean bucketInsert(int index, long x) {
        long fp = this.get(index);
        if (fp == 0L) {
            this.set(index, x);
            return true;
        }
        if (fp == x) {
            return true;
        }
        x |= 1L;
        if ((fp = this.get(++index)) == 0L) {
            this.set(index, x);
            return true;
        }
        return fp == x;
    }

    private void swap(int index, long x) {
        for (int n = 0; n < 10000; ++n) {
            if (this.random.nextBoolean()) {
                ++index;
                x |= 1L;
            }
            long old = this.get(index);
            this.set(index, x);
            if (old == 0L) {
                throw new AssertionError();
            }
            index = this.getBucket2(index, old);
            old ^= 2L;
            if (this.bucketInsert(index, old &= 0xFFFFFFFFFFFFFFFEL)) {
                return;
            }
            x = old;
        }
        throw new IllegalStateException("Table full");
    }

    private int getBucket2(int index, long x) {
        long fingerprint;
        long hash;
        int r;
        int b2;
        if ((x & 1L) != 0L) {
            --index;
        }
        if ((b2 = this.bucketCount - index - (r = Hash.reduce((int)(hash = (fingerprint = x >> 2) * -4265267296055464877L), this.bucketCount))) < 0) {
            b2 += this.bucketCount;
        }
        return b2;
    }

    @Override
    public boolean mayContain(long key) {
        long hash = Hash.hash64(key, this.seed);
        int bucket = this.getBucket(hash);
        long fingerprint = this.getFingerprint(hash);
        long x = fingerprint << 2;
        if (this.get(bucket) == x) {
            return true;
        }
        if (this.get(bucket + 1) == (x | 1L)) {
            return true;
        }
        int bucket2 = this.getBucket2(bucket, x);
        if (this.get(bucket2) == (x |= 2L)) {
            return true;
        }
        return this.get(bucket2 + 1) == (x | 1L);
    }

    private int getBucket(long hash) {
        return Hash.reduce((int)hash, this.bucketCount);
    }

    private long getFingerprint(long hash) {
        hash = Hash.hash64(hash, this.seed);
        long fingerprint = (int)(hash & 0x3FFFL);
        return Math.max(1L, fingerprint);
    }

    @Override
    public long getBitCount() {
        return 16 * (this.bucketCount + 1);
    }
}

