/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.gcs;

import java.util.Arrays;

public class BitBuffer {
    public final long[] data;
    private int pos;

    public BitBuffer(long bits) {
        this.data = new long[(int)((bits + 63L) / 64L)];
    }

    public void write(BitBuffer bits) {
        int i;
        int count = bits.pos;
        bits.pos = 0;
        for (i = 0; i < count - 31; i += 32) {
            this.writeNumber(bits.readNumber(32), 32);
        }
        while (i < count) {
            this.writeBit(bits.readBit());
            ++i;
        }
    }

    public int position() {
        return this.pos;
    }

    public void seek(int pos) {
        this.pos = pos;
    }

    public long readBit() {
        return this.data[this.pos >>> 6] >>> 63 - (this.pos++ & 0x3F) & 1L;
    }

    public void writeBit(long x) {
        if (x == 1L) {
            int n = this.pos >>> 6;
            this.data[n] = this.data[n] | 1L << 63 - (this.pos & 0x3F);
        }
        ++this.pos;
    }

    public void writeGolombRice(int shift, long value) {
        this.writeGolombRiceFast(shift, value);
    }

    public void writeGolombRiceFast(int shift, long value) {
        long q = value >>> shift;
        if (q < 63L) {
            long m = (2L << (int)q) - 2L;
            this.writeNumber(m, (int)(q + 1L));
        } else {
            int i = 0;
            while ((long)i < q) {
                this.writeBit(1L);
                ++i;
            }
            this.writeBit(0L);
        }
        this.writeNumber(value & (1L << shift) - 1L, shift);
    }

    public void writeEliasDelta(long value) {
        int i;
        if (value <= 0L) {
            throw new IllegalArgumentException();
        }
        int q = 64 - Long.numberOfLeadingZeros(value);
        int qq = 31 - Integer.numberOfLeadingZeros(q);
        for (i = 0; i < qq; ++i) {
            this.writeBit(0L);
        }
        for (i = qq; i >= 0; --i) {
            this.writeBit(q >>> i & 1);
        }
        for (i = q - 2; i >= 0; --i) {
            this.writeBit(value >>> i & 1L);
        }
    }

    public long readEliasDelta() {
        int qq = 0;
        while (this.readBit() == 0L) {
            ++qq;
        }
        long q = 1L;
        for (int i = qq; i > 0; --i) {
            q = q << 1 | this.readBit();
        }
        long x = 1L;
        for (long i = q - 2L; i >= 0L; --i) {
            x = x << 1 | this.readBit();
        }
        return x;
    }

    public long readNumber(int bitCount) {
        long x = this.readNumber(this.pos, bitCount);
        this.pos += bitCount;
        return x;
    }

    public long readNumber(long pos, int bitCount) {
        if (bitCount == 0) {
            return 0L;
        }
        int remainingBits = 64 - ((int)pos & 0x3F);
        int index = (int)(pos >>> 6);
        long x = this.data[index];
        if (bitCount <= remainingBits) {
            return (x >>>= remainingBits - bitCount) & (1L << bitCount) - 1L;
        }
        return (x &= (1L << remainingBits) - 1L) << bitCount - remainingBits | this.data[index + 1] >>> 64 - bitCount + remainingBits;
    }

    public static long foldSigned(long x) {
        return x > 0L ? x * 2L - 1L : -x * 2L;
    }

    public static long unfoldSigned(long x) {
        return (x & 1L) == 1L ? (x + 1L) / 2L : -(x / 2L);
    }

    public int readUntilZero(int pos) {
        int index = pos >>> 6;
        int remainingBits = 64 - (pos & 0x3F);
        long x = this.data[index] << 64 - remainingBits;
        int count = Long.numberOfLeadingZeros(x ^ 0xFFFFFFFFFFFFFFFFL);
        if (count < remainingBits) {
            return count;
        }
        return this.readUntilZeroMore(count, index);
    }

    private int readUntilZeroMore(int count, int index) {
        long x;
        while ((x = this.data[++index]) == -1L) {
            count += 64;
        }
        return count + Long.numberOfLeadingZeros(x ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void writeNumber(long x, int bitCount) {
        if (bitCount == 0) {
            return;
        }
        int remainingBits = 64 - (this.pos & 0x3F);
        int index = this.pos >>> 6;
        if (bitCount <= remainingBits) {
            int n = index;
            this.data[n] = this.data[n] | x << remainingBits - bitCount;
        } else {
            int n = index;
            this.data[n] = this.data[n] | x >>> bitCount - remainingBits;
            int n2 = index + 1;
            this.data[n2] = this.data[n2] | x << 64 - bitCount + remainingBits;
        }
        this.pos += bitCount;
    }

    public void skipGolombRice(int shift) {
        this.pos = this.skipGolombRice(this.pos, shift);
    }

    public int skipGolombRice(int pos, int shift) {
        int q = this.readUntilZero(pos);
        return pos + q + 1 + shift;
    }

    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    public static int getEliasDeltaSize(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException();
        }
        int q = 64 - Long.numberOfLeadingZeros(value);
        int qq = 31 - Integer.numberOfLeadingZeros(q);
        return qq + qq + q;
    }
}

