/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.gcs;

import org.fastfilter.Filter;
import org.fastfilter.gcs.BitBuffer;
import org.fastfilter.gcs.MonotoneList;
import org.fastfilter.gcs.Sort;
import org.fastfilter.utils.Hash;

public class GolombCompressedSet
implements Filter {
    private final long seed;
    private final BitBuffer buff;
    private final int golombShift;
    private final int bufferSize;
    private final int bucketCount;
    private final int fingerprintMask;
    private final MonotoneList start;
    private final int startBuckets;

    public static GolombCompressedSet construct(long[] keys, int setting) {
        return new GolombCompressedSet(keys, keys.length, setting);
    }

    GolombCompressedSet(long[] keys, int len, int fingerprintBits) {
        if (fingerprintBits < 4 || fingerprintBits > 50) {
            throw new IllegalArgumentException();
        }
        this.seed = Hash.randomSeed();
        this.golombShift = fingerprintBits - 1;
        int averageBucketSize = 64;
        long[] data = new long[len];
        this.fingerprintMask = (1 << (fingerprintBits += 6)) - 1;
        this.bucketCount = (len + averageBucketSize - 1) / averageBucketSize;
        for (int i = 0; i < len; ++i) {
            long h = Hash.hash64(keys[i], this.seed);
            long b = Hash.reduce((int)(h >>> 32), this.bucketCount);
            data[i] = b << 32 | h & (long)this.fingerprintMask;
        }
        Sort.sortUnsigned(data, 0, len);
        BitBuffer buckets = new BitBuffer(10L * (long)fingerprintBits * (long)len);
        int[] startList = new int[this.bucketCount + 1];
        int bucket = 0;
        long last = 0L;
        for (int i = 0; i < len; ++i) {
            long x = data[i];
            int b = (int)(x >>> 32);
            while (bucket <= b) {
                startList[bucket++] = buckets.position();
                last = 0L;
            }
            long diff = (x &= (long)this.fingerprintMask) - last;
            last = x;
            buckets.writeGolombRice(this.golombShift, diff);
        }
        while (bucket <= this.bucketCount) {
            startList[bucket++] = buckets.position();
        }
        this.buff = new BitBuffer(10L * (long)fingerprintBits * (long)len);
        this.buff.writeEliasDelta(len + 1);
        this.start = MonotoneList.generate(startList, this.buff);
        this.startBuckets = this.buff.position();
        this.buff.write(buckets);
        this.bufferSize = this.buff.position();
    }

    @Override
    public long getBitCount() {
        return this.bufferSize;
    }

    @Override
    public boolean mayContain(long key) {
        long hashCode = Hash.hash64(key, this.seed);
        int b = Hash.reduce((int)(hashCode >>> 32), this.bucketCount);
        long fingerprint = hashCode & (long)this.fingerprintMask;
        long startPair = this.start.getPair(b);
        int startNext = this.startBuckets + (int)startPair;
        long x = 0L;
        for (int p = this.startBuckets + (int)(startPair >>> 32); p < startNext; p += this.golombShift) {
            long q = this.buff.readUntilZero(p);
            if ((x += q << this.golombShift | this.buff.readNumber(p = (int)((long)p + (q + 1L)), this.golombShift)) == fingerprint) {
                return true;
            }
            if (x > fingerprint) break;
        }
        return false;
    }
}

