/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.gcs;

import org.fastfilter.gcs.BitBuffer;

public class MonotoneList {
    private static final int SHIFT1 = 6;
    private static final int SHIFT2 = 3;
    private static final int FACTOR1 = 32;
    private static final int FACTOR2 = 16;
    private final BitBuffer buffer;
    private final int startLevel1;
    private final int startLevel2;
    private final int startLevel3;
    private final int bitCount1;
    private final int bitCount2;
    private final int bitCount3;
    private final long factor;
    private final int add;

    private MonotoneList(BitBuffer buffer) {
        this.buffer = buffer;
        int count3 = (int)buffer.readEliasDelta() - 1;
        int diff = (int)buffer.readEliasDelta() - 1;
        this.factor = MonotoneList.getScaleFactor(diff, count3);
        this.add = (int)BitBuffer.unfoldSigned(buffer.readEliasDelta() - 1L);
        this.bitCount1 = (int)buffer.readEliasDelta() - 1;
        this.bitCount2 = (int)buffer.readEliasDelta() - 1;
        this.bitCount3 = (int)buffer.readEliasDelta() - 1;
        this.startLevel1 = buffer.position();
        int count2 = count3 + 8 - 1 >> 3;
        int count1 = count3 + 64 - 1 >> 6;
        this.startLevel2 = this.startLevel1 + count1 * this.bitCount1;
        this.startLevel3 = this.startLevel2 + count2 * this.bitCount2;
        buffer.seek(this.startLevel3 + this.bitCount3 * count3);
    }

    private static long getScaleFactor(int multiply, int divide) {
        return divide == 0 ? 0L : ((long)multiply << 32) / (long)divide + 1L;
    }

    public static MonotoneList generate(int[] data, BitBuffer buffer) {
        int i;
        int x;
        int start = buffer.position();
        int count3 = data.length;
        for (int i2 = 1; i2 < count3; ++i2) {
            if (data[i2 - 1] <= data[i2]) continue;
            throw new IllegalArgumentException();
        }
        int diff = data[count3 - 1] - data[0];
        long factor = MonotoneList.getScaleFactor(diff, count3);
        int add = data[0];
        for (int i3 = 1; i3 < count3; ++i3) {
            int expected = (int)((long)i3 * factor >>> 32);
            int x2 = data[i3];
            add = Math.min(add, x2 - expected);
        }
        buffer.writeEliasDelta(count3 + 1);
        buffer.writeEliasDelta(diff + 1);
        buffer.writeEliasDelta(BitBuffer.foldSigned(add) + 1L);
        int count2 = count3 + 8 - 1 >> 3;
        int count1 = count3 + 64 - 1 >> 6;
        int[] group1 = new int[count1];
        int[] group2 = new int[count2];
        int[] group3 = new int[count3];
        for (int i4 = 0; i4 < count3; ++i4) {
            int got = data[i4];
            int expected = (int)((long)i4 * factor >>> 32) + add;
            x = got - expected;
            if (x < 0) {
                throw new AssertionError();
            }
            group3[i4] = x;
        }
        int a = Integer.MAX_VALUE;
        for (i = 0; i < count3; ++i) {
            int x3 = group3[i];
            a = Math.min(a, x3);
            if (i + 1 >> 3 == i >> 3 && i != count3 - 1) continue;
            group2[i >> 3] = a / 16;
            a = Integer.MAX_VALUE;
        }
        a = Integer.MAX_VALUE;
        for (i = 0; i < count3; ++i) {
            int d = group2[i >> 3] * 16;
            x = group3[i];
            int n = i;
            group3[n] = group3[n] - d;
            if (group3[i] < 0) {
                throw new AssertionError();
            }
            a = Math.min(a, x);
            if (i + 1 >> 6 == i >> 6 && i != count3 - 1) continue;
            group1[i >> 6] = a / 32;
            a = Integer.MAX_VALUE;
        }
        int last = -1;
        for (int i5 = 0; i5 < count3; ++i5) {
            int i2 = i5 >> 3;
            if (i2 == last) continue;
            int d = group1[i5 >> 6] * 32;
            int n = i2;
            group2[n] = group2[n] - d / 16;
            last = i2;
        }
        int max1 = 0;
        int max2 = 0;
        int max3 = 0;
        for (int i1 : group3) {
            max3 = Math.max(max3, i1);
        }
        for (int i1 : group2) {
            max2 = Math.max(max2, i1);
        }
        for (int i1 : group1) {
            max1 = Math.max(max1, i1);
        }
        int bitCount1 = 32 - Integer.numberOfLeadingZeros(max1);
        int bitCount2 = 32 - Integer.numberOfLeadingZeros(max2);
        int bitCount3 = 32 - Integer.numberOfLeadingZeros(max3);
        buffer.writeEliasDelta(bitCount1 + 1);
        buffer.writeEliasDelta(bitCount2 + 1);
        buffer.writeEliasDelta(bitCount3 + 1);
        for (int x4 : group1) {
            buffer.writeNumber(x4, bitCount1);
        }
        for (int x4 : group2) {
            buffer.writeNumber(x4, bitCount2);
        }
        for (int x4 : group3) {
            buffer.writeNumber(x4, bitCount3);
        }
        buffer.seek(start);
        return new MonotoneList(buffer);
    }

    public static int getSize(int[] data) {
        int i;
        int x;
        int result = 0;
        int count3 = data.length;
        for (int i2 = 1; i2 < count3; ++i2) {
            if (data[i2 - 1] <= data[i2]) continue;
            throw new IllegalArgumentException();
        }
        int diff = data[count3 - 1] - data[0];
        long factor = MonotoneList.getScaleFactor(diff, count3);
        int add = data[0];
        for (int i3 = 1; i3 < count3; ++i3) {
            int expected = (int)((long)i3 * factor >>> 32);
            int x2 = data[i3];
            add = Math.min(add, x2 - expected);
        }
        result += BitBuffer.getEliasDeltaSize(count3 + 1);
        result += BitBuffer.getEliasDeltaSize(diff + 1);
        result += BitBuffer.getEliasDeltaSize(BitBuffer.foldSigned(add) + 1L);
        int count2 = count3 + 8 - 1 >> 3;
        int count1 = count3 + 64 - 1 >> 6;
        int[] group1 = new int[count1];
        int[] group2 = new int[count2];
        int[] group3 = new int[count3];
        for (int i4 = 0; i4 < count3; ++i4) {
            int got = data[i4];
            int expected = (int)((long)i4 * factor >>> 32) + add;
            x = got - expected;
            if (x < 0) {
                throw new AssertionError();
            }
            group3[i4] = x;
        }
        int a = Integer.MAX_VALUE;
        for (i = 0; i < count3; ++i) {
            int x3 = group3[i];
            a = Math.min(a, x3);
            if (i + 1 >> 3 == i >> 3 && i != count3 - 1) continue;
            group2[i >> 3] = a / 16;
            a = Integer.MAX_VALUE;
        }
        a = Integer.MAX_VALUE;
        for (i = 0; i < count3; ++i) {
            int d = group2[i >> 3] * 16;
            x = group3[i];
            int n = i;
            group3[n] = group3[n] - d;
            if (group3[i] < 0) {
                throw new AssertionError();
            }
            a = Math.min(a, x);
            if (i + 1 >> 6 == i >> 6 && i != count3 - 1) continue;
            group1[i >> 6] = a / 32;
            a = Integer.MAX_VALUE;
        }
        int last = -1;
        for (int i5 = 0; i5 < count3; ++i5) {
            int i2 = i5 >> 3;
            if (i2 == last) continue;
            int d = group1[i5 >> 6] * 32;
            int n = i2;
            group2[n] = group2[n] - d / 16;
            last = i2;
        }
        int max1 = 0;
        int max2 = 0;
        int max3 = 0;
        for (int i1 : group3) {
            max3 = Math.max(max3, i1);
        }
        for (int i1 : group2) {
            max2 = Math.max(max2, i1);
        }
        for (int i1 : group1) {
            max1 = Math.max(max1, i1);
        }
        int bitCount1 = 32 - Integer.numberOfLeadingZeros(max1);
        int bitCount2 = 32 - Integer.numberOfLeadingZeros(max2);
        int bitCount3 = 32 - Integer.numberOfLeadingZeros(max3);
        result += BitBuffer.getEliasDeltaSize(bitCount1 + 1);
        result += BitBuffer.getEliasDeltaSize(bitCount2 + 1);
        result += BitBuffer.getEliasDeltaSize(bitCount3 + 1);
        result += bitCount1 * group1.length;
        result += bitCount2 * group2.length;
        return result += bitCount3 * group3.length;
    }

    public static MonotoneList load(BitBuffer buffer) {
        return new MonotoneList(buffer);
    }

    public int get(int i) {
        int expected = (int)((long)i * this.factor >>> 32) + this.add;
        long a = this.buffer.readNumber(this.startLevel1 + (i >>> 6) * this.bitCount1, this.bitCount1);
        long b = this.buffer.readNumber(this.startLevel2 + (i >>> 3) * this.bitCount2, this.bitCount2);
        long c = this.buffer.readNumber(this.startLevel3 + i * this.bitCount3, this.bitCount3);
        return (int)((long)expected + a * 32L + b * 16L + c);
    }

    public long getPair(int i) {
        return (long)this.get(i) << 32 | (long)this.get(i + 1);
    }
}

