/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.fastfilter.utils.StringUtils;
import org.fastfilter.xorplus.XorPlus8;

public class BuildFilterFile {
    public static final int SEGMENT_BITS = 10;

    public static void main(String ... args) throws IOException {
        Object line;
        if (args.length != 1) {
            System.out.println("Usage: java " + BuildFilterFile.class.getName() + " <filterFile>\nReads a text file from standard in and writes a filter file.\nThe input is a text file that contains sorted SHA-1 hashes and counts.\nYou may get the file from https://haveibeenpwned.com/passwords.");
            return;
        }
        LineNumberReader lineReader = new LineNumberReader(new InputStreamReader((InputStream)new BufferedInputStream(System.in), Charset.forName("LATIN1")));
        long start = System.nanoTime();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(args[0])));
        long outPos = 0L;
        int lines = 0;
        long[] segmentStarts = new long[1024];
        int currentSegment = 0;
        long lastHash = 0L;
        ArrayList<Long> keys = new ArrayList<Long>();
        while ((line = lineReader.readLine()) != null) {
            int segment;
            ++lines;
            long hash = 0L;
            for (int i = 0; i < 16; ++i) {
                hash = hash << 4 | (long)StringUtils.getHex(((String)line).charAt(i));
            }
            if (lastHash == hash) {
                System.out.println("Warning: duplicate 64-bit key detected, ignoring: " + (String)line);
                continue;
            }
            if (Long.compareUnsigned(hash, lastHash) < 0) {
                throw new IllegalArgumentException("The file is not sorted by hash");
            }
            lastHash = hash;
            int dot = ((String)line).lastIndexOf(58);
            int count = Integer.parseInt(((String)line).substring(dot + 1), 10);
            long key = hash ^ hash & 1L;
            if (count > 9) {
                key |= 1L;
            }
            if ((segment = (int)(key >>> 54)) != currentSegment) {
                segmentStarts[currentSegment] = outPos;
                byte[] data = BuildFilterFile.getSegment(keys);
                out.write(data);
                outPos += (long)data.length;
                keys.clear();
                currentSegment = segment;
            }
            if (lines % 10000000 == 0) {
                long time = System.nanoTime() - start;
                System.out.println(lines / 1000000 + " million lines processed, " + time / (long)lines + " ns/line");
            }
            keys.add(key);
        }
        segmentStarts[currentSegment] = outPos;
        out.write(BuildFilterFile.getSegment(keys));
        lineReader.close();
        for (Object s : (Object)segmentStarts) {
            out.writeLong((long)s);
        }
        out.close();
        long time = System.nanoTime() - start;
        System.out.println(lines + " lines processed, " + time / 1000000L / 1000L + " seconds");
    }

    private static byte[] getSegment(ArrayList<Long> keys) {
        long[] array = new long[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            array[i] = keys.get(i);
        }
        return XorPlus8.construct(array).getData();
    }
}

