/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.tools;

import java.io.BufferedInputStream;
import java.io.Console;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Scanner;
import org.fastfilter.tools.BuildFilterFile;
import org.fastfilter.xorplus.XorPlus8;

public class PasswordLookup {
    public static void main(String ... args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java " + PasswordLookup.class.getName() + " <filterFile> \nRequires a filter file generated by " + BuildFilterFile.class.getName());
            return;
        }
        String filterFile = args[0];
        DataInputStream in = PasswordLookup.openFile(filterFile, new File(filterFile).length() - 8192L);
        long[] segmentStarts = new long[1024];
        for (int i = 0; i < segmentStarts.length; ++i) {
            segmentStarts[i] = in.readLong();
        }
        in.close();
        Scanner scanner = new Scanner(System.in);
        while (true) {
            String password;
            Console console;
            if ((console = System.console()) != null) {
                password = new String(console.readPassword("Password? ", new Object[0]));
            } else {
                System.out.println("Password? ");
                password = scanner.nextLine();
            }
            if (password.length() == 0) break;
            PasswordLookup.testPassword(filterFile, segmentStarts, password);
        }
        scanner.close();
    }

    private static void testPassword(String filterFile, long[] segmentStarts, String password) throws Exception {
        Result ascii;
        Result utf8 = PasswordLookup.testPassword(filterFile, segmentStarts, password, "UTF-8");
        Result max = utf8.compareTo(ascii = PasswordLookup.testPassword(filterFile, segmentStarts, password, "ASCII")) >= 0 ? utf8 : ascii;
        System.out.println((Object)max);
    }

    private static Result testPassword(String filterFile, long[] segmentStarts, String password, String charset) throws Exception {
        byte[] passwordBytes = password.getBytes(Charset.forName(charset));
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1 = md.digest(passwordBytes);
        long hash = 0L;
        for (int i = 0; i < 8; ++i) {
            hash = hash << 8 | (long)(sha1[i] & 0xFF);
        }
        long key = hash ^ hash & 1L;
        int segment = (int)(key >>> 54);
        DataInputStream in = PasswordLookup.openFile(filterFile, segmentStarts[segment]);
        XorPlus8 filter = new XorPlus8(in);
        in.close();
        if (filter.mayContain(key)) {
            return Result.FOUND;
        }
        if (filter.mayContain(key | 1L)) {
            return Result.FOUND_COMMON;
        }
        return Result.NOT_FOUND;
    }

    static DataInputStream openFile(String fileName, long skip) throws Exception {
        long skipped;
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        while (skip > 0L && (skipped = in.skip(skip)) > 0L) {
            skip -= skipped;
        }
        return in;
    }

    static enum Result {
        NOT_FOUND("Not found"),
        FOUND("Found"),
        FOUND_COMMON("Found; common");

        private final String message;

        private Result(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }
}

