/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.xor;

import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class Xor16
implements Filter {
    private static final int BITS_PER_FINGERPRINT = 16;
    private static final int HASHES = 3;
    private static final int FACTOR_TIMES_100 = 123;
    private final int blockLength;
    private long seed;
    private short[] fingerprints;
    private final int bitCount;

    @Override
    public long getBitCount() {
        return this.bitCount;
    }

    private static int getArrayLength(int size) {
        return (int)(3L + 123L * (long)size / 100L);
    }

    public static Xor16 construct(long[] keys) {
        return new Xor16(keys);
    }

    public Xor16(long[] keys) {
        int h;
        int hi;
        long seed;
        int reverseOrderPos;
        int size = keys.length;
        int arrayLength = Xor16.getArrayLength(size);
        this.bitCount = arrayLength * 16;
        this.blockLength = arrayLength / 3;
        long[] reverseOrder = new long[size];
        byte[] reverseH = new byte[size];
        do {
            seed = Hash.randomSeed();
            byte[] t2count = new byte[arrayLength];
            long[] t2 = new long[arrayLength];
            for (long k : keys) {
                for (int hi2 = 0; hi2 < 3; ++hi2) {
                    int h2;
                    int n = h2 = this.getHash(k, seed, hi2);
                    t2[n] = t2[n] ^ k;
                    if (t2count[h2] > 120) {
                        throw new IllegalArgumentException();
                    }
                    int n2 = h2;
                    t2count[n2] = (byte)(t2count[n2] + 1);
                }
            }
            int[] alone = new int[arrayLength];
            int alonePos = 0;
            reverseOrderPos = 0;
            int nextAloneCheck = 0;
            while (nextAloneCheck < arrayLength) {
                while (nextAloneCheck < arrayLength) {
                    if (t2count[nextAloneCheck] == 1) {
                        alone[alonePos++] = nextAloneCheck;
                    }
                    ++nextAloneCheck;
                }
                while (alonePos > 0) {
                    int i;
                    if (t2count[i = alone[--alonePos]] == 0) continue;
                    long k = t2[i];
                    int found = -1;
                    for (hi = 0; hi < 3; ++hi) {
                        int n = h = this.getHash(k, seed, hi);
                        t2count[n] = (byte)(t2count[n] - 1);
                        byte newCount = t2count[n];
                        if (newCount == 0) {
                            found = (byte)hi;
                            continue;
                        }
                        if (newCount == 1) {
                            alone[alonePos++] = h;
                        }
                        int n3 = h;
                        t2[n3] = t2[n3] ^ k;
                    }
                    reverseOrder[reverseOrderPos] = k;
                    reverseH[reverseOrderPos] = found;
                    ++reverseOrderPos;
                }
            }
        } while (reverseOrderPos != size);
        this.seed = seed;
        short[] fp = new short[arrayLength];
        for (int i = reverseOrderPos - 1; i >= 0; --i) {
            long k = reverseOrder[i];
            int found = reverseH[i];
            int change = -1;
            long hash = Hash.hash64(k, seed);
            int xor = this.fingerprint(hash);
            for (hi = 0; hi < 3; ++hi) {
                h = this.getHash(k, seed, hi);
                if (found == hi) {
                    change = h;
                    continue;
                }
                xor ^= fp[h];
            }
            fp[change] = (short)xor;
        }
        this.fingerprints = new short[arrayLength];
        System.arraycopy(fp, 0, this.fingerprints, 0, fp.length);
    }

    @Override
    public boolean mayContain(long key) {
        int h2;
        int h1;
        long hash = Hash.hash64(key, this.seed);
        int f = this.fingerprint(hash);
        int r0 = (int)hash;
        int r1 = (int)Long.rotateLeft(hash, 21);
        int r2 = (int)Long.rotateLeft(hash, 42);
        int h0 = Hash.reduce(r0, this.blockLength);
        return ((f ^= this.fingerprints[h0] ^ this.fingerprints[h1 = Hash.reduce(r1, this.blockLength) + this.blockLength] ^ this.fingerprints[h2 = Hash.reduce(r2, this.blockLength) + 2 * this.blockLength]) & 0xFFFF) == 0;
    }

    private int getHash(long key, long seed, int index) {
        long r = Long.rotateLeft(Hash.hash64(key, seed), 21 * index);
        r = Hash.reduce((int)r, this.blockLength);
        return (int)(r += (long)(index * this.blockLength));
    }

    private int fingerprint(long hash) {
        return (int)(hash & 0xFFFFL);
    }
}

