/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.xor;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class Xor8
implements Filter {
    private static final int BITS_PER_FINGERPRINT = 8;
    private static final int HASHES = 3;
    private static final int FACTOR_TIMES_100 = 123;
    private final int size;
    private final int arrayLength;
    private final int blockLength;
    private long seed;
    private byte[] fingerprints;
    private final int bitCount;

    @Override
    public long getBitCount() {
        return this.bitCount;
    }

    private static int getArrayLength(int size) {
        return (int)(3L + 123L * (long)size / 100L);
    }

    public static Xor8 construct(long[] keys) {
        return new Xor8(keys);
    }

    public Xor8(long[] keys) {
        int found;
        long seed;
        int reverseOrderPos;
        this.size = keys.length;
        this.arrayLength = Xor8.getArrayLength(this.size);
        this.bitCount = this.arrayLength * 8;
        this.blockLength = this.arrayLength / 3;
        int m = this.arrayLength;
        long[] reverseOrder = new long[this.size];
        byte[] reverseH = new byte[this.size];
        block0: do {
            seed = Hash.randomSeed();
            byte[] t2count = new byte[m];
            long[] t2 = new long[m];
            for (long k : keys) {
                for (int hi = 0; hi < 3; ++hi) {
                    int h;
                    int n = h = this.getHash(k, seed, hi);
                    t2[n] = t2[n] ^ k;
                    if (t2count[h] > 120) {
                        throw new IllegalArgumentException();
                    }
                    int n2 = h;
                    t2count[n2] = (byte)(t2count[n2] + 1);
                }
            }
            reverseOrderPos = 0;
            int[][] alone = new int[3][this.blockLength];
            int[] alonePos = new int[3];
            for (int nextAlone = 0; nextAlone < 3; ++nextAlone) {
                for (int i = 0; i < this.blockLength; ++i) {
                    if (t2count[nextAlone * this.blockLength + i] != 1) continue;
                    int n = nextAlone;
                    int n3 = alonePos[n];
                    alonePos[n] = n3 + 1;
                    alone[nextAlone][n3] = nextAlone * this.blockLength + i;
                }
            }
            found = -1;
            while (true) {
                int i = -1;
                for (int hi = 0; hi < 3; ++hi) {
                    if (alonePos[hi] <= 0) continue;
                    int n = hi;
                    int n4 = alonePos[n] - 1;
                    alonePos[n] = n4;
                    i = alone[hi][n4];
                    found = hi;
                    break;
                }
                if (i == -1) continue block0;
                if (t2count[i] <= 0) continue;
                long k = t2[i];
                if (t2count[i] != 1) {
                    throw new AssertionError();
                }
                int n = i;
                t2count[n] = (byte)(t2count[n] - 1);
                for (int hi = 0; hi < 3; ++hi) {
                    int h;
                    if (hi == found) continue;
                    int n5 = h = this.getHash(k, seed, hi);
                    t2count[n5] = (byte)(t2count[n5] - 1);
                    byte newCount = t2count[n5];
                    if (newCount == 1) {
                        int n6 = hi;
                        int n7 = alonePos[n6];
                        alonePos[n6] = n7 + 1;
                        alone[hi][n7] = h;
                    }
                    int n8 = h;
                    t2[n8] = t2[n8] ^ k;
                }
                reverseOrder[reverseOrderPos] = k;
                reverseH[reverseOrderPos] = (byte)found;
                ++reverseOrderPos;
            }
        } while (reverseOrderPos != this.size);
        this.seed = seed;
        byte[] fp = new byte[m];
        for (int i = reverseOrderPos - 1; i >= 0; --i) {
            long k = reverseOrder[i];
            found = reverseH[i];
            int change = -1;
            long hash = Hash.hash64(k, seed);
            int xor = this.fingerprint(hash);
            for (int hi = 0; hi < 3; ++hi) {
                int h = this.getHash(k, seed, hi);
                if (found == hi) {
                    change = h;
                    continue;
                }
                xor ^= fp[h];
            }
            fp[change] = (byte)xor;
        }
        this.fingerprints = new byte[m];
        System.arraycopy(fp, 0, this.fingerprints, 0, fp.length);
    }

    @Override
    public boolean mayContain(long key) {
        int h2;
        int h1;
        long hash = Hash.hash64(key, this.seed);
        int f = this.fingerprint(hash);
        int r0 = (int)hash;
        int r1 = (int)Long.rotateLeft(hash, 21);
        int r2 = (int)Long.rotateLeft(hash, 42);
        int h0 = Hash.reduce(r0, this.blockLength);
        return ((f ^= this.fingerprints[h0] ^ this.fingerprints[h1 = Hash.reduce(r1, this.blockLength) + this.blockLength] ^ this.fingerprints[h2 = Hash.reduce(r2, this.blockLength) + 2 * this.blockLength]) & 0xFF) == 0;
    }

    private int getHash(long key, long seed, int index) {
        long r = Long.rotateLeft(Hash.hash64(key, seed), 21 * index);
        r = Hash.reduce((int)r, this.blockLength);
        return (int)(r += (long)(index * this.blockLength));
    }

    private int fingerprint(long hash) {
        return (int)(hash & 0xFFL);
    }

    public byte[] getData() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(out);
            d.writeInt(this.size);
            d.writeLong(this.seed);
            d.write(this.fingerprints);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Xor8(InputStream in) {
        try {
            DataInputStream din = new DataInputStream(in);
            this.size = din.readInt();
            this.arrayLength = Xor8.getArrayLength(this.size);
            this.bitCount = this.arrayLength * 8;
            this.blockLength = this.arrayLength / 3;
            this.seed = din.readLong();
            this.fingerprints = new byte[this.arrayLength];
            din.readFully(this.fingerprints);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

