/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.xor;

import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class XorFuse8
implements Filter {
    private static final int BITS_PER_FINGERPRINT = 8;
    private static final int HASHES = 3;
    private static final int FUSE_ARITY = 3;
    private static final int FUSE_SEGMENT_COUNT = 100;
    private static final int FUSE_SLOTS = 102;
    private final int size;
    private final int segmentLength;
    private final int arrayLength;
    private long seed;
    private byte[] fingerprints;
    private final int bitCount;

    @Override
    public long getBitCount() {
        return this.bitCount;
    }

    private static int getArrayLength(int size, double factor) {
        int capacity = (int)(1.0 / factor * (double)size);
        capacity = (capacity + 102 - 1) / 102 * 102;
        return capacity;
    }

    public static XorFuse8 construct(long[] keys) {
        int size = keys.length;
        double factor = 0.879;
        if (size < 1000) {
            factor = 0.5;
        } else if (size < 10000) {
            factor = 0.7;
        } else if (size < 100000) {
            factor = 0.8;
        }
        while (true) {
            try {
                return new XorFuse8(keys, factor);
            }
            catch (UnsupportedOperationException e) {
                factor -= 0.1;
                continue;
            }
            break;
        }
    }

    public XorFuse8(long[] keys, double factor) {
        int found;
        long seed;
        int reverseOrderPos;
        this.size = keys.length;
        this.arrayLength = XorFuse8.getArrayLength(this.size, factor);
        this.segmentLength = this.arrayLength / 102;
        this.bitCount = this.arrayLength * 8;
        int m = this.arrayLength;
        long[] reverseOrder = new long[this.size];
        byte[] reverseH = new byte[this.size];
        int x = 0;
        do {
            if (++x > 10) {
                throw new UnsupportedOperationException();
            }
            seed = Hash.randomSeed();
            byte[] t2count = new byte[m];
            long[] t2 = new long[m];
            for (long k : keys) {
                for (int hi = 0; hi < 3; ++hi) {
                    int h;
                    int n = h = this.getHash(k, seed, hi);
                    t2[n] = t2[n] ^ k;
                    if (t2count[h] > 120) {
                        throw new IllegalArgumentException();
                    }
                    int n2 = h;
                    t2count[n2] = (byte)(t2count[n2] + 1);
                }
            }
            reverseOrderPos = 0;
            int[] alone = new int[this.arrayLength];
            int alonePos = 0;
            for (int i = 0; i < this.arrayLength; ++i) {
                if (t2count[i] != 1) continue;
                alone[alonePos++] = i;
            }
            found = -1;
            while (alonePos > 0) {
                int i;
                if (t2count[i = alone[--alonePos]] <= 0) continue;
                if (t2count[i] != 1) {
                    throw new AssertionError();
                }
                int n = i;
                t2count[n] = (byte)(t2count[n] - 1);
                long k = t2[i];
                for (int hi = 0; hi < 3; ++hi) {
                    int h;
                    int n3 = h = this.getHash(k, seed, hi);
                    byte by = (byte)(t2count[n3] - 1);
                    t2count[n3] = by;
                    byte newCount = by;
                    if (h == i) {
                        found = hi;
                        continue;
                    }
                    if (newCount == 1) {
                        alone[alonePos++] = h;
                    }
                    int n4 = h;
                    t2[n4] = t2[n4] ^ k;
                }
                reverseOrder[reverseOrderPos] = k;
                reverseH[reverseOrderPos] = (byte)found;
                ++reverseOrderPos;
            }
        } while (reverseOrderPos != this.size);
        this.seed = seed;
        byte[] fp = new byte[m];
        for (int i = reverseOrderPos - 1; i >= 0; --i) {
            long k = reverseOrder[i];
            found = reverseH[i];
            int change = -1;
            long hash = Hash.hash64(k, seed);
            int xor = this.fingerprint(hash);
            for (int hi = 0; hi < 3; ++hi) {
                int h = this.getHash(k, seed, hi);
                if (found == hi) {
                    change = h;
                    continue;
                }
                xor ^= fp[h];
            }
            fp[change] = (byte)xor;
        }
        this.fingerprints = new byte[m];
        System.arraycopy(fp, 0, this.fingerprints, 0, fp.length);
    }

    @Override
    public boolean mayContain(long key) {
        int h2;
        int h1;
        long hash = Hash.hash64(key, this.seed);
        int f = this.fingerprint(hash);
        int r0 = (int)(-4658895280553007687L * hash >> 32);
        int r1 = (int)hash;
        int r2 = (int)Long.rotateLeft(hash, 21);
        int r3 = (int)Long.rotateLeft(hash, 42);
        int seg = Hash.reduce(r0, 100);
        int h0 = (seg + 0) * this.segmentLength + Hash.reduce(r1, this.segmentLength);
        return ((f ^= this.fingerprints[h0] ^ this.fingerprints[h1 = (seg + 1) * this.segmentLength + Hash.reduce(r2, this.segmentLength)] ^ this.fingerprints[h2 = (seg + 2) * this.segmentLength + Hash.reduce(r3, this.segmentLength)]) & 0xFF) == 0;
    }

    private int getHash(long key, long seed, int index) {
        long hash = Hash.hash64(key, seed);
        int r0 = (int)(-4658895280553007687L * hash >> 32);
        int seg = Hash.reduce(r0, 100);
        int r = (int)Long.rotateLeft(hash, 21 * index);
        return (seg + index) * this.segmentLength + Hash.reduce(r, this.segmentLength);
    }

    private int fingerprint(long hash) {
        return (int)(hash & 0xFFL);
    }
}

