/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.xor;

import java.util.Random;
import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;

public class XorSimple
implements Filter {
    private long seed;
    private byte[] data;
    int blockLength;

    @Override
    public long getBitCount() {
        return this.data.length * 8;
    }

    public static XorSimple construct(long[] keys) {
        return new XorSimple(keys);
    }

    XorSimple(long[] keys) {
        long[] stack;
        this.blockLength = (int)(1.23 * (double)keys.length + 32.0) / 3;
        this.data = new byte[3 * this.blockLength];
        do {
            this.seed = new Random().nextLong();
        } while (!this.map(keys, this.seed, stack = new long[keys.length * 2]));
        this.assign(stack, this.data);
    }

    boolean map(long[] keys, long seed, long[] stack) {
        int[] C = new int[3 * this.blockLength];
        long[] H = new long[3 * this.blockLength];
        for (long k : keys) {
            long x = Hash.hash64(k, seed);
            for (int j = 0; j < 3; ++j) {
                int index;
                int n = index = this.h(x, j);
                C[n] = C[n] + 1;
                int n2 = index;
                H[n2] = H[n2] ^ x;
            }
        }
        int[] Q = new int[3 * this.blockLength];
        int qi = 0;
        for (int i = 0; i < C.length; ++i) {
            if (C[i] != 1) continue;
            Q[qi++] = i;
        }
        int si = 0;
        while (si < 2 * keys.length) {
            int i;
            if (C[i = Q[--qi]] != 1) continue;
            long x = H[i];
            stack[si++] = x;
            stack[si++] = i;
            for (int j = 0; j < 3; ++j) {
                int index;
                int n = index = this.h(x, j);
                C[n] = C[n] - 1;
                if (C[index] == 1) {
                    Q[qi++] = index;
                }
                int n3 = index;
                H[n3] = H[n3] ^ x;
            }
        }
        return si == 2 * keys.length;
    }

    void assign(long[] stack, byte[] b) {
        int stackPos = stack.length;
        while (stackPos > 0) {
            int index = (int)stack[--stackPos];
            long x = stack[--stackPos];
            b[index] = (byte)(this.fingerprint(x) ^ b[this.h(x, 0)] ^ b[this.h(x, 1)] ^ b[this.h(x, 2)]);
        }
    }

    int h(long x, int index) {
        return Hash.reduce((int)Long.rotateLeft(x, index * 21), this.blockLength) + index * this.blockLength;
    }

    @Override
    public boolean mayContain(long key) {
        long x = Hash.hash64(key, this.seed);
        return this.fingerprint(x) == (this.data[this.h(x, 0)] ^ this.data[this.h(x, 1)] ^ this.data[this.h(x, 2)]);
    }

    private byte fingerprint(long x) {
        return (byte)x;
    }
}

