/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.xor;

import org.fastfilter.utils.Hash;
import org.fastfilter.xor.XorSimple;

public class XorSimple2
extends XorSimple {
    public static XorSimple construct(long[] keys) {
        return new XorSimple(keys);
    }

    public XorSimple2(long[] keys) {
        super(keys);
    }

    @Override
    boolean map(long[] keys, long seed, long[] stack) {
        int[] C = new int[3 * this.blockLength];
        long[] H = new long[3 * this.blockLength];
        for (long k : keys) {
            long x = Hash.hash64(k, seed);
            for (int j = 0; j < 3; ++j) {
                int index;
                int n = index = this.h(x, j);
                C[n] = C[n] + 1;
                int n2 = index;
                H[n2] = H[n2] ^ x;
            }
        }
        int[][] Q = new int[3][this.blockLength];
        int[] qi = new int[3];
        for (int i = 0; i < C.length; ++i) {
            int b;
            if (C[i] != 1) continue;
            int n = b = i / this.blockLength;
            int n3 = qi[n];
            qi[n] = n3 + 1;
            Q[b][n3] = i;
        }
        int si = 0;
        while (si < 2 * keys.length && qi[0] > 0 || qi[1] > 0 || qi[2] > 0) {
            int i;
            if (qi[0] > 0) {
                qi[0] = qi[0] - 1;
                i = Q[0][qi[0]];
            } else if (qi[1] > 0) {
                qi[1] = qi[1] - 1;
                i = Q[1][qi[1]];
            } else if (qi[2] > 0) {
                qi[2] = qi[2] - 1;
                i = Q[2][qi[2]];
            } else {
                throw new AssertionError();
            }
            if (C[i] != 1) continue;
            long x = H[i];
            stack[si++] = x;
            stack[si++] = i;
            for (int j = 0; j < 3; ++j) {
                int index;
                int n = index = this.h(x, j);
                C[n] = C[n] - 1;
                if (C[index] == 1) {
                    int b;
                    int n4 = b = index / this.blockLength;
                    int n5 = qi[n4];
                    qi[n4] = n5 + 1;
                    Q[b][n5] = index;
                }
                int n6 = index;
                H[n6] = H[n6] ^ x;
            }
        }
        return si == 2 * keys.length;
    }
}

