/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.xorplus;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;

public class Rank9 {
    private final long[] bits;
    private final long[] counts;

    public Rank9(BitSet set, long bitCount) {
        long[] bits = set.toLongArray();
        bits = Arrays.copyOf(bits, 1 + (int)((bitCount + 63L) / 64L));
        this.bits = bits;
        long length = bits.length * 64;
        int numWords = (int)((length + 63L) / 64L);
        int numCounts = (int)((length + 512L - 1L) / 512L) * 2;
        this.counts = new long[numCounts + 1];
        long c = 0L;
        int pos = 0;
        int i = 0;
        while (i < numWords) {
            this.counts[pos] = c;
            c += (long)Long.bitCount(bits[i]);
            for (int j = 1; j < 8; ++j) {
                int n = pos + 1;
                this.counts[n] = this.counts[n] | (i + j <= numWords ? c - this.counts[pos] : 511L) << 9 * (j - 1);
                if (i + j >= numWords) continue;
                c += (long)Long.bitCount(bits[i + j]);
            }
            i += 8;
            pos += 2;
        }
        this.counts[numCounts] = c;
    }

    public long rank(long pos) {
        int word = (int)(pos >>> 6);
        int block = word >> 2 & 0xFFFFFFFE;
        int offset = (word & 7) - 1;
        return this.counts[block] + (this.counts[block + 1] >>> (offset + (offset >>> 28 & 8)) * 9 & 0x1FFL) + (long)Long.bitCount(this.bits[word] & (1L << (int)pos) - 1L);
    }

    public long get(long pos) {
        return this.bits[(int)(pos >>> 6)] >>> (int)pos & 1L;
    }

    public long getAndPartialRank(long pos) {
        int word = (int)(pos >>> 6);
        long x = this.bits[word];
        return (long)(Long.bitCount(x & (1L << (int)pos) - 1L) << 1) + (x >>> (int)pos & 1L);
    }

    public long remainingRank(long pos) {
        int word = (int)(pos >>> 6);
        int block = word >> 2 & 0xFFFFFFFE;
        int offset = (word & 7) - 1;
        return this.counts[block] + (this.counts[block + 1] >>> (offset + (offset >>> 28 & 8)) * 9 & 0x1FFL);
    }

    public int getBitCount() {
        return this.bits.length * 64 + this.counts.length * 64;
    }

    public void write(DataOutputStream d) throws IOException {
        d.writeInt(this.bits.length);
        for (long bit : this.bits) {
            d.writeLong(bit);
        }
        d.writeInt(this.counts.length);
        for (long count : this.counts) {
            d.writeLong(count);
        }
    }

    public Rank9(DataInputStream in) throws IOException {
        int i;
        this.bits = new long[in.readInt()];
        for (i = 0; i < this.bits.length; ++i) {
            this.bits[i] = in.readLong();
        }
        this.counts = new long[in.readInt()];
        for (i = 0; i < this.counts.length; ++i) {
            this.counts[i] = in.readLong();
        }
    }
}

