/*
 * Decompiled with CFR 0.152.
 */
package org.fastfilter.xorplus;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import org.fastfilter.Filter;
import org.fastfilter.utils.Hash;
import org.fastfilter.xorplus.Rank9;

public class XorPlus8
implements Filter {
    private static final int BITS_PER_FINGERPRINT = 8;
    private static final int HASHES = 3;
    private static final int FACTOR_TIMES_100 = 123;
    private final int size;
    private final int arrayLength;
    private final int blockLength;
    private long seed;
    private byte[] fingerprints;
    private int bitCount;
    private Rank9 rank;

    @Override
    public long getBitCount() {
        return this.bitCount;
    }

    private static int getArrayLength(int size) {
        return (int)(3L + 123L * (long)size / 100L);
    }

    public static XorPlus8 construct(long[] keys) {
        return new XorPlus8(keys);
    }

    public XorPlus8(int size, byte[] fingerprints) {
        this.size = size;
        this.arrayLength = XorPlus8.getArrayLength(size);
        this.bitCount = this.arrayLength * 8;
        this.blockLength = this.arrayLength / 3;
        this.fingerprints = fingerprints;
    }

    public XorPlus8(long[] keys) {
        int i;
        int found;
        int reverseOrderPos;
        this.size = keys.length;
        this.arrayLength = XorPlus8.getArrayLength(this.size);
        this.bitCount = this.arrayLength * 8;
        this.blockLength = this.arrayLength / 3;
        int m = this.arrayLength;
        long[] reverseOrder = new long[this.size];
        byte[] reverseH = new byte[this.size];
        long seed = 0L;
        block0: do {
            seed = Hash.randomSeed();
            byte[] t2count = new byte[m];
            long[] t2 = new long[m];
            for (long k : keys) {
                for (int hi = 0; hi < 3; ++hi) {
                    int h;
                    int n = h = this.getHash(k, seed, hi);
                    t2[n] = t2[n] ^ k;
                    if (t2count[h] > 120) {
                        throw new IllegalArgumentException();
                    }
                    int n2 = h;
                    t2count[n2] = (byte)(t2count[n2] + 1);
                }
            }
            reverseOrderPos = 0;
            int[][] alone = new int[3][this.blockLength];
            int[] alonePos = new int[3];
            for (int nextAlone = 0; nextAlone < 3; ++nextAlone) {
                for (int i2 = 0; i2 < this.blockLength; ++i2) {
                    if (t2count[nextAlone * this.blockLength + i2] != 1) continue;
                    int n = nextAlone;
                    int n3 = alonePos[n];
                    alonePos[n] = n3 + 1;
                    alone[nextAlone][n3] = nextAlone * this.blockLength + i2;
                }
            }
            found = -1;
            while (true) {
                int i3 = -1;
                for (int hi = 0; hi < 3; ++hi) {
                    if (alonePos[hi] <= 0) continue;
                    int n = hi;
                    int n4 = alonePos[n] - 1;
                    alonePos[n] = n4;
                    i3 = alone[hi][n4];
                    found = hi;
                    break;
                }
                if (i3 == -1) continue block0;
                if (t2count[i3] <= 0) continue;
                long k = t2[i3];
                if (t2count[i3] != 1) {
                    throw new AssertionError();
                }
                int n = i3;
                t2count[n] = (byte)(t2count[n] - 1);
                for (int hi = 0; hi < 3; ++hi) {
                    int h;
                    if (hi == found) continue;
                    int n5 = h = this.getHash(k, seed, hi);
                    t2count[n5] = (byte)(t2count[n5] - 1);
                    byte newCount = t2count[n5];
                    if (newCount == 1) {
                        int n6 = hi;
                        int n7 = alonePos[n6];
                        alonePos[n6] = n7 + 1;
                        alone[hi][n7] = h;
                    }
                    int n8 = h;
                    t2[n8] = t2[n8] ^ k;
                }
                reverseOrder[reverseOrderPos] = k;
                reverseH[reverseOrderPos] = (byte)found;
                ++reverseOrderPos;
            }
        } while (reverseOrderPos != this.size);
        this.seed = seed;
        byte[] fp = new byte[m];
        for (int i4 = reverseOrderPos - 1; i4 >= 0; --i4) {
            long k = reverseOrder[i4];
            found = reverseH[i4];
            int change = -1;
            long hash = Hash.hash64(k, seed);
            int xor = this.fingerprint(hash);
            for (int hi = 0; hi < 3; ++hi) {
                int h = this.getHash(k, seed, hi);
                if (found == hi) {
                    change = h;
                    continue;
                }
                xor ^= fp[h];
            }
            fp[change] = (byte)xor;
        }
        BitSet set = new BitSet(this.blockLength);
        for (i = 0; i < this.blockLength; ++i) {
            byte f = fp[i + 2 * this.blockLength];
            if (f == 0) continue;
            set.set(i);
        }
        this.rank = new Rank9(set, this.blockLength);
        this.fingerprints = new byte[2 * this.blockLength + set.cardinality()];
        if (2 * this.blockLength >= 0) {
            System.arraycopy(fp, 0, this.fingerprints, 0, 2 * this.blockLength);
        }
        int j = i = 2 * this.blockLength;
        while (i < fp.length) {
            byte f;
            if ((f = fp[i++]) == 0) continue;
            this.fingerprints[j++] = f;
        }
        this.bitCount = this.fingerprints.length * 8 + this.rank.getBitCount();
    }

    @Override
    public boolean mayContain(long key) {
        long hash = Hash.hash64(key, this.seed);
        int f = this.fingerprint(hash);
        int r0 = (int)hash;
        int r1 = (int)(hash >>> 16);
        int r2 = (int)(hash >>> 32);
        int h0 = Hash.reduce(r0, this.blockLength);
        int h1 = Hash.reduce(r1, this.blockLength) + this.blockLength;
        int h2 = Hash.reduce(r2, this.blockLength);
        f ^= this.fingerprints[h0] ^ this.fingerprints[h1];
        long getAndPartialRank = this.rank.getAndPartialRank(h2);
        if ((getAndPartialRank & 1L) == 1L) {
            int h2x = (int)((getAndPartialRank >> 1) + this.rank.remainingRank(h2));
            f ^= this.fingerprints[h2x + 2 * this.blockLength];
        }
        return (f & 0xFF) == 0;
    }

    private int getHash(long key, long seed, int index) {
        int r;
        long hash = Hash.hash64(key, seed);
        switch (index) {
            case 0: {
                r = (int)hash;
                break;
            }
            case 1: {
                r = (int)(hash >>> 16);
                break;
            }
            default: {
                r = (int)(hash >>> 32);
            }
        }
        r = Hash.reduce(r, this.blockLength);
        return r += index * this.blockLength;
    }

    private int fingerprint(long hash) {
        return (int)(hash & 0xFFL);
    }

    public byte[] getData() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream d = new DataOutputStream(out);
            d.writeInt(this.size);
            d.writeLong(this.seed);
            d.writeInt(this.fingerprints.length);
            d.write(this.fingerprints);
            this.rank.write(d);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public XorPlus8(InputStream in) {
        try {
            DataInputStream din = new DataInputStream(in);
            this.size = din.readInt();
            this.arrayLength = XorPlus8.getArrayLength(this.size);
            this.bitCount = this.arrayLength * 8;
            this.blockLength = this.arrayLength / 3;
            this.seed = din.readLong();
            int fingerprintLength = din.readInt();
            this.fingerprints = new byte[fingerprintLength];
            din.readFully(this.fingerprints);
            this.rank = new Rank9(din);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

