/*
 * Decompiled with CFR 0.152.
 */
package io.github.jhipster.loaded.patch.liquibase;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JHipsterTableSnapshotGenerator
extends HibernateSnapshotGenerator {
    private static final Pattern pattern = Pattern.compile("([^\\(]*)\\s*\\(?\\s*(\\d*)?\\s*,?\\s*(\\d*)?\\s*([^\\(]*?)\\)?");

    protected JHipsterTableSnapshotGenerator(Class<? extends DatabaseObject> defaultFor, Class<? extends DatabaseObject>[] addsTo) {
        super(defaultFor, (Class[])addsTo);
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
        Configuration cfg = database.getConfiguration();
        Dialect dialect = database.getDialect();
        Mapping mapping = cfg.buildMapping();
        Table hibernateTable = this.findHibernateTable(example, snapshot);
        if (hibernateTable == null) {
            return null;
        }
        liquibase.structure.core.Table table = new liquibase.structure.core.Table().setName(hibernateTable.getName());
        PrimaryKey primaryKey = null;
        int pkColumnPosition = 0;
        LOG.info("Found table " + table.getName());
        table.setSchema(example.getSchema());
        Iterator columnIterator = hibernateTable.getColumnIterator();
        while (columnIterator.hasNext()) {
            Column hibernateColumn = (Column)columnIterator.next();
            liquibase.structure.core.Column column = new liquibase.structure.core.Column();
            column.setName(hibernateColumn.getName());
            String hibernateType = hibernateColumn.getSqlType(dialect, mapping);
            DataType dataType = this.toDataType(hibernateType, hibernateColumn.getSqlTypeCode());
            if (dataType == null) {
                throw new DatabaseException("Unable to find column data type for column " + hibernateColumn.getName());
            }
            column.setType(dataType);
            LOG.info("Found column " + column.getName() + " " + column.getType().toString());
            column.setRemarks(hibernateColumn.getComment());
            column.setDefaultValue((Object)hibernateColumn.getDefaultValue());
            column.setNullable(Boolean.valueOf(hibernateColumn.isNullable()));
            column.setCertainDataType(false);
            org.hibernate.mapping.PrimaryKey hibernatePrimaryKey = hibernateTable.getPrimaryKey();
            if (hibernatePrimaryKey != null) {
                boolean isPrimaryKeyColumn = false;
                for (Column pkColumn : hibernatePrimaryKey.getColumns()) {
                    if (!pkColumn.getName().equals(hibernateColumn.getName())) continue;
                    isPrimaryKeyColumn = true;
                    break;
                }
                if (isPrimaryKeyColumn) {
                    if (primaryKey == null) {
                        primaryKey = new PrimaryKey();
                        primaryKey.setName(hibernatePrimaryKey.getName());
                    }
                    primaryKey.addColumnName(pkColumnPosition++, column.getName());
                    LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().from(column.getType());
                    if (this.isAutoIncrement(liquibaseDataType) && dialect.getNativeIdentifierGeneratorClass().equals(IdentityGenerator.class)) {
                        column.setAutoIncrementInformation(new Column.AutoIncrementInformation());
                    }
                }
            }
            column.setRelation((Relation)table);
            table.setPrimaryKey(primaryKey);
            table.getColumns().add(column);
        }
        return table;
    }

    protected DataType toDataType(String hibernateType, Integer sqlTypeCode) throws DatabaseException {
        String extra;
        Matcher matcher = pattern.matcher(hibernateType);
        if (!matcher.matches()) {
            return null;
        }
        DataType dataType = new DataType(matcher.group(1));
        if (matcher.group(3).isEmpty()) {
            if (!matcher.group(2).isEmpty()) {
                dataType.setColumnSize(Integer.valueOf(Integer.parseInt(matcher.group(2))));
            }
        } else {
            dataType.setColumnSize(Integer.valueOf(Integer.parseInt(matcher.group(2))));
            dataType.setDecimalDigits(Integer.valueOf(Integer.parseInt(matcher.group(3))));
        }
        if ((extra = StringUtils.trimToNull((String)matcher.group(4))) != null && extra.equalsIgnoreCase("char")) {
            dataType.setColumnSizeUnit(DataType.ColumnSizeUnit.CHAR);
        }
        dataType.setDataTypeId(sqlTypeCode);
        return dataType;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(liquibase.structure.core.Table.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
            Configuration cfg = database.getConfiguration();
            Iterator tableMappings = cfg.getTableMappings();
            while (tableMappings.hasNext()) {
                Table hibernateTable = (Table)tableMappings.next();
                if (!hibernateTable.isPhysicalTable()) continue;
                liquibase.structure.core.Table table = new liquibase.structure.core.Table().setName(hibernateTable.getName());
                table.setSchema(schema);
                LOG.info("Found table " + table.getName());
                schema.addDatabaseObject((DatabaseObject)table);
            }
        }
    }

    private boolean isAutoIncrement(LiquibaseDataType dataType) {
        Method[] methods;
        boolean retVal = false;
        String methodName = "isAutoIncrement";
        for (Method method : methods = dataType.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 0) continue;
            retVal = true;
            break;
        }
        return retVal;
    }
}

