/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.api;

import io.github.jopenlibs.vault.VaultConfig;
import io.github.jopenlibs.vault.VaultException;
import io.github.jopenlibs.vault.api.OperationsBase;
import io.github.jopenlibs.vault.response.HealthResponse;
import io.github.jopenlibs.vault.rest.Rest;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.util.HashSet;

public class Debug
extends OperationsBase {
    private String nameSpace;

    public Debug(VaultConfig config) {
        super(config);
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public Debug withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public HealthResponse health() throws VaultException {
        return this.health(null, null, null, null);
    }

    public HealthResponse health(Boolean standbyOk, Integer activeCode, Integer standbyCode, Integer sealedCode) throws VaultException {
        String path = "sys/health";
        return this.retry(attempt -> {
            Rest rest = this.getRest().url(this.config.getAddress() + "/v1/sys/health").header("X-Vault-Token", this.config.getToken()).header("X-Vault-Namespace", this.nameSpace).header("X-Vault-Request", "true").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext());
            if (standbyOk != null) {
                rest.parameter("standbyok", standbyOk.toString());
            }
            if (activeCode != null) {
                rest.parameter("activecode", activeCode.toString());
            }
            if (standbyCode != null) {
                rest.parameter("standbycode", standbyCode.toString());
            }
            if (sealedCode != null) {
                rest.parameter("sealedcode", sealedCode.toString());
            }
            RestResponse restResponse = rest.get();
            HashSet<Integer> validCodes = new HashSet<Integer>();
            validCodes.add(200);
            validCodes.add(429);
            validCodes.add(500);
            if (activeCode != null) {
                validCodes.add(activeCode);
            }
            if (standbyCode != null) {
                validCodes.add(standbyCode);
            }
            if (sealedCode != null) {
                validCodes.add(sealedCode);
            }
            if (!validCodes.contains(restResponse.getStatus())) {
                throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
            }
            return new HealthResponse(restResponse, attempt);
        });
    }
}

