/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure;

import io.grpc.Status;
import java.util.Optional;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.lognet.springboot.grpc.FailureHandlingSupport;
import org.lognet.springboot.grpc.GRpcErrorHandler;
import org.lognet.springboot.grpc.GRpcGlobalInterceptor;
import org.lognet.springboot.grpc.autoconfigure.ConditionalOnMissingErrorHandler;
import org.lognet.springboot.grpc.autoconfigure.GRpcValidationProperties;
import org.lognet.springboot.grpc.recovery.ErrorHandlerAdapter;
import org.lognet.springboot.grpc.recovery.GRpcExceptionHandler;
import org.lognet.springboot.grpc.recovery.GRpcExceptionScope;
import org.lognet.springboot.grpc.recovery.GRpcServiceAdvice;
import org.lognet.springboot.grpc.validation.ValidatingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnClass(value={Validator.class})
@EnableConfigurationProperties(value={GRpcValidationProperties.class})
public class GRpcValidationConfiguration {
    @Bean
    @ConditionalOnBean(value={Validator.class})
    @GRpcGlobalInterceptor
    public ValidatingInterceptor validatingInterceptor(@Lazy Validator validator, GRpcValidationProperties validationProperties, @Lazy FailureHandlingSupport failureHandlingSupport) {
        return new ValidatingInterceptor(validator, failureHandlingSupport).order(validationProperties.getInterceptorOrder());
    }

    @ConditionalOnMissingErrorHandler(value=ConstraintViolationException.class)
    @Configuration
    static class DefaultValidationHandlerConfig {
        DefaultValidationHandlerConfig() {
        }

        @GRpcServiceAdvice
        public static class DefaultValidationErrorHandler
        extends ErrorHandlerAdapter {
            private static final Logger log = LoggerFactory.getLogger(DefaultValidationErrorHandler.class);

            public DefaultValidationErrorHandler(Optional<GRpcErrorHandler> errorHandler) {
                super(errorHandler);
            }

            @GRpcExceptionHandler
            public Status handle(ConstraintViolationException e, GRpcExceptionScope scope) {
                return this.handle((Exception)e, scope.getHintAs(Status.class).get(), scope);
            }
        }
    }
}

