/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.autoconfigure.consul;

import java.util.List;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.autoconfigure.GRpcServerProperties;
import org.lognet.springboot.grpc.context.GRpcServerInitializedEvent;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;

public class GrpcConsulRegistrar
implements SmartLifecycle {
    private final ConsulServiceRegistry consulServiceRegistry;
    private List<ConsulRegistration> registrations;

    public GrpcConsulRegistrar(ConsulServiceRegistry consulServiceRegistry) {
        this.consulServiceRegistry = consulServiceRegistry;
    }

    @EventListener
    public void onGrpcServerStarted(GRpcServerInitializedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        GRpcServerProperties.ConsulProperties gRpcConsulProperties = ((GRpcServerProperties)applicationContext.getBean(GRpcServerProperties.class)).getConsul();
        this.registrations = gRpcConsulProperties.getRegistrationMode().createServices(event.getServer(), applicationContext).stream().map(s -> new ConsulRegistration(s, gRpcConsulProperties.getDiscovery())).collect(Collectors.toList());
        this.registrations.forEach(arg_0 -> ((ConsulServiceRegistry)this.consulServiceRegistry).register(arg_0));
    }

    public boolean isAutoStartup() {
        return false;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
    }

    public synchronized void stop() {
        this.registrations.forEach(arg_0 -> ((ConsulServiceRegistry)this.consulServiceRegistry).deregister(arg_0));
        this.consulServiceRegistry.close();
        this.registrations = null;
    }

    public synchronized boolean isRunning() {
        return null != this.registrations;
    }

    public int getPhase() {
        return 0;
    }
}

