/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.lognet.springboot.grpc.security.AuthenticationSchemeRegistry;
import org.lognet.springboot.grpc.security.AuthenticationSchemeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

class AuthenticationSchemeService
implements AuthenticationSchemeRegistry,
AuthenticationSchemeSelector {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationSchemeService.class);
    private List<AuthenticationSchemeSelector> selectors = new ArrayList<AuthenticationSchemeSelector>();

    AuthenticationSchemeService() {
    }

    @Override
    public Optional<Authentication> getAuthScheme(CharSequence authorization) {
        List auth = this.selectors.stream().map(selector -> selector.getAuthScheme(authorization)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        switch (auth.size()) {
            case 0: {
                throw new IllegalStateException(String.format("Authentication scheme '%s' is not supported.", Optional.ofNullable(authorization).map(s -> s.toString().split(" ", 2)[0]).orElse(null)));
            }
            case 1: {
                return Optional.of((Authentication)auth.get(0));
            }
        }
        throw new IllegalStateException("Ambiguous authentication scheme " + authorization.toString());
    }

    @Override
    public AuthenticationSchemeRegistry register(AuthenticationSchemeSelector selector) {
        this.selectors.add(selector);
        return this;
    }
}

