/*
 * Decompiled with CFR 0.152.
 */
package org.lognet.springboot.grpc.recovery;

import io.grpc.Status;
import java.util.Optional;
import org.lognet.springboot.grpc.GRpcErrorHandler;
import org.lognet.springboot.grpc.recovery.GRpcExceptionScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlerAdapter.class);
    private final Optional<GRpcErrorHandler> errorHandler;

    public ErrorHandlerAdapter(Optional<GRpcErrorHandler> errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected Status handle(Exception e, Status status, GRpcExceptionScope scope) {
        if (this.errorHandler.isPresent()) {
            return this.errorHandler.get().handle(scope.getRequestOrResponse(), status, e, scope.getCallHeaders(), scope.getResponseHeaders());
        }
        log.error("Got error with status {} ", (Object)status.getCode().name(), (Object)e);
        return status.withDescription(e.getMessage());
    }
}

